/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.wizards;

import com.ibm.team.apt.common.IIterationPlanRecord;
import com.ibm.team.apt.common.IIterationPlanRecordHandle;
import com.ibm.team.apt.ide.ui.PlanningUI;
import com.ibm.team.apt.internal.client.IIterationPlanClient;
import com.ibm.team.apt.internal.client.IterationPlanClient;
import com.ibm.team.apt.internal.client.IterationPlanData;
import com.ibm.team.apt.internal.client.IterationPlanSaveResult;
import com.ibm.team.apt.internal.client.IterationPlanWizardContext;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.wiki.Attachments;
import com.ibm.team.apt.internal.client.wiki.IWikiPageSafeRunnable;
import com.ibm.team.apt.internal.client.wiki.WikiClient;
import com.ibm.team.apt.internal.client.wiki.WikiManager;
import com.ibm.team.apt.internal.common.util.ItemList;
import com.ibm.team.apt.internal.common.wiki.IWikiPage;
import com.ibm.team.apt.internal.common.wiki.IWikiPageAttachment;
import com.ibm.team.apt.internal.common.wiki.IWikiPageHandle;
import com.ibm.team.apt.internal.ide.core.PlanAddedEvent;
import com.ibm.team.apt.internal.ide.core.PlanEvent;
import com.ibm.team.apt.internal.ide.core.PlanModel;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.actions.AddAttachmentAction;
import com.ibm.team.apt.internal.ide.ui.util.ExceptionHandler;
import com.ibm.team.apt.internal.ide.ui.util.TeamRunnable;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.apt.internal.ide.ui.wizards.DuplicateIterationPlanData;
import com.ibm.team.apt.internal.ide.ui.wizards.DuplicateIterationPlanWizardPage;
import com.ibm.team.apt.internal.ide.ui.wizards.DuplicatePagesFoldersPage;
import com.ibm.team.apt.internal.ide.ui.wizards.Messages;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.foundation.common.util.XMLMemento;
import com.ibm.team.repository.client.IContentManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IWorkbenchSite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DuplicateIterationPlanWizard
extends Wizard {
    private DuplicateIterationPlanWizardPage fDuplicatePlanPage;
    private DuplicatePagesFoldersPage fDuplicatePagesPage;
    private boolean fCanFinish = true;
    private IWorkbenchSite fSite;

    public DuplicateIterationPlanWizard(IWorkbenchSite site, IterationPlanWizardContext context) {
        this.fSite = site;
        this.fDuplicatePlanPage = new DuplicateIterationPlanWizardPage(context);
        this.addPage((IWizardPage)this.fDuplicatePlanPage);
        this.fDuplicatePagesPage = new DuplicatePagesFoldersPage();
        this.addPage((IWizardPage)this.fDuplicatePagesPage);
    }

    public boolean needsProgressMonitor() {
        return true;
    }

    public boolean performFinish() {
        final IIterationPlanRecord[] result = new IIterationPlanRecord[1];
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)new TeamRunnable(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public void execute(IProgressMonitor monitor) throws TeamRepositoryException {
                    IIterationPlanRecord plan = DuplicateIterationPlanWizard.this.fDuplicatePlanPage.getResult();
                    ITeamRepository repository = PlanningClientPlugin.getTeamRepository((IItemHandle)DuplicateIterationPlanWizard.this.fDuplicatePlanPage.getContext().getIterationPlanHandle());
                    IIterationPlanClient client = PlanningClientPlugin.getIterationPlanClient((ITeamRepository)repository);
                    IterationPlanData orginalIterationPlanData = ((DuplicateIterationPlanData)DuplicateIterationPlanWizard.this.fDuplicatePlanPage.getTeamFuture().getResult()).getOrginalIterationPlanData();
                    final IterationPlanSaveResult saveResult = ((IterationPlanClient)client).create(plan, monitor);
                    if (saveResult.getStatus().getSeverity() == 0) {
                        IIterationPlanRecord savedPlan = saveResult.getPlanRecord();
                        PlanModel.INSTANCE.firePlanEvent((PlanEvent)new PlanAddedEvent(repository, savedPlan));
                        result[0] = savedPlan;
                        WikiManager manager = WikiClient.getWikiManager((IItem)savedPlan);
                        ItemList pages = orginalIterationPlanData.getWikiPages();
                        DuplicateIterationPlanWizard.this.duplicateAttachedPages(manager, (ItemList<IWikiPage>)pages, savedPlan, monitor);
                        if (!DuplicateIterationPlanWizard.this.fDuplicatePagesPage.shouldCopyMyFolders() || orginalIterationPlanData.getPlanRecord().getAuxiliaryData() == null) return;
                        IContent content = orginalIterationPlanData.getPlanRecord().getAuxiliaryData();
                        IContentManager contentManager = repository.contentManager();
                        InputStream inStream = contentManager.retrieveContentStream(content, monitor);
                        try {
                            XMLMemento data = XMLMemento.createReadRoot((Reader)new InputStreamReader(inStream));
                            DuplicateIterationPlanWizard.close(inStream);
                            IterationPlanSaveResult result2 = ((IterationPlanClient)client).save(orginalIterationPlanData.canSavePlan(), savedPlan, null, new WorkItemWorkingCopy[0], data, new IWikiPageSafeRunnable[0], monitor);
                            if (!result2.getStatus().isOK()) return;
                            result[0] = result2.getPlanRecord();
                            return;
                        }
                        catch (IOException e) {
                            throw new TeamRepositoryException((Throwable)e);
                        }
                        catch (CoreException e) {
                            throw new TeamRepositoryException((Throwable)e);
                        }
                    } else {
                        if (saveResult.getStatus().getSeverity() != 4) return;
                        UI.syncExec(DuplicateIterationPlanWizard.this.fDuplicatePlanPage.getControl(), new Runnable(){

                            public void run() {
                                DuplicateIterationPlanWizard.this.fCanFinish = false;
                                DuplicateIterationPlanWizard.this.fDuplicatePlanPage.setErrorMessage(saveResult.getStatus().getDetails());
                            }
                        });
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), Messages.DuplicateIterationPlanWizard_FAILURE_DUPLICATE_PLAN, e.getLocalizedMessage());
            this.fCanFinish = false;
        }
        catch (InterruptedException interruptedException) {}
        if (result[0] != null) {
            PlanningUI.openIterationPlanEditor((IIterationPlanRecordHandle)result[0], this.fSite.getWorkbenchWindow().getWorkbench().getActiveWorkbenchWindow().getActivePage());
            return true;
        }
        this.getContainer().updateButtons();
        return false;
    }

    private void duplicateAttachedPages(WikiManager manager, ItemList<IWikiPage> pages, IIterationPlanRecord targetPlan, IProgressMonitor monitor) throws TeamRepositoryException {
        for (IWikiPage page : pages) {
            IWikiPage newPage;
            if (!this.fDuplicatePagesPage.shouldCreateCopy(page) || (newPage = "overview".equals(page.getWikiID()) ? manager.findPageUsingOwner((IItemHandle)targetPlan, "overview", monitor) : manager.createPageUsingOwner((IItemHandle)targetPlan, page.getWikiID(), page.getLabel(), monitor)) == null || !this.fDuplicatePagesPage.shouldCopyContent(page)) continue;
            List attachments = manager.findAttachments(page, monitor);
            if (!attachments.isEmpty()) {
                List<IWikiPageAttachment> result = DuplicateIterationPlanWizard.copyAttachments(attachments, newPage, monitor);
                DuplicateIterationPlanWizard.saveAttachments(manager, result, monitor);
            }
            String content = DuplicateIterationPlanWizard.getContent(page, monitor);
            try {
                manager.savePage(newPage, XMLString.createFromXMLText((String)content), monitor);
            }
            catch (IOException e) {
                throw new TeamRepositoryException((Throwable)e);
            }
        }
    }

    private static List<IWikiPageAttachment> copyAttachments(List<IWikiPageAttachment> attachments, IWikiPage toWikiPage, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IWikiPageAttachment> result = new ArrayList<IWikiPageAttachment>(attachments.size());
        ITeamRepository repository = PlanningClientPlugin.getTeamRepository((IItemHandle)toWikiPage);
        IContentManager contentManager = repository.contentManager();
        for (IWikiPageAttachment attachment : attachments) {
            if (Attachments.isPredefined((IWikiPageAttachment)attachment, (IProgressMonitor)monitor)) continue;
            IContent content = attachment.getContent();
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            contentManager.retrieveContent(content, (OutputStream)outStream, monitor);
            ByteArrayInputStream inStream = new ByteArrayInputStream(outStream.toByteArray());
            IWikiPageAttachment newAttachment = AddAttachmentAction.createAttachmentFromStream(contentManager, inStream, content.getContentType(), content.getCharacterEncoding(), monitor);
            newAttachment.setName(attachment.getName());
            newAttachment.setDescription(attachment.getDescription());
            newAttachment.setOwner((IWikiPageHandle)toWikiPage);
            newAttachment.setCreator((IContributorHandle)repository.loggedInContributor());
            result.add(newAttachment);
        }
        return result;
    }

    private static void saveAttachments(WikiManager manager, List<IWikiPageAttachment> attachments, IProgressMonitor monitor) throws TeamRepositoryException {
        for (IWikiPageAttachment attachment : attachments) {
            manager.saveAttachment(attachment, monitor);
        }
    }

    private static String getContent(IWikiPage page, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isNotNull((Object)page);
        Assert.isTrue((boolean)page.isPropertySet(IWikiPage.CONTENT_PROPERTY));
        IContent content = page.getContent();
        IContentManager manager = PlanningClientPlugin.getTeamRepository((IItemHandle)page).contentManager();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        manager.retrieveContent(content, (OutputStream)out, monitor);
        try {
            return new String(out.toByteArray(), content.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    private static void close(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException iOException) {}
    }

    public boolean canFinish() {
        return this.fCanFinish && super.canFinish();
    }
}

