/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.wizards;

import com.ibm.team.apt.common.IIterationPlanRecord;
import com.ibm.team.apt.internal.client.IterationPlanClient;
import com.ibm.team.apt.internal.client.IterationPlanWizardContext;
import com.ibm.team.apt.internal.client.NewIterationPlanData;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.util.IterationClient;
import com.ibm.team.apt.internal.common.IterationPlanNoTeamAreaException;
import com.ibm.team.apt.internal.ide.core.util.TeamFuture;
import com.ibm.team.apt.internal.ide.ui.navigator.ExtendedTeamAreaSelectionDialog;
import com.ibm.team.apt.internal.ide.ui.util.DisplayRunnable;
import com.ibm.team.apt.internal.ide.ui.util.IterationSelectionDialog;
import com.ibm.team.apt.internal.ide.ui.util.Result;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.apt.internal.ide.ui.util.WizardTeamCallable;
import com.ibm.team.apt.internal.ide.ui.wizards.Messages;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.common.ITeamAreaHierarchy;
import com.ibm.team.process.common.ProcessCommon;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import com.ibm.team.workitem.rcp.ui.internal.ProjectAreaPicker;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIterationPlanWizardPage<T>
extends WizardPage {
    private Text fName;
    private Text fProjectArea;
    private Button fBrowseProjectArea;
    private Text fTeamArea;
    private Button fBrowseTeamArea;
    private Text fIteration;
    private Button fBrowseIterations;
    private volatile boolean fInitial = true;
    private boolean fInitialCategorySelection = true;
    protected boolean fCanSave = true;
    protected IterationPlanWizardContext fContext;
    protected IIterationPlanRecord fResult;
    protected NewIterationPlanData fNewIterationPlanData;
    protected IIterationPlanRecord fCurrentRecord;
    protected TeamFuture<T> fTeamFuture;
    private String fHelpContextId;

    public AbstractIterationPlanWizardPage(IterationPlanWizardContext context, String pageName, String title, String helpContextId) {
        super(pageName, title, null);
        this.fContext = context;
        if (this.fContext.isValid()) {
            this.fTeamFuture = this.computeFuture();
        }
        this.fHelpContextId = helpContextId;
    }

    public IIterationPlanRecord getResult() {
        if (this.fResult == null) {
            new DisplayRunnable(this.getShell().getDisplay()){

                public void execute() {
                    AbstractIterationPlanWizardPage.this.computeResult();
                }
            }.syncExec();
        }
        return this.fResult;
    }

    public NewIterationPlanData getInput() {
        return this.fNewIterationPlanData;
    }

    public IterationPlanWizardContext getContext() {
        return this.fContext;
    }

    public abstract void computeResult();

    protected void processSplittedItervals(List<IIteration>[] split) {
    }

    protected void setInput(NewIterationPlanData input, IIterationPlanRecord iterationPlan) {
        Assert.isNotNull((Object)input);
        this.fNewIterationPlanData = input;
        this.fCurrentRecord = iterationPlan;
        this.fCanSave = input.canSave();
        this.fContext.setSelectedProjectArea((IProjectAreaHandle)input.getProjectArea());
        this.updateProjectArea();
        List primaryTeamAreaPath = input.getPrimaryTeamAreaPath();
        if (primaryTeamAreaPath != null) {
            String buffer = this.teamAreaPathToString(primaryTeamAreaPath);
            this.fContext.setTeamArea((ITeamAreaHandle)primaryTeamAreaPath.get(primaryTeamAreaPath.size() - 1));
            this.fTeamArea.setText(buffer);
        }
        if (iterationPlan == null) {
            if (this.fContext.getIteration() == null) {
                this.fContext.setIteration((IIterationHandle)input.getCurrentIteration());
                this.fContext.setDevelopmentLineHandle((IDevelopmentLineHandle)input.getDevelopmentLine());
            } else if (this.fContext.getDevelopmentLineHandle() == null) {
                this.fContext.setDevelopmentLineHandle((IDevelopmentLineHandle)input.getDevelopmentLine());
            }
            this.deferredUpdateSelectedIteration(this.fContext.getIteration());
        } else {
            this.fContext.setIteration(iterationPlan.getIteration());
            this.deferredUpdateSelectedIteration(this.fContext.getIteration());
            this.fName.setText(iterationPlan.getName());
        }
        this.fName.setFocus();
    }

    public void setVisible(boolean visible) {
        if (this.fInitial) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    AbstractIterationPlanWizardPage.this.updateFromContext();
                    AbstractIterationPlanWizardPage.this.fInitial = false;
                }
            });
        }
        super.setVisible(visible);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        this.createNamePart(composite);
        this.createProjectArea(composite);
        this.createTeamAreaPart(composite);
        this.createIterationPart(composite);
        this.setControl((Control)composite);
        this.updateStatus();
        Dialog.applyDialogFont((Control)parent);
        if (this.fHelpContextId != null) {
            UI.hookHelpListener((Control)composite, this.fHelpContextId);
        }
    }

    private void createNamePart(Composite result) {
        this.createLabel(result, Messages.AbstractIterationPlanWizardPage_PLAN_NAME);
        this.fName = new Text(result, 2048);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.widthHint = this.convertWidthInCharsToPixels(40);
        this.fName.setLayoutData((Object)gd);
        this.fName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractIterationPlanWizardPage.this.fContext.setName(AbstractIterationPlanWizardPage.this.fName.getText());
                AbstractIterationPlanWizardPage.this.updateStatus();
            }
        });
    }

    private void createProjectArea(final Composite parent) {
        this.createLabel(parent, Messages.AbstractIterationPlanWizardPage_LABEL_PROJECT_AREA);
        this.fProjectArea = new Text(parent, 2056);
        this.fProjectArea.setBackground(parent.getBackground());
        GridData gd = new GridData(768);
        this.fProjectArea.setLayoutData((Object)gd);
        if (this.fContext.getSelectedProjectArea() != null) {
            this.fProjectArea.setText(this.getProjectAreaName(this.fContext.getSelectedProjectArea()));
        }
        this.fBrowseProjectArea = new Button(parent, 0);
        this.fBrowseProjectArea.setText(Messages.AbstractIterationPlanWizardPage_BROWSE_PROJECT_AREA);
        this.fBrowseProjectArea.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IProjectAreaHandle projectArea = WorkItemUI.selectProjectArea((Shell)parent.getShell());
                if (projectArea != null) {
                    AbstractIterationPlanWizardPage.this.updateProjectArea(projectArea);
                }
            }
        });
        this.fBrowseProjectArea.setEnabled(this.fContext.getProjectAreas().size() > 1);
    }

    private void createTeamAreaPart(Composite parent) {
        this.createLabel(parent, Messages.AbstractIterationPlanWizardPage_LABEL_TEAM_AREA);
        this.fTeamArea = new Text(parent, 2056);
        this.fTeamArea.setBackground(parent.getBackground());
        GridData gd = new GridData(768);
        this.fTeamArea.setLayoutData((Object)gd);
        this.fBrowseTeamArea = new Button(parent, 0);
        this.fBrowseTeamArea.setText(Messages.AbstractIterationPlanWizardPage_BROWSE_TEAM_AREA);
        this.fBrowseTeamArea.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedTeamAreaSelectionDialog tasd = new ExtendedTeamAreaSelectionDialog(AbstractIterationPlanWizardPage.this.getShell());
                tasd.setInput(AbstractIterationPlanWizardPage.this.fContext.getSelectedProjectArea());
                if (tasd.open() == 0) {
                    AbstractIterationPlanWizardPage.this.fContext.setTeamArea((ITeamAreaHandle)tasd.getSelectedTeamArea());
                    AbstractIterationPlanWizardPage.this.fTeamArea.setText(tasd.getQualifiedTeamAreaName());
                    AbstractIterationPlanWizardPage.this.updateTeamArea();
                    AbstractIterationPlanWizardPage.this.updateStatus();
                }
            }
        });
    }

    private void createIterationPart(Composite parent) {
        this.createLabel(parent, Messages.AbstractIterationPlanWizardPage_LABEL_ITERATION);
        this.fIteration = new Text(parent, 2056);
        this.fIteration.setBackground(parent.getBackground());
        this.fIteration.setLayoutData((Object)new GridData(768));
        this.fBrowseIterations = new Button(parent, 8);
        this.fBrowseIterations.setText(Messages.AbstractIterationPlanWizardPage_BROWSE_ITERATION);
        this.fBrowseIterations.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IterationSelectionDialog dialog = new IterationSelectionDialog(AbstractIterationPlanWizardPage.this.getShell(), AbstractIterationPlanWizardPage.this.fContext.getIteration());
                dialog.setInput(AbstractIterationPlanWizardPage.this.fContext.getDevelopmentLineHandle());
                switch (dialog.open()) {
                    case 0: {
                        AbstractIterationPlanWizardPage.this.updateSelectedIteration((IIteration)dialog.getResult()[0]);
                        AbstractIterationPlanWizardPage.this.updateStatus();
                    }
                }
            }
        });
    }

    private Label createLabel(Composite result, String text) {
        Label label = new Label(result, 0);
        label.setText(text);
        return label;
    }

    private String getProjectAreaName(IProjectAreaHandle projectArea) {
        return ProjectAreaPicker.getUnambiguousProjectName((List)ProjectAreaPicker.getAllConnectedProjectAreas((boolean)true), (IProjectAreaHandle)projectArea);
    }

    private void updateFromContext() {
        this.updateProjectArea();
        this.updateTeamArea();
        this.resolveFuture();
    }

    protected void updateStatus() {
        String message = null;
        int type = 3;
        if (!this.fCanSave) {
            message = Messages.AbstractIterationPlanWizardPage_MSG_NO_PERMISSIONS;
        } else if (this.fContext.getName() == null || this.fContext.getName().length() == 0) {
            message = Messages.AbstractIterationPlanWizardPage_MSG_PROVIDE_NAME;
            type = 0;
        } else if (this.fContext.getName().trim().length() == 0) {
            message = Messages.AbstractIterationPlanWizardPage_MSG_NAME_NOT_EMPTY;
        } else if (this.fContext.getSelectedProjectArea() == null) {
            message = Messages.AbstractIterationPlanWizardPage_MSG_PROVIDE_PROJECT_AREA;
        } else if (this.fContext.getTeamArea() == null) {
            message = Messages.AbstractIterationPlanWizardPage_MSG_PROVIDE_TEAM_AREA;
        } else if (this.fContext.getIteration() == null) {
            message = Messages.AbstractIterationPlanWizardPage_MSG_PROVIDE_ITERATION;
        }
        type = !this.fCanSave ? 1 : (this.fInitial || this.fInitialCategorySelection ? 0 : type);
        this.setMessage(message, type);
        this.setPageComplete(message == null);
    }

    public void setErrorMessage(String msg) {
        this.setMessage(msg, 3);
    }

    public TeamFuture<T> getTeamFuture() {
        return this.fTeamFuture;
    }

    protected abstract TeamFuture<T> computeFuture();

    protected abstract void futureResolved(T var1);

    protected void resolveFuture() {
        Result result = new WizardTeamCallable<T>(){

            @Override
            protected T execute(IProgressMonitor monitor) throws TeamRepositoryException, InvocationTargetException, InterruptedException {
                monitor.beginTask(Messages.AbstractIterationPlanWizardPage_MONITOR_FETCHING_DATA, -1);
                if (AbstractIterationPlanWizardPage.this.fTeamFuture == null) {
                    AbstractIterationPlanWizardPage.this.fTeamFuture = AbstractIterationPlanWizardPage.this.computeFuture();
                }
                Object result = AbstractIterationPlanWizardPage.this.fTeamFuture.joinResult(0);
                monitor.done();
                return result;
            }

            @Override
            public void handleTeamRepositoryException(IStatus status, TeamRepositoryException e) {
                if (e instanceof IterationPlanNoTeamAreaException) {
                    AbstractIterationPlanWizardPage.this.setMessage(e.getMessage(), 3);
                    ControlEnableState.disable((Control)AbstractIterationPlanWizardPage.this.getControl());
                    AbstractIterationPlanWizardPage.this.setPageComplete(false);
                } else {
                    super.handleTeamRepositoryException(status, e);
                }
            }
        }.execute(this, true, true, Messages.AbstractIterationPlanWizardPage_VALIDATING_PROJECT_AREA);
        if (result.isOK()) {
            this.futureResolved(result.getResult());
            this.updateStatus();
        }
    }

    private void updateProjectArea() {
        if (this.fContext.getSelectedProjectArea() == null) {
            return;
        }
        this.fBrowseProjectArea.setEnabled(this.fContext.getProjectAreas().size() > 1);
        this.fProjectArea.setText(this.getProjectAreaName(this.fContext.getSelectedProjectArea()));
    }

    private void updateProjectArea(final IProjectAreaHandle handle) {
        this.fContext.setSelectedProjectArea(handle);
        this.updateProjectArea();
        new WizardTeamCallable<1Result>(){

            @Override
            protected 1Result execute(IProgressMonitor monitor) throws TeamRepositoryException, InvocationTargetException, InterruptedException {
                class Result {
                    public volatile IProjectArea projectArea;
                    public volatile IDevelopmentLine devLine;
                    public volatile ITeamArea teamArea;
                    public volatile boolean canSave;
                    public volatile String teamAreaLabel;
                    public volatile IIteration iteration;

                    Result() {
                    }
                }
                Result result = new Result();
                IItemManager manager = PlanningClientPlugin.getTeamRepository((IItemHandle)handle).itemManager();
                result.projectArea = (IProjectArea)manager.fetchCompleteItem((IItemHandle)handle, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                ITeamAreaHierarchy teamAreaHierarchy = result.projectArea.getTeamAreaHierarchy();
                Set roots = teamAreaHierarchy.getRoots();
                if (roots.isEmpty()) {
                    return result;
                }
                result.teamArea = (ITeamArea)manager.fetchCompleteItem((IItemHandle)roots.iterator().next(), 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                IterationPlanClient client = (IterationPlanClient)PlanningClientPlugin.getIterationPlanClient((IItemHandle)handle);
                result.canSave = client.checkPermission((IProcessAreaHandle)result.teamArea, "com.ibm.team.apt.server.saveIterationPlan", "modify/plan", monitor);
                result.teamAreaLabel = AbstractIterationPlanWizardPage.teamAreaToString(result.teamArea, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                result.devLine = (IDevelopmentLine)manager.fetchCompleteItem((IItemHandle)teamAreaHierarchy.getDevelopmentLine((ITeamAreaHandle)result.teamArea), 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                result.iteration = IterationClient.getCurrentPlanLeafIteration((IDevelopmentLineHandle)result.devLine, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                return result;
            }

            @Override
            protected void processResult(1Result result) {
                AbstractIterationPlanWizardPage.this.updateTeamArea(result.teamArea, result.teamAreaLabel);
                AbstractIterationPlanWizardPage.this.fCanSave = result.canSave;
                AbstractIterationPlanWizardPage.this.updateDevelopmentLine(result.devLine);
                AbstractIterationPlanWizardPage.this.updateSelectedIteration(result.iteration);
                AbstractIterationPlanWizardPage.this.updateStatus();
            }
        }.execute(this, true, true, Messages.AbstractIterationPlanWizardPage_JOB_UPDATE_PROJECT_AREA);
    }

    private void updateTeamArea() {
        if (this.fContext.getTeamArea() == null) {
            return;
        }
        if (!this.fInitial) {
            this.deferredUpdateTeamArea(this.fContext.getTeamArea());
        }
    }

    private void updateTeamArea(ITeamArea teamArea, String teamAreaLabel) {
        if (teamArea == null) {
            this.fContext.setTeamArea(null);
            this.fTeamArea.setText("");
            this.fBrowseTeamArea.setEnabled(false);
            this.fContext.setDevelopmentLineHandle(null);
            this.updateSelectedIteration(null);
        } else {
            this.fContext.setTeamArea((ITeamAreaHandle)teamArea);
            this.fTeamArea.setText(teamAreaLabel);
            this.fBrowseTeamArea.setEnabled(true);
        }
    }

    private void updateDevelopmentLine(IDevelopmentLine devLine) {
        if (devLine == null) {
            this.fContext.setDevelopmentLineHandle(null);
        } else {
            this.fContext.setDevelopmentLineHandle((IDevelopmentLineHandle)devLine);
        }
        this.fBrowseTeamArea.setEnabled(devLine != null);
        this.fBrowseIterations.setEnabled(devLine != null);
    }

    private void deferredUpdateTeamArea(final ITeamAreaHandle handle) {
        new WizardTeamCallable<2Result>(){

            @Override
            protected 2Result execute(IProgressMonitor monitor) throws TeamRepositoryException, InvocationTargetException, InterruptedException {
                class Result {
                    public volatile IDevelopmentLine devLine;
                    public volatile ITeamArea teamArea;
                    public volatile boolean canSave;
                    public volatile String teamAreaLabel;
                    public volatile IIteration iteration;

                    Result() {
                    }
                }
                Result result = new Result();
                IItemManager manager = PlanningClientPlugin.getTeamRepository((IItemHandle)handle).itemManager();
                result.teamArea = (ITeamArea)manager.fetchCompleteItem((IItemHandle)handle, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                IterationPlanClient client = (IterationPlanClient)PlanningClientPlugin.getIterationPlanClient((IItemHandle)handle);
                result.canSave = client.checkPermission((IProcessAreaHandle)result.teamArea, "com.ibm.team.apt.server.saveIterationPlan", "modify/plan", monitor);
                result.teamAreaLabel = AbstractIterationPlanWizardPage.teamAreaToString(result.teamArea, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                IDevelopmentLine devLine = PlanningClientPlugin.getAuditableClient((IItemHandle)handle).getDevelopmentLine((ITeamAreaHandle)result.teamArea, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                if (AbstractIterationPlanWizardPage.this.fContext.getDevelopmentLineHandle() == null || !devLine.sameItemId((IItemHandle)AbstractIterationPlanWizardPage.this.fContext.getDevelopmentLineHandle())) {
                    result.devLine = devLine;
                    result.iteration = IterationClient.getCurrentPlanLeafIteration((IDevelopmentLineHandle)result.devLine, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                return result;
            }

            @Override
            protected void processResult(2Result result) {
                AbstractIterationPlanWizardPage.this.updateTeamArea(result.teamArea, result.teamAreaLabel);
                AbstractIterationPlanWizardPage.this.fCanSave = result.canSave;
                if (result.devLine != null) {
                    AbstractIterationPlanWizardPage.this.fContext.setDevelopmentLineHandle((IDevelopmentLineHandle)result.devLine);
                    AbstractIterationPlanWizardPage.this.updateSelectedIteration(result.iteration);
                }
                AbstractIterationPlanWizardPage.this.updateStatus();
            }
        }.execute(this, true, true, Messages.AbstractIterationPlanWizardPage_JOB_UPDATE_TEAM_AREA);
    }

    private void updateSelectedIteration(IIteration iteration) {
        if (iteration == null) {
            this.fContext.setIteration(null);
            this.fIteration.setText("");
        } else {
            this.fContext.setIteration((IIterationHandle)iteration.getItemHandle());
            this.fIteration.setText(iteration.getLabel());
        }
    }

    private void deferredUpdateSelectedIteration(final IIterationHandle handle) {
        if (handle == null) {
            this.updateSelectedIteration(null);
        } else {
            ITeamRepository repository = PlanningClientPlugin.getTeamRepository((IItemHandle)handle);
            final IItemManager manager = repository.itemManager();
            IIteration iteration = (IIteration)manager.getSharedItemIfKnown((IItemHandle)handle);
            if (iteration != null && iteration.isPropertySet(ProcessCommon.getPropertyName(IIteration.class, (String)"name"))) {
                this.updateSelectedIteration(iteration);
            } else {
                new WizardTeamCallable<IIteration>(){

                    @Override
                    protected IIteration execute(IProgressMonitor monitor) throws TeamRepositoryException, InvocationTargetException, InterruptedException {
                        return (IIteration)manager.fetchCompleteItem((IItemHandle)handle, 0, monitor);
                    }

                    @Override
                    protected void processResult(IIteration result) {
                        AbstractIterationPlanWizardPage.this.updateSelectedIteration(result);
                        AbstractIterationPlanWizardPage.this.updateStatus();
                    }
                }.execute(this, true, true, Messages.AbstractIterationPlanWizardPage_JOB_UPDATE_ITERATION);
            }
        }
    }

    private String teamAreaPathToString(List<ITeamArea> primaryTeamAreaPath) {
        StringBuffer buffer = new StringBuffer();
        for (ITeamArea teamArea : primaryTeamAreaPath) {
            buffer.append(teamArea.getName()).append('/');
        }
        return buffer.deleteCharAt(buffer.length() - 1).toString();
    }

    private static String teamAreaToString(ITeamArea teamArea, IProgressMonitor monitor) throws TeamRepositoryException {
        StringBuilder result = new StringBuilder();
        IItemManager manager = PlanningClientPlugin.getTeamRepository((IItemHandle)teamArea).itemManager();
        IProjectArea projectArea = (IProjectArea)manager.fetchCompleteItem((IItemHandle)teamArea.getProjectArea(), 0, monitor);
        ITeamAreaHierarchy hierarchy = projectArea.getTeamAreaHierarchy();
        AbstractIterationPlanWizardPage.teamAreaToString(result, teamArea, hierarchy, manager, monitor);
        result.trimToSize();
        result.deleteCharAt(result.length() - 1);
        return result.toString();
    }

    private static void teamAreaToString(StringBuilder result, ITeamArea teamArea, ITeamAreaHierarchy hierarchy, IItemManager manager, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamAreaHandle parent = hierarchy.getParent((ITeamAreaHandle)teamArea);
        if (parent != null) {
            ITeamArea resolvedParent = (ITeamArea)manager.fetchCompleteItem((IItemHandle)parent, 0, monitor);
            AbstractIterationPlanWizardPage.teamAreaToString(result, resolvedParent, hierarchy, manager, monitor);
        }
        result.append(teamArea.getName());
        result.append("/");
    }
}

