/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.widgets.outliner;

import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OpenStrategy;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Outline;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineItem;
import java.util.List;
import org.eclipse.jface.util.IOpenEventListener;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;

public abstract class OutlineViewer
extends AbstractTreeViewer {
    private Outline fOutline;
    private boolean fInChange;

    public OutlineViewer(Outline control) {
        this.fOutline = control;
        this.hookControl((Control)this.fOutline);
        this.setItemUpdateChecker();
    }

    protected void hookControl(Control control) {
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                OutlineViewer.this.handleDispose(event);
            }
        });
        OpenStrategy handler = new OpenStrategy(control);
        handler.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!OutlineViewer.this.fInChange) {
                    OutlineViewer.this.handleSelect(e);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                OutlineViewer.this.handleDoubleSelect(e);
            }
        });
        handler.addPostSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OutlineViewer.this.handlePostSelect(e);
            }
        });
        handler.addOpenListener(new IOpenEventListener(){

            public void handleOpen(SelectionEvent e) {
                OutlineViewer.this.handleOpen(e);
            }
        });
        this.addTreeListener(control, new TreeListener(){

            public void treeExpanded(TreeEvent event) {
                OutlineViewer.this.handleTreeExpand(event);
            }

            public void treeCollapsed(TreeEvent event) {
                OutlineViewer.this.handleTreeCollapse(event);
            }
        });
    }

    protected void preservingSelection(Runnable updateCode) {
        this.fInChange = true;
        try {
            super.preservingSelection(updateCode);
        }
        finally {
            this.fInChange = false;
        }
    }

    protected void inputChanged(Object input, Object oldInput) {
        this.fOutline.setRedraw(false);
        this.fOutline.setRelayout(false);
        try {
            super.inputChanged(input, oldInput);
        }
        finally {
            this.fOutline.setRelayout(true);
            this.fOutline.setRedraw(true);
        }
    }

    protected void setItemUpdateChecker() {
        this.setLabelProvider((IBaseLabelProvider)new OutlineItemLabelPropertyChecker());
    }

    public Control getControl() {
        return this.fOutline;
    }

    public Outline getOutline() {
        return this.fOutline;
    }

    protected Item[] getChildren(Widget widget) {
        if (widget instanceof Outline) {
            return ((Outline)widget).getItems();
        }
        if (widget instanceof OutlineItem) {
            return ((OutlineItem)widget).getItems();
        }
        return new Item[0];
    }

    protected void addTreeListener(Control control, TreeListener listener) {
        ((Outline)control).addTreeListener(listener);
    }

    protected boolean getExpanded(Item item) {
        return ((OutlineItem)item).getExpanded();
    }

    protected void setExpanded(Item item, boolean expand) {
        ((OutlineItem)item).setExpanded(expand);
    }

    protected int getItemCount(Control control) {
        return ((Outline)control).getItemCount();
    }

    protected int getItemCount(Item item) {
        return ((OutlineItem)item).getItemCount();
    }

    protected Item[] getItems(Item item) {
        return ((OutlineItem)item).getItems();
    }

    protected Item getParentItem(Item item) {
        return ((OutlineItem)item).getParent();
    }

    protected Item[] getSelection(Control control) {
        return ((Outline)control).getSelection();
    }

    protected void removeAll(Control control) {
        ((Outline)control).removeAll();
    }

    protected void setSelection(List items) {
        if (items != null) {
            this.fOutline.setSelection(items.toArray(new OutlineItem[items.size()]));
        }
    }

    protected void showItem(Item item) {
        this.fOutline.showItem((OutlineItem)item);
    }

    public void collapseAll() {
        this.fOutline.stopEditSession();
        super.collapseAll();
    }

    protected class OutlineItemLabelPropertyChecker
    extends LabelProvider {
        protected OutlineItemLabelPropertyChecker() {
        }

        public boolean isLabelProperty(Object element, String property) {
            Widget[] items = OutlineViewer.this.findItems(element);
            int i = 0;
            while (i < items.length) {
                if (items[i] instanceof OutlineItem && ((OutlineItem)items[i]).isLabelProperty(property)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }
}

