/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.widgets.outliner;

import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.CompositeGadget;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GShell;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.IEventHandler;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.IGObject;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.IGadgetEditor;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Outline;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineItem;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineResources;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Rectangles;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Transformation;
import com.ibm.team.repository.common.util.NLS;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;

public abstract class Gadget
implements IEventHandler,
IGObject {
    static final boolean TRACE_GADGETS;
    public static final int TWISTIE_ON_SELECTION_ONLY = 1024;
    public static final int OPENABLE = 2048;
    private static final int DISPOSED = 1;
    private static final int UNUSED = Integer.MIN_VALUE;
    private int fState;
    private Outline fOutline;
    protected CompositeGadget fParent;
    protected Rectangle fBounds;
    private boolean fExclude;
    private boolean fReturnParentElement;

    static {
        String value = Platform.getDebugOption((String)"com.ibm.team.apt.ide.ui/traceGadgets");
        TRACE_GADGETS = value != null && value.equalsIgnoreCase("true");
    }

    protected Gadget(CompositeGadget parent) {
        if (parent == null) {
            throw new IllegalArgumentException();
        }
        this.fParent = parent;
        this.fBounds = new Rectangle(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
        this.fOutline = this.fParent.getShell().getOutline();
        this.fParent.addGadget(this);
    }

    Gadget(OutlineItem item) {
        this.fOutline = item.getOutline();
        this.fBounds = new Rectangle(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    public void dispose() {
        this.fState |= 1;
        this.fOutline = null;
        this.fParent = null;
        this.fBounds = new Rectangle(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    public boolean isDisposed() {
        return (this.fState & 1) != 0;
    }

    public CompositeGadget getParent() {
        return this.fParent;
    }

    public IEventHandler getParentHandler() {
        if (this.fParent != null) {
            return this.fParent;
        }
        return this.getOutlineItem();
    }

    public Display getDisplay() {
        return this.getOutline().getDisplay();
    }

    public GShell getShell() {
        if (this.getParent() == null) {
            return null;
        }
        return this.getParent().getShell();
    }

    public Outline getOutline() {
        return this.fOutline;
    }

    public OutlineItem getOutlineItem() {
        if (this.getShell() == null) {
            return null;
        }
        return this.getShell().getOutlineItem();
    }

    public Transformation getTransformation() {
        return this.fOutline.getTransformation();
    }

    public OutlineResources getOutlineResources() {
        return this.fOutline.getOutlineResources();
    }

    public void setExclude(boolean exclude) {
        this.fExclude = exclude;
    }

    public boolean isExcluded() {
        return this.fExclude;
    }

    public void setReturnParentElement(boolean value) {
        this.fReturnParentElement = value;
    }

    public Object getElement() {
        if (this.fReturnParentElement && this.fParent != null) {
            return this.fParent.getElement();
        }
        return null;
    }

    public boolean contains(Point point) {
        if (!this.isLayouted()) {
            return false;
        }
        return this.fBounds.contains(point);
    }

    public boolean containsY(int y) {
        if (!this.isLayouted()) {
            return false;
        }
        return this.fBounds.y <= y && y < this.fBounds.y + this.fBounds.height;
    }

    public Rectangle getBounds() {
        this.checkBounds();
        return this.fBounds;
    }

    protected Rectangle getContentBounds() {
        return this.getBounds();
    }

    public int getHeight() {
        this.checkBounds();
        return this.fBounds.height;
    }

    public int getWidth() {
        this.checkBounds();
        return this.fBounds.width;
    }

    public void move(int deltaX, int deltaY) {
        if (deltaX == 0 && deltaY == 0) {
            return;
        }
        this.checkBounds();
        Rectangles.move(this.fBounds, deltaX, deltaY);
    }

    public boolean isLayouted() {
        return this.fBounds.x != Integer.MIN_VALUE;
    }

    protected void checkBounds() {
        if (this.fBounds.x == Integer.MIN_VALUE || this.fBounds.width == Integer.MIN_VALUE) {
            throw new IllegalStateException(NLS.bind((String)"GADGET {0}[{1}]", (Object[])new Object[]{this.getClass().getName(), this}));
        }
    }

    public void layout(int x, int y, int wHint, int hHint) {
        Point size = this.arrangeContent(x, y, wHint, hHint);
        Rectangles.assign(this.fBounds, x, y, size.x, size.y);
    }

    protected Point relayout(int x, int y, int deltaWidth, int deltaHeight, Gadget changedChild) {
        return this.arrangeContent(x, y, this.max(0, this.fBounds.width + deltaWidth), this.max(0, this.fBounds.height + deltaHeight));
    }

    public abstract int computeMinimalWidth();

    protected abstract Point arrangeContent(int var1, int var2, int var3, int var4);

    public void resize(int deltaWidth, int deltaHeight) {
        this.checkBounds();
        if (this.fBounds.width < -deltaWidth) {
            deltaWidth = -this.fBounds.width;
        }
        if (this.fBounds.height < -deltaHeight) {
            deltaHeight = -this.fBounds.height;
        }
        Rectangles.resize(this.fBounds, deltaWidth, deltaHeight);
        if (this.fParent != null) {
            this.fParent.resized(this, deltaWidth, deltaHeight, this);
        }
    }

    void clearBounds() {
        this.fBounds = new Rectangle(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    public boolean isOpenable() {
        return false;
    }

    public abstract void paint(GC var1, OutlineResources var2);

    public void redraw(boolean all) {
        if (this.isDisposed() || !this.isLayouted()) {
            if (TRACE_GADGETS) {
                PlanningUIPlugin.log((IStatus)new Status(4, PlanningUIPlugin.getPluginId(), 0, NLS.bind((String)"Bad redraw request for gadget {0}[{1}]", (Object[])new Object[]{this.getClass().getName(), this}), null));
            }
            return;
        }
        this.getOutline().redraw(this, all);
    }

    public IGadgetEditor handleMouseDown(MouseEvent e) {
        if (this.isDisposed()) {
            return null;
        }
        return this.handleMouseDown(this, e);
    }

    protected IGadgetEditor handleMouseDown(IEventHandler receiver, MouseEvent e) {
        return this.fParent.handleMouseDown(receiver, e);
    }

    public void handleMouseUp(MouseEvent e) {
        if (this.isDisposed()) {
            return;
        }
        this.handleMouseUp(this, e);
    }

    protected void handleMouseUp(IEventHandler receiver, MouseEvent e) {
        this.fParent.handleMouseUp(receiver, e);
    }

    public void handleMouseDoubleClick(MouseEvent e) {
        if (this.isDisposed()) {
            return;
        }
        this.handleMouseDoubleClick(this, e);
    }

    protected void handleMouseDoubleClick(IEventHandler receiver, MouseEvent e) {
        this.fParent.handleMouseDoubleClick(receiver, e);
    }

    public void handleMouseMove(MouseEvent e) {
        if (this.isDisposed()) {
            return;
        }
        this.handleMouseMove(this, e);
    }

    protected void handleMouseMove(IEventHandler receiver, MouseEvent e) {
        this.fParent.handleMouseMove(receiver, e);
    }

    public void handleMouseEnter(MouseEvent e) {
        if (this.isDisposed()) {
            return;
        }
        this.handleMouseEnter(this, e);
    }

    protected void handleMouseEnter(IEventHandler receiver, MouseEvent e) {
        this.fParent.handleMouseEnter(receiver, e);
    }

    public void handleMouseExit(MouseEvent e) {
        if (this.isDisposed()) {
            return;
        }
        this.handleMouseExit(this, e);
    }

    protected void handleMouseExit(IEventHandler handler, MouseEvent e) {
        this.fParent.handleMouseExit(this, e);
    }

    public void handleContextMenuShown(Menu menu, MenuEvent e) {
        if (this.isDisposed()) {
            return;
        }
        this.handleContextMenuShown(this, menu, e);
    }

    protected void handleContextMenuShown(IEventHandler receiver, Menu menu, MenuEvent e) {
        this.fParent.handleContextMenuShown(receiver, menu, e);
    }

    public void stop() {
        if (this.isDisposed()) {
            return;
        }
        this.stop(this);
    }

    protected void stop(IEventHandler receiver) {
        this.fParent.stop(receiver);
    }

    public boolean requestsSelection() {
        return true;
    }

    protected static boolean hasStyle(int style, int bit) {
        return (style & bit) != 0;
    }

    protected int max(int i1, int i2) {
        return Math.max(i1, i2);
    }

    protected int max(int i1, int i2, int i3) {
        return Math.max(i1, Math.max(i2, i3));
    }

    protected int max(int i1, int i2, int i3, int i4) {
        return Math.max(i1, Math.max(i2, Math.max(i3, i4)));
    }
}

