/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.widgets.outliner;

import com.ibm.icu.text.MessageFormat;
import com.ibm.team.apt.internal.common.ProgressItem;
import com.ibm.team.apt.internal.ide.ui.common.PlanOutlineResources;
import com.ibm.team.apt.internal.ide.ui.util.GCState;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.BarGadget;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.BarResources;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.CompositeGadget;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GLabel;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.IEventHandler;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.IGObject;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Messages;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineResources;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.ProgressBarPainter;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.TextStyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;

public class GProgressBar
extends BarGadget {
    private ProgressItem fProgressItem;
    private ProgressBarPainter fBarPainter;
    private GLabel fHours;
    private GLabel fEstimated;
    private int fMinimumWidth;

    public GProgressBar(CompositeGadget parent, ProgressItem progressItem, boolean forceProjection) {
        super(parent);
        PlanOutlineResources resources = (PlanOutlineResources)this.getOutlineResources();
        Color color = parent.getDisplay().getSystemColor(17);
        BarResources barResources = resources.getBarResources();
        Font font = barResources.getMessageFont();
        this.fBarPainter = new ProgressBarPainter(barResources);
        this.fProgressItem = progressItem;
        String textHours = this.fProgressItem.getTextHours();
        this.fHours = new GLabel(this, textHours, 0);
        if (this.fProgressItem.getKind() == ProgressItem.Kind.BAR_WITH_PROJECTION) {
            Color deltaColor = this.fProgressItem.isAhead() ? barResources.getGreen() : barResources.getRed();
            int s1 = textHours.lastIndexOf(124);
            int e1 = textHours.lastIndexOf(104);
            if (e1 == -1) {
                e1 = textHours.length();
            }
            if (s1 != -1) {
                TextStyleRange[] ranges = new TextStyleRange[]{new TextStyleRange(s1 + 1, Math.max(0, e1 - s1 - 2), new TextStyle(null, deltaColor, null))};
                this.fHours.setTextStyleRanges(ranges);
            }
        }
        this.fHours.setColor(color);
        this.fHours.setFont(font);
        String estimatePattern = Messages.GProgressBar_ESTIMATED_LABEL;
        this.fEstimated = new GLabel(this, this.fProgressItem.getKind() == ProgressItem.Kind.DONE ? Messages.GProgressBar_ESTIMATED_DONE : MessageFormat.format((String)estimatePattern, (Object[])new Object[]{Float.valueOf(this.fProgressItem.getQualityOfPlanning())}), 0);
        this.fEstimated.setColor(color);
        this.fEstimated.setFont(font);
        TextLayout layout = resources.getTextLayout();
        layout.setFont(font);
        layout.setText(String.valueOf(this.fProgressItem.getMaxTextHours(forceProjection)) + " " + MessageFormat.format((String)estimatePattern, (Object[])new Object[]{100}));
        this.fMinimumWidth = layout.getBounds().width;
    }

    public ProgressBarPainter getBarPainter() {
        return this.fBarPainter;
    }

    public void refresh() {
    }

    public int computeMinimalWidth() {
        return this.max(this.computeBarHeight() * 6, this.fMinimumWidth, this.fHours.computeMinimalWidth() + this.getResources().getSpaceWidth() + this.fEstimated.computeMinimalWidth());
    }

    public int computeTopSpacing() {
        return this.fBarPainter.computeTopSpacing(this.getBounds().height);
    }

    protected Point arrangeContent(int x, int y, int wHint, int hHint) {
        int x1 = x;
        int y1 = y;
        this.fHours.layout(x1, y1 += this.computeBarHeight(), -1, -1);
        x1 = wHint != -1 ? x + wHint - this.fEstimated.computeMinimalWidth() : (this.fMinimumWidth != -1 ? (x1 += this.fMinimumWidth - this.fEstimated.computeMinimalWidth()) : (x1 += this.fHours.getWidth() + this.getResources().getSpaceWidth()));
        this.fEstimated.layout(x1, y1, -1, -1);
        int width = this.max(this.computeBarHeight() * 6, this.fMinimumWidth, this.fHours.getWidth() + this.getResources().getSpaceWidth() + this.fEstimated.getWidth());
        int height = y1 + this.max(this.fHours.getHeight(), this.fEstimated.getHeight()) - y;
        if (hHint != -1) {
            height = hHint;
        }
        if (wHint != -1) {
            width = wHint;
        }
        return new Point(width, height);
    }

    public void paint(GC gc, OutlineResources resources) {
        if (this.fProgressItem == null) {
            return;
        }
        GCState state = GCState.save(gc, 392);
        try {
            Rectangle rect = this.getTransformation().toViewPort(this.getBounds());
            rect.height = this.computeBarHeight();
            this.fBarPainter.paint(gc, rect, this.fProgressItem);
        }
        finally {
            state.restore();
        }
        super.paint(gc, resources);
    }

    public Object getElement() {
        return this.fProgressItem.getProgressInformation();
    }

    public IEventHandler findEventHandlerUnder(Point panePoint, int mode) {
        return this;
    }

    public IGObject findGObjectUnder(Point pane) {
        return this;
    }

    private PlanOutlineResources getResources() {
        return (PlanOutlineResources)this.getOutlineResources();
    }

    private int computeBarHeight() {
        return this.fBarPainter.computeMinimalHeight();
    }
}

