/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.widgets.outliner;

import com.ibm.team.apt.internal.ide.ui.widgets.outliner.CompositeGadget;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.IGadgetEditor;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineResources;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.SimpleGadget;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class GBullet
extends SimpleGadget {
    private int fOffset;
    private int fSize;

    public GBullet(CompositeGadget parent) {
        super(parent);
    }

    public int computeMinimalWidth() {
        FontMetrics fontMetrics = this.getOutlineResources().getFontMetrics();
        int ascent = fontMetrics.getAscent();
        int size = ascent * 3 / 5;
        return size + fontMetrics.getLeading();
    }

    protected Point arrangeContent(int x, int y, int with, int height) {
        FontMetrics fontMetrics = this.getOutlineResources().getFontMetrics();
        int ascent = fontMetrics.getAscent();
        this.fSize = ascent * 3 / 5;
        this.fOffset = fontMetrics.getLeading() + (fontMetrics.getAscent() - this.fSize) / 2;
        return new Point(this.fSize + fontMetrics.getLeading(), fontMetrics.getHeight());
    }

    public void paint(GC gc, OutlineResources resources) {
        Color color = gc.getBackground();
        int antialias = gc.getAntialias();
        Rectangle viewBounds = this.getTransformation().toViewPort(this.fBounds);
        try {
            gc.setBackground(resources.getBulletColor());
            gc.setAntialias(1);
            gc.fillArc(viewBounds.x, viewBounds.y + this.fOffset, this.fSize, this.fSize, 0, 360);
        }
        finally {
            gc.setBackground(color);
            gc.setAntialias(antialias);
        }
        if (this.getOutlineResources().debugLayout) {
            gc.drawRectangle(viewBounds.x, viewBounds.y, viewBounds.width - 1, viewBounds.height - 1);
        }
    }

    public IGadgetEditor handleMouseDown(MouseEvent e) {
        return super.handleMouseDown(e);
    }
}

