/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.widgets.outliner;

import com.ibm.team.apt.internal.ide.ui.common.gadgets.GroupGadget;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.PlanItemGadget;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.TimeGadget;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GShell;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GTreeNode;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Outline;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineItem;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineResources;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Rectangles;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.ResizeMode;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public abstract class ContentOutlineItem
extends OutlineItem {
    private GShell fContent;

    public ContentOutlineItem(Outline outline, int style) {
        super(outline, style);
    }

    public ContentOutlineItem(Outline outline, int style, int index) {
        super(outline, style, index);
    }

    public ContentOutlineItem(OutlineItem parent, int style) {
        super(parent, style);
    }

    public ContentOutlineItem(OutlineItem parent, int style, int index) {
        super(parent, style, index);
    }

    public abstract int getMinimalWidth();

    protected void disposeItem() {
        if (this.fContent != null) {
            this.fContent.dispose();
        }
        super.disposeItem();
    }

    public void setContent(GShell content) {
        Rectangle oldBounds;
        GShell oldContent = this.fContent;
        this.fContent = content;
        if (!this.isLayouted() || this.getOutline().isLayoutDeferred()) {
            if (oldContent != null) {
                oldContent.dispose();
            }
            return;
        }
        if (oldContent != null) {
            oldBounds = Rectangles.create(oldContent.getBounds());
            this.fContent.internalSetSelectionMode(oldContent.internalGetSelectionMode());
            oldContent.dispose();
        } else {
            oldBounds = new Rectangle(0, 0, 0, 0);
        }
        int width = this.fContent.computeMinimalWidth();
        if (width > this.fBounds.width) {
            this.getOutline().relayout();
        } else {
            this.setTreeContentIndent(this.fContent, this.computeTreeContentIndent(this));
            this.fContent.layout(this.fBounds.x, this.fBounds.y, this.fBounds.width, -1);
            Rectangle newBounds = this.fContent.getBounds();
            int deltaWidth = this.fBounds.width >= newBounds.width ? 0 : newBounds.width - this.fBounds.width;
            int deltaHeight = newBounds.height - oldBounds.height;
            if (deltaWidth != 0 || deltaHeight != 0) {
                this.resize(deltaWidth, deltaHeight, ResizeMode.CONTENT);
            } else {
                this.getOutline().redraw(this, false);
            }
        }
    }

    public GShell getContent() {
        return this.fContent;
    }

    private int computeTreeContentIndent(OutlineItem item) {
        OutlineItem parent;
        int indent = 0;
        boolean skipFirst = !(item.getContent() instanceof GroupGadget) || item.getContent() instanceof TimeGadget;
        while ((parent = item.getParent()) != null) {
            item = parent;
            if (parent.getContent() instanceof PlanItemGadget) {
                indent += this.getResources().getChildIndent();
                continue;
            }
            if (parent.getContent() instanceof TimeGadget) {
                indent += 0;
                continue;
            }
            if (!(parent.getContent() instanceof GroupGadget)) continue;
            indent += skipFirst ? 0 : this.getResources().getChildIndent();
            skipFirst = false;
        }
        return indent;
    }

    private void setTreeContentIndent(GShell content, int newIndent) {
        if (content instanceof GTreeNode) {
            ((GTreeNode)content).setContentIndent(newIndent);
        }
    }

    public void move(int deltaX, int deltaY) {
        if (this.isLayouted()) {
            super.move(deltaX, deltaY);
            if (this.fContent != null && this.fContent.isLayouted()) {
                this.fContent.move(deltaX, deltaY);
            }
        }
    }

    public int computeMinimumWidth() {
        int result = 0;
        if (this.fContent != null) {
            result = this.fContent.computeMinimalWidth();
        }
        return Math.max(result, super.computeMinimumWidth());
    }

    protected Point arrangeContent(int x, int y, int wHint, int hHint) {
        if (wHint != -1 && this.getMinimalWidth() > 0 && wHint < this.getMinimalWidth()) {
            wHint = this.getMinimalWidth();
        }
        int width = 0;
        int height = 0;
        if (this.fContent != null) {
            this.fContent.layout(x, y, wHint, hHint);
            width = Math.max(width, this.fContent.getWidth());
            height += this.fContent.getHeight();
            y += this.fContent.getHeight();
        } else if (wHint != -1) {
            width = wHint;
        }
        if (this.fChildren.length > 0 && this.getExpanded()) {
            int i = 0;
            while (i < this.fChildren.length) {
                OutlineItem child = this.fChildren[i];
                if (child instanceof ContentOutlineItem) {
                    this.setTreeContentIndent(((ContentOutlineItem)child).getContent(), this.computeTreeContentIndent(child));
                }
                child.layout(x, y, wHint, hHint);
                width = Math.max(width, child.getWidth());
                int deltaHeight = child.getHeight();
                height += deltaHeight;
                y += deltaHeight;
                ++i;
            }
        }
        return new Point(width, height);
    }

    protected void paintContent(PaintEvent event, OutlineResources resources) {
        if (this.fContent != null && resources.getPaintPaneBounds().intersects(this.fContent.getBounds())) {
            this.fContent.paint(event.gc, resources);
        }
        if (resources.debugLayout) {
            Rectangle bounds = this.getTransformation().toViewPort(this.fContent.getBounds());
            event.gc.drawRectangle(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1);
        }
    }

    void clearBounds() {
        super.clearBounds();
        if (this.fContent != null) {
            this.fContent.clearBounds();
        }
    }
}

