/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.widgets.outliner;

import com.ibm.team.apt.internal.ide.ui.editor.outliner.IColumnBasedGadget;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.PlanElementGadget;
import com.ibm.team.apt.internal.ide.ui.util.GCState;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.ContentOutlineItem;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GShell;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Outline;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineColumn;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineItem;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineResources;
import org.eclipse.swt.events.PaintEvent;

public abstract class ColumnContentOutlineItem
extends ContentOutlineItem {
    public ColumnContentOutlineItem(Outline outline, int style) {
        super(outline, style);
    }

    public ColumnContentOutlineItem(Outline outline, int style, int index) {
        super(outline, style, index);
    }

    public ColumnContentOutlineItem(OutlineItem parent, int style) {
        super(parent, style);
    }

    public ColumnContentOutlineItem(OutlineItem parent, int style, int index) {
        super(parent, style, index);
    }

    public void setContent(GShell content) {
        boolean relayout = false;
        boolean columnGadget = content instanceof IColumnBasedGadget;
        super.setContent(content);
        if (columnGadget) {
            PlanElementGadget gadget = (PlanElementGadget)content;
            int index = 0;
            while (index < gadget.getColumnCount()) {
                OutlineColumn column = this.getOutline().getColumn(index);
                int columnWidth = column.getWidth();
                int width = gadget.getColumnWidth(index);
                if (columnWidth != 4 && columnWidth < width) {
                    column.setWidth(width);
                    relayout |= true;
                }
                ++index;
            }
        }
        if (relayout) {
            this.getOutline().relayout();
        }
    }

    protected void paintContent(PaintEvent event, OutlineResources resources) {
        super.paintContent(event, resources);
        int count = this.getOutline().getColumnCount();
        if (resources.debugLayout) {
            int xoffset = 0;
            int i = 0;
            while (i < count) {
                GCState state = GCState.save(event.gc, 256);
                event.gc.setForeground(resources.getTwistieColor());
                event.gc.drawLine(xoffset += this.getOutline().getColumn(i).getWidth(), this.getBounds().y, xoffset, this.getBounds().y + this.getBounds().height - 1);
                state.restore();
                ++i;
            }
        }
    }
}

