/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.widgets;

import com.ibm.team.apt.internal.ide.ui.widgets.Messages;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class ScrolledButtonComposite
extends Composite {
    private int fScroll_pixels = 10;
    private Composite fScrollContainer;
    private Composite fContent;
    private Button fDown;
    private Button fUp;

    public ScrolledButtonComposite(Composite parent, int style) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 2;
        this.setLayout((Layout)gridLayout);
        this.fUp = new Button((Composite)this, 25165956);
        this.fUp.setText(Messages.ScrolledButtonComposite_SCROLL_UP);
        GridData gridData = new GridData(4, 128, true, false);
        gridData.heightHint = 10;
        this.fUp.setLayoutData((Object)gridData);
        this.fScrollContainer = new Composite((Composite)this, 0);
        this.fScrollContainer.setLayoutData((Object)new GridData(1808));
        this.fDown = new Button((Composite)this, 25166852);
        this.fDown.setText(Messages.ScrolledButtonComposite_SCROLL_DOWN);
        this.fDown.setLayoutData((Object)gridData);
        this.fUp.addMouseListener((MouseListener)new ScrollAdapter(true));
        this.fDown.addMouseListener((MouseListener)new ScrollAdapter(false));
        this.fScrollContainer.addControlListener((ControlListener)new ResizeListener());
    }

    public void setScrollPixels(int scroll_pixels) {
        this.fScroll_pixels = scroll_pixels;
    }

    public Composite getScrollContainer() {
        return this.fScrollContainer;
    }

    public void scroll(boolean up) {
        if (this.canScroll(up)) {
            Point location = this.getContent().getLocation();
            this.getContent().setLocation(location.x, location.y + (up ? this.fScroll_pixels : -this.fScroll_pixels));
            this.getContent().setSize(this.getContent().computeSize(this.getContent().getSize().x, -1));
            this.canScroll();
        }
    }

    private void canScroll() {
        this.canScroll(true);
        this.canScroll(false);
    }

    private boolean canScroll(boolean up) {
        if (this.getContent() == null) {
            return false;
        }
        if (up) {
            if (this.getContent().getLocation().y >= 0) {
                this.fUp.setEnabled(false);
                return false;
            }
            this.fUp.setEnabled(true);
            return true;
        }
        if (this.getContent().getLocation().y + this.getContent().computeSize((int)-1, (int)-1).y - this.getScrollContainer().getSize().y <= 0) {
            this.fDown.setEnabled(false);
            return false;
        }
        this.fDown.setEnabled(true);
        return true;
    }

    public Composite getContent() {
        return this.fContent;
    }

    public void setContent(Composite content) {
        this.fContent = content;
        this.canScroll();
    }

    public class ResizeListener
    extends ControlAdapter {
        public void controlResized(ControlEvent e) {
            ScrolledButtonComposite.this.canScroll();
            if (ScrolledButtonComposite.this.canScroll(true) && !ScrolledButtonComposite.this.canScroll(false)) {
                ScrolledButtonComposite.this.scroll(true);
            }
        }
    }

    class ScrollAdapter
    extends MouseAdapter {
        private final boolean fUp;

        ScrollAdapter(boolean up) {
            this.fUp = up;
        }

        public void mouseDown(MouseEvent e) {
            ScrolledButtonComposite.this.scroll(this.fUp);
        }
    }
}

