/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.util;

import com.ibm.team.apt.common.IIterationPlanRecord;
import com.ibm.team.apt.internal.client.IterationPlanData;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.teamload.LoadItem;
import com.ibm.team.apt.internal.common.util.ItemCollection;
import com.ibm.team.apt.internal.common.util.ItemCollections;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.expression.AttributeExpression;
import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.expression.IQueryableAttributeFactory;
import com.ibm.team.workitem.common.expression.QueryableAttributes;
import com.ibm.team.workitem.common.expression.SelectClause;
import com.ibm.team.workitem.common.expression.SortCriteria;
import com.ibm.team.workitem.common.expression.Term;
import com.ibm.team.workitem.common.expression.VariableAttributeExpression;
import com.ibm.team.workitem.common.expression.variables.IAttributeVariable;
import com.ibm.team.workitem.common.expression.variables.StatusVariable;
import com.ibm.team.workitem.common.model.AttributeOperation;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.ICategoryHandle;
import com.ibm.team.workitem.common.model.IWorkItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryHelper {
    public static SelectClause createSelectClause(IProjectAreaHandle projectArea, List<String> attributes, IProgressMonitor monitor) throws TeamRepositoryException {
        SelectClause select = new SelectClause();
        for (String attribute : attributes) {
            select.addColumnIdentifier(attribute);
        }
        return select;
    }

    public static SortCriteria[] createSortCriteria(IProjectAreaHandle projectArea, List<String> attributes, IProgressMonitor monitor) throws TeamRepositoryException {
        IAuditableClient auditableClient = PlanningClientPlugin.getAuditableClient((IItemHandle)projectArea);
        IQueryableAttributeFactory factory = QueryableAttributes.getFactory((IItemType)IWorkItem.ITEM_TYPE);
        SortCriteria[] result = new SortCriteria[attributes.size()];
        int i = 0;
        while (i < result.length) {
            String attribute = attributes.get(i);
            IQueryableAttribute queryableAttribute = factory.findAttribute(projectArea, attribute, (IAuditableCommon)auditableClient, monitor);
            result[i] = new SortCriteria(queryableAttribute, true);
            ++i;
        }
        return result;
    }

    public static Expression createTeamLoadQuery(LoadItem item, boolean excludeEstimated, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository repository = PlanningClientPlugin.getTeamRepository((IItemHandle)item.getContributor());
        IProjectAreaHandle projectArea = item.getLoadInformation().getProjectArea();
        Expression owner = QueryHelper.createOwnerQuery(projectArea, item.getContributor(), monitor);
        Expression state = QueryHelper.createStateExpression(repository, projectArea, true, monitor);
        Collection<Expression> iteration = QueryHelper.createPlanExpressions(projectArea, (IIterationHandle)item.getLoadInformation().getIterations().get(0), (ItemCollection<? extends ICategoryHandle>)((ItemCollection)ItemCollections.emptyList()), monitor);
        Term term = new Term(0, new Expression[]{owner, state, iteration.iterator().next()});
        if (excludeEstimated) {
            IAuditableClient auditableClient = PlanningClientPlugin.getAuditableClient((IItemHandle)projectArea);
            IWorkItemClient workItemClient = PlanningClientPlugin.getWorkItemClient((IItemHandle)projectArea);
            Expression noEstimate = QueryHelper.createEstimateExpression(projectArea, auditableClient, workItemClient, monitor);
            term = new Term(0, new Expression[]{term, noEstimate});
        }
        return term;
    }

    private static Expression createEstimateExpression(IProjectAreaHandle projectArea, IAuditableClient auditableClient, IWorkItemClient workItemClient, IProgressMonitor monitor) throws TeamRepositoryException {
        IAttribute duration = workItemClient.findAttribute(projectArea, IWorkItem.DURATION_PROPERTY, monitor);
        return new AttributeExpression((IAuditableCommon)auditableClient, duration, AttributeOperation.EQUALS, (Object)-1);
    }

    public static Expression createOwnerQuery(IProjectAreaHandle projectArea, IContributor contributorHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository teamRepository = (ITeamRepository)contributorHandle.getOrigin();
        IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
        IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
        IAttribute ownerAttribute = workItemClient.findAttribute(projectArea, IWorkItem.OWNER_PROPERTY, monitor);
        return new AttributeExpression((IAuditableCommon)auditableClient, ownerAttribute, AttributeOperation.EQUALS, (Object)contributorHandle);
    }

    public static Expression createAllWorkItemsQuery(IterationPlanData planData, IIterationHandle interval, IProgressMonitor monitor) throws TeamRepositoryException {
        Collection<Expression> planExps;
        ITeamRepository teamRepository = planData.getTeamRepository();
        if (teamRepository != null && (planExps = QueryHelper.createPlanExpressions((IProjectAreaHandle)planData.getProjectArea(), interval, (ItemCollection<? extends ICategoryHandle>)planData.getCategories(), monitor)) != null) {
            return new Term(0, planExps.toArray(new Expression[0]));
        }
        return null;
    }

    public static Expression createOpenWorkItemsQuery(IterationPlanData planData, IProgressMonitor monitor) throws TeamRepositoryException {
        IIterationPlanRecord planRecord = planData.getPlanRecord();
        ITeamRepository teamRepository = planData.getTeamRepository();
        if (teamRepository != null) {
            IProjectAreaHandle projectArea = (IProjectAreaHandle)planData.getProjectArea().getItemHandle();
            Collection<Expression> planExps = QueryHelper.createPlanExpressions(projectArea, planRecord.getIteration(), (ItemCollection<? extends ICategoryHandle>)planData.getCategories(), monitor);
            Expression stateExp = QueryHelper.createStateExpression(teamRepository, projectArea, true, monitor);
            if (planExps != null && stateExp != null) {
                planExps.add(stateExp);
                return new Term(0, planExps.toArray(new Expression[0]));
            }
        }
        return null;
    }

    public static Expression createClosedWorkItemsQuery(IterationPlanData planData, IProgressMonitor monitor) throws TeamRepositoryException {
        IIterationPlanRecord planRecord = planData.getPlanRecord();
        ITeamRepository teamRepository = planData.getTeamRepository();
        if (teamRepository != null) {
            IProjectAreaHandle projectArea = (IProjectAreaHandle)planData.getProjectArea().getItemHandle();
            Collection<Expression> planExps = QueryHelper.createPlanExpressions(projectArea, planRecord.getIteration(), (ItemCollection<? extends ICategoryHandle>)planData.getCategories(), monitor);
            Expression stateExp = QueryHelper.createStateExpression(teamRepository, projectArea, false, monitor);
            if (planExps != null && stateExp != null) {
                planExps.add(stateExp);
                return new Term(0, planExps.toArray(new Expression[0]));
            }
        }
        return null;
    }

    public static Expression createBacklogQuery(IterationPlanData planData, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository teamRepository = planData.getTeamRepository();
        if (teamRepository != null) {
            IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
            IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
            ArrayList<Object> expressions = new ArrayList<Object>();
            expressions.add(QueryHelper.createCategoryExpression(teamRepository, (ItemCollection<? extends ICategoryHandle>)planData.getCategories(), auditableClient, workItemClient, monitor));
            Expression stateExp = QueryHelper.createStateExpression(teamRepository, (IProjectAreaHandle)planData.getProjectArea(), true, monitor);
            if (stateExp != null) {
                expressions.add(stateExp);
            }
            IAttribute targetAttribute = workItemClient.findAttribute((IProjectAreaHandle)planData.getProjectArea(), IWorkItem.TARGET_PROPERTY, monitor);
            ArrayList<AttributeExpression> intervalExps = new ArrayList<AttributeExpression>();
            intervalExps.add(new AttributeExpression((IAuditableCommon)auditableClient, targetAttribute, AttributeOperation.EQUALS, null));
            for (IIteration interval : planData.getFutureIterations()) {
                AttributeExpression targetExpression = new AttributeExpression((IAuditableCommon)auditableClient, targetAttribute, AttributeOperation.EQUALS, (Object)interval);
                intervalExps.add(targetExpression);
            }
            if (intervalExps.size() > 1) {
                expressions.add(new Term(1, intervalExps.toArray(new Expression[intervalExps.size()])));
            } else {
                expressions.addAll(intervalExps);
            }
            return new Term(0, expressions.toArray(new Expression[0]));
        }
        return null;
    }

    public static Expression createUnplannedCloseQuery(IterationPlanData planData, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository teamRepository = planData.getTeamRepository();
        if (teamRepository != null) {
            IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
            IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
            ArrayList<Object> expressions = new ArrayList<Object>();
            expressions.add(QueryHelper.createCategoryExpression(teamRepository, (ItemCollection<? extends ICategoryHandle>)planData.getCategories(), auditableClient, workItemClient, monitor));
            Expression stateExp = QueryHelper.createStateExpression(teamRepository, (IProjectAreaHandle)planData.getProjectArea(), false, monitor);
            if (stateExp != null) {
                expressions.add(stateExp);
            }
            IAuditableClient auditableCommon = PlanningClientPlugin.getAuditableClient((IItemHandle)planData.getPlanRecord());
            IAttribute resolutionDateAttribute = workItemClient.findAttribute((IProjectAreaHandle)planData.getProjectArea(), IWorkItem.RESOLUTION_DATE_PROPERTY, monitor);
            IAttribute targetAttribute = workItemClient.findAttribute((IProjectAreaHandle)planData.getProjectArea(), IWorkItem.TARGET_PROPERTY, monitor);
            AttributeExpression endDateExp = new AttributeExpression((IAuditableCommon)auditableClient, resolutionDateAttribute, AttributeOperation.SMALLER_OR_EQUALS, (Object)planData.getIteration().getEndDate());
            AttributeExpression startDateExp = new AttributeExpression((IAuditableCommon)auditableClient, resolutionDateAttribute, AttributeOperation.GREATER_OR_EQUALS, (Object)planData.getIteration().getStartDate());
            AttributeExpression noIntervalExp = new AttributeExpression((IAuditableCommon)auditableClient, targetAttribute, AttributeOperation.EQUALS, targetAttribute.getNullValue((IAuditableCommon)auditableCommon));
            expressions.add(endDateExp);
            expressions.add(startDateExp);
            expressions.add(noIntervalExp);
            return new Term(0, expressions.toArray(new Expression[0]));
        }
        return null;
    }

    private static Collection<Expression> createPlanExpressions(IProjectAreaHandle projectArea, IIterationHandle interval, ItemCollection<? extends ICategoryHandle> categories, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository teamRepository = (ITeamRepository)interval.getOrigin();
        if (teamRepository != null) {
            IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
            IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
            ArrayList<Expression> expressions = new ArrayList<Expression>();
            IAttribute targetAttribute = workItemClient.findAttribute(projectArea, IWorkItem.TARGET_PROPERTY, monitor);
            AttributeExpression targetExpression = new AttributeExpression((IAuditableCommon)auditableClient, targetAttribute, AttributeOperation.EQUALS, (Object)interval);
            expressions.add((Expression)targetExpression);
            expressions.add(QueryHelper.createCategoryExpression(teamRepository, categories, auditableClient, workItemClient, monitor));
            return expressions;
        }
        return null;
    }

    private static Expression createStateExpression(ITeamRepository teamRepository, IProjectAreaHandle projectArea, boolean fetchOpen, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
        IAttribute stateAttribute = workItemClient.findAttribute(projectArea, IWorkItem.STATE_PROPERTY, monitor);
        StatusVariable statusVariable = new StatusVariable(fetchOpen ? 5 : 2);
        return new VariableAttributeExpression(stateAttribute, AttributeOperation.EQUALS, (IAttributeVariable)statusVariable);
    }

    private static Expression createCategoryExpression(ITeamRepository teamRepository, ItemCollection<? extends ICategoryHandle> categories, IAuditableClient auditableClient, IWorkItemClient workItemClient, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<AttributeExpression> expressions = new ArrayList<AttributeExpression>();
        for (ICategoryHandle category : categories) {
            ICategory item = (ICategory)auditableClient.resolveAuditable((IAuditableHandle)category, ICategory.SMALL_PROFILE, monitor);
            IAttribute categoryAttribute = workItemClient.findAttribute(item.getProjectArea(), IWorkItem.CATEGORY_PROPERTY, monitor);
            AttributeExpression categoryExpression = new AttributeExpression((IAuditableCommon)auditableClient, categoryAttribute, AttributeOperation.IN_CATEGORY, (Object)category);
            expressions.add(categoryExpression);
        }
        return new Term(1, expressions.toArray(new Expression[0]));
    }
}

