/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.util;

import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.util.IterationStructure;
import com.ibm.team.apt.internal.common.util.ItemList;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.util.Messages;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.progress.DeferredTreeContentManager;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;
import org.eclipse.ui.progress.UIJob;

public class IterationSelectionDialog
extends ElementTreeSelectionDialog {
    public IterationSelectionDialog(Shell parent, IIterationHandle toReveal) {
        super(parent, (ILabelProvider)new LabelProvider(), (ITreeContentProvider)new IterationContentProvider(toReveal));
        this.setMessage(Messages.IterationSelectionDialog_MSG_SELECT_ITERATION);
        this.setTitle(Messages.IterationSelectionDialog_SELECT_ITERATION);
        this.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length == 0) {
                    return new Status(4, PlanningUIPlugin.getPluginId(), Messages.IterationSelectionDialog_MSG_SELECT_ITERATION);
                }
                IIteration iteration = (IIteration)selection[0];
                if (!iteration.hasDeliverable()) {
                    return new Status(4, PlanningUIPlugin.getPluginId(), Messages.IterationSelectionDialog_NO_RELEASE_SCHEDULED);
                }
                return new Status(0, PlanningUIPlugin.getPluginId(), "");
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        Control result = super.createDialogArea(parent);
        UI.hookHelpListener(result, "com.ibm.team.apt.ide.ui.dialog_select_iteration");
        return result;
    }

    protected void updateStatus(IStatus status) {
        if (this.getTreeViewer() != null && this.getTreeViewer().getContentProvider() != null) {
            IterationContentProvider contentProvider = (IterationContentProvider)this.getTreeViewer().getContentProvider();
            if (contentProvider.getFetched()) {
                super.updateStatus(status);
            } else if (status.getSeverity() == 4) {
                this.getButton(0).setEnabled(false);
            } else {
                super.updateStatus(status);
            }
        } else {
            super.updateStatus(status);
        }
    }

    private static class IterationContentProvider
    implements ITreeContentProvider,
    IDeferredWorkbenchAdapter {
        private DeferredTreeContentManager fManager;
        private StandardLabelProvider fLabelProvider;
        private Viewer fViewer;
        private IDevelopmentLine fRoot;
        private IIterationHandle fToResolve;
        private IterationStructure fIterationStructure;
        private boolean fFetched;

        public IterationContentProvider(IIterationHandle toResolve) {
            this.fToResolve = toResolve;
        }

        public synchronized boolean getFetched() {
            return this.fFetched;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.fViewer = viewer;
            if (this.fManager == null) {
                this.fManager = new DeferredTreeContentManager(this, (AbstractTreeViewer)viewer){

                    protected IDeferredWorkbenchAdapter getAdapter(Object element) {
                        return IterationContentProvider.this;
                    }
                };
            }
            if (this.fLabelProvider == null) {
                this.fLabelProvider = new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl());
            }
        }

        public void dispose() {
            this.fManager = null;
            if (this.fLabelProvider != null) {
                this.fLabelProvider.dispose();
            }
        }

        public Object[] getElements(Object inputElement) {
            if (this.fManager == null) {
                return new Object[]{new Object()};
            }
            return this.getChildren(inputElement);
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IIteration && this.fIterationStructure != null) {
                return this.getIterations(((IIteration)element).getChildren()).length > 0;
            }
            return true;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IDevelopmentLineHandle && this.fIterationStructure != null) {
                IDevelopmentLine devLine = this.fIterationStructure.getDevelopmentLine((IDevelopmentLineHandle)parentElement);
                return this.fIterationStructure.getIterations(devLine.getIterations()).toArray();
            }
            if (parentElement instanceof IIteration && this.fIterationStructure != null) {
                return this.getIterations(((IIteration)parentElement).getChildren());
            }
            return this.fManager.getChildren(parentElement);
        }

        public Object getParent(Object element) {
            if (element instanceof IIteration && this.fIterationStructure != null) {
                IIterationHandle parent = ((IIteration)element).getParent();
                if (parent == null) {
                    return this.fRoot;
                }
                return this.fIterationStructure.getIterations(new IIterationHandle[]{parent});
            }
            return null;
        }

        public void fetchDeferredChildren(Object element, IElementCollector collector, IProgressMonitor monitor) {
            try {
                try {
                    ITeamAreaHandle handle;
                    if (element instanceof ITeamAreaHandle) {
                        handle = (ITeamAreaHandle)element;
                        element = PlanningClientPlugin.getAuditableClient((IItemHandle)handle).getDevelopmentLine(handle, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    if (element instanceof IDevelopmentLineHandle) {
                        handle = (IDevelopmentLineHandle)element;
                        ITeamRepository teamRepository = PlanningClientPlugin.getTeamRepository((IItemHandle)handle);
                        IItemManager manager = teamRepository.itemManager();
                        this.fRoot = (IDevelopmentLine)manager.fetchCompleteItem((IItemHandle)handle, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        this.fIterationStructure = IterationStructure.create((IProjectAreaHandle)this.fRoot.getProjectArea(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        collector.add(this.fIterationStructure.getIterations(this.fRoot.getIterations()).toArray(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        new UIJob(Messages.IterationSelectionDialog_JOB_SET_SELECTION){

                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                if (IterationContentProvider.this.fToResolve != null) {
                                    IterationContentProvider.this.fViewer.setSelection((ISelection)new StructuredSelection((Object)IterationContentProvider.this.fIterationStructure.getIteration(IterationContentProvider.this.fToResolve)), true);
                                } else {
                                    IterationContentProvider.this.fViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                                }
                                IterationContentProvider.this.fFetched = true;
                                return Status.OK_STATUS;
                            }
                        }.schedule();
                    } else if (element instanceof IIteration) {
                        IIteration iteration = (IIteration)element;
                        collector.add((Object[])this.getIterations(iteration.getChildren()), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                }
                catch (TeamRepositoryException teamRepositoryException) {
                    collector.done();
                    monitor.done();
                }
            }
            finally {
                collector.done();
                monitor.done();
            }
        }

        public IIteration[] getIterations(IIterationHandle[] handles) {
            ItemList iterations = this.fIterationStructure.getIterations(handles);
            ArrayList<IIteration> result = new ArrayList<IIteration>();
            for (IIteration iteration : iterations) {
                if (!this.fIterationStructure.showIteration((IIterationHandle)iteration)) continue;
                result.add(iteration);
            }
            return result.toArray(new IIteration[result.size()]);
        }

        public ISchedulingRule getRule(Object object) {
            return null;
        }

        public boolean isContainer() {
            return true;
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return null;
        }

        public String getLabel(Object o) {
            return this.fLabelProvider.getText(o);
        }
    }

    private static class LabelProvider
    extends StandardLabelProvider {
        public LabelProvider() {
            super((IElementRemovedNotifier)new ElementRemovedNotifierImpl());
        }

        public void updateLabel(ViewerLabel label, Object element) {
            super.updateLabel(label, element);
        }
    }
}

