/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.util;

import com.ibm.team.apt.internal.ide.core.util.Resolver;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.model.ItemProfile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemResolver<E extends IItem>
extends Resolver<E> {
    private IItemHandle fHandle;
    private ItemProfile fProfile;

    public ItemResolver(IItemHandle handle, ItemProfile profile) {
        Assert.isLegal((handle != null && handle.getOrigin() instanceof ITeamRepository ? 1 : 0) != 0);
        this.fHandle = handle;
        this.fProfile = profile;
    }

    public E resolve(IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository repository = (ITeamRepository)this.fHandle.getOrigin();
        IItemManager itemManager = repository.itemManager();
        if (this.fProfile != null) {
            return (E)itemManager.fetchPartialItem(this.fHandle, 0, this.fProfile.getProperties(), monitor);
        }
        return (E)itemManager.fetchCompleteItem(this.fHandle, 0, monitor);
    }

    public boolean belongsTo(Object family) {
        if (family instanceof IItemHandle) {
            return this.fHandle.sameItemId((IItemHandle)family);
        }
        return false;
    }

    public void cancel(IJobManager manager) {
        manager.cancel((Object)this.fHandle);
    }
}

