/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.teamload;

import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.util.IterationClient;
import com.ibm.team.apt.internal.ide.core.util.ITeamFutureListener;
import com.ibm.team.apt.internal.ide.core.util.TeamFuture;
import com.ibm.team.apt.internal.ide.core.util.TeamFutureAdapter;
import com.ibm.team.apt.internal.ide.core.util.TeamFutureEvent;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.navigator.ExtendedTeamAreaSelectionDialog;
import com.ibm.team.apt.internal.ide.ui.teamload.Messages;
import com.ibm.team.apt.internal.ide.ui.util.IterationSelectionDialog;
import com.ibm.team.apt.internal.ide.ui.util.UITeamFutureAdapter;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.common.ITeamAreaHierarchy;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import com.ibm.team.workitem.rcp.ui.internal.ProjectAreaPicker;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TeamLoadDialog
extends StatusDialog {
    private volatile IProjectAreaHandle fProjectAreaHandle;
    private volatile IProjectArea fProjectArea;
    private volatile IDevelopmentLine fDevLine;
    private volatile ITeamArea fTeamArea;
    private volatile IIteration fIteration;
    private boolean fInitialized;
    private Composite fContents;
    private Text fProjectAreaTextPart;
    private Text fTeamAreaTextPart;
    private Button fBrowseTeamArea;
    private Button fCurrentIteration;
    private Text fIterationTextPart;
    private Button fBrowseIteration;
    private ControlEnableState fEnableState;
    private AtomicInteger fBusyCount = new AtomicInteger(0);

    public TeamLoadDialog(Shell parent, IProjectAreaHandle projectArea, ITeamArea preselectedTeamArea, IIteration preseletedIteration) {
        super(parent);
        Assert.isNotNull((Object)projectArea);
        this.setTitle(Messages.TeamLoadDialog_CONFIGURE_TEAM_LOAD);
        this.setStatusLineAboveButtons(true);
        this.fProjectAreaHandle = projectArea;
        this.fTeamArea = preselectedTeamArea;
        this.fIteration = preseletedIteration;
    }

    public ITeamArea getTeamArea() {
        return this.fTeamArea;
    }

    public IIteration getIteration() {
        return this.fIteration;
    }

    public IProjectAreaHandle getProjectAreaHandle() {
        return this.fProjectAreaHandle;
    }

    public void create() {
        super.create();
    }

    protected Control createDialogArea(Composite parent) {
        this.fContents = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)this.fContents);
        this.fContents.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(3).create());
        Label label = new Label(this.fContents, 16384);
        label.setText(Messages.TeamLoadDialog_LABEL_PROJECT_AREA);
        this.fProjectAreaTextPart = new Text(this.fContents, 2056);
        this.fProjectAreaTextPart.setBackground(this.fContents.getBackground());
        GridData gridData = new GridData(768);
        gridData.widthHint = this.convertWidthInCharsToPixels(60);
        this.fProjectAreaTextPart.setLayoutData((Object)gridData);
        if (this.fProjectAreaHandle != null) {
            this.fProjectAreaTextPart.setText(TeamLoadDialog.projectAreaToString(this.fProjectAreaHandle));
        }
        Button button = new Button(this.fContents, 8);
        button.setText(Messages.TeamLoadDialog_BROWSE_PROJECT_AREA);
        button.setEnabled(ProjectAreaPicker.getAllConnectedProjectAreas((boolean)true).size() > 1);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IProjectAreaHandle handle = WorkItemUI.selectProjectArea((Shell)TeamLoadDialog.this.getShell());
                if (handle != null) {
                    try {
                        TeamLoadDialog.this.setBusy(true);
                        TeamLoadDialog.this.updateProjectArea(handle);
                    }
                    finally {
                        TeamLoadDialog.this.setBusy(false);
                    }
                }
            }
        });
        label = new Label(this.fContents, 16384);
        label.setText(Messages.TeamLoadDialog_LABEL_TEAM_AREA);
        this.fTeamAreaTextPart = new Text(this.fContents, 2056);
        this.fTeamAreaTextPart.setBackground(this.fContents.getBackground());
        this.fTeamAreaTextPart.setLayoutData((Object)gridData);
        this.fBrowseTeamArea = new Button(this.fContents, 8);
        this.fBrowseTeamArea.setText(Messages.TeamLoadDialog_BROWSE_TEAM_AREA);
        this.fBrowseTeamArea.setEnabled(this.fProjectAreaHandle != null);
        this.fBrowseTeamArea.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedTeamAreaSelectionDialog tasd = new ExtendedTeamAreaSelectionDialog(TeamLoadDialog.this.getShell());
                tasd.setInput(TeamLoadDialog.this.fProjectArea);
                if (tasd.open() == 0) {
                    TeamLoadDialog.this.updateTeamArea(tasd.getSelectedTeamArea());
                }
            }
        });
        label = new Label(this.fContents, 16384);
        label.setText(Messages.TeamLoadDialog_LABEL_ITERATION);
        this.fCurrentIteration = new Button(this.fContents, 32);
        GridDataFactory.fillDefaults().span(2, 0).grab(true, false).applyTo((Control)this.fCurrentIteration);
        this.fCurrentIteration.setText(Messages.TeamLoadDialog_CHECK_CURRENT_ITERATION);
        this.fCurrentIteration.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TeamLoadDialog.this.updateCurrentIteration();
            }
        });
        this.fCurrentIteration.setSelection(this.fIteration == null);
        new Label(this.fContents, 0);
        this.fIterationTextPart = new Text(this.fContents, 2056);
        this.fIterationTextPart.setBackground(this.fContents.getBackground());
        this.fIterationTextPart.setLayoutData((Object)gridData);
        if (this.fIteration != null) {
            this.fIterationTextPart.setText(this.fIteration.getLabel());
            this.fIterationTextPart.setData((Object)this.fIteration);
        }
        this.fBrowseIteration = new Button(this.fContents, 8);
        this.fBrowseIteration.setText(Messages.TeamLoadDialog_BROWSE_ITERATION);
        this.fBrowseIteration.setEnabled(this.fProjectAreaHandle != null);
        this.fBrowseIteration.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IterationSelectionDialog dialog = new IterationSelectionDialog(TeamLoadDialog.this.getShell(), (IIterationHandle)TeamLoadDialog.this.fIteration);
                dialog.setInput(TeamLoadDialog.this.fTeamArea);
                switch (dialog.open()) {
                    case 0: {
                        TeamLoadDialog.this.updateSelectedIteration((IIteration)dialog.getResult()[0]);
                    }
                }
            }
        });
        this.updateCurrentIteration();
        this.updateSelectedIteration(this.fIteration);
        Dialog.applyDialogFont((Control)this.fContents);
        class Result {
            IProjectArea projectArea;
            IDevelopmentLine devLine;
            String teamAreaLabel;
            IIteration iteration;

            Result() {
            }
        }
        TeamFuture<Result> future = new TeamFuture<Result>(true){

            protected Result resolve(IProgressMonitor monitor) throws TeamRepositoryException {
                try {
                    TeamLoadDialog.this.setBusy(true);
                    Result result = new Result();
                    if (TeamLoadDialog.this.fProjectAreaHandle != null) {
                        result.projectArea = (IProjectArea)PlanningClientPlugin.getTeamRepository((IItemHandle)TeamLoadDialog.this.fProjectAreaHandle).itemManager().fetchCompleteItem((IItemHandle)TeamLoadDialog.this.fProjectAreaHandle, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    if (TeamLoadDialog.this.fTeamArea != null) {
                        result.devLine = PlanningClientPlugin.getAuditableClient((IItemHandle)TeamLoadDialog.this.fTeamArea).getDevelopmentLine((ITeamAreaHandle)TeamLoadDialog.this.fTeamArea, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        result.teamAreaLabel = TeamLoadDialog.teamAreaToString(TeamLoadDialog.this.fTeamArea, monitor);
                    }
                    if (TeamLoadDialog.this.fIteration == null && result.devLine != null) {
                        result.iteration = IterationClient.getCurrentPlanLeafIteration((IDevelopmentLineHandle)result.devLine, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    Result result2 = result;
                    return result2;
                }
                finally {
                    TeamLoadDialog.this.setBusy(false);
                }
            }
        };
        future.addListener((ITeamFutureListener)UITeamFutureAdapter.create(this.getShell().getDisplay(), new TeamFutureAdapter<Result>(){

            public void resolvingDone(TeamFutureEvent<Result> event) {
                Result result = (Result)event.getTeamFuture().getResult();
                TeamLoadDialog.this.fProjectArea = result.projectArea;
                TeamLoadDialog.this.fDevLine = result.devLine;
                TeamLoadDialog.this.fTeamAreaTextPart.setText(result.teamAreaLabel != null ? result.teamAreaLabel : "");
                if (result.iteration != null) {
                    TeamLoadDialog.this.updateInferredIteration(result.iteration);
                }
                TeamLoadDialog.this.fInitialized = true;
            }

            public void resolvingFailed(TeamFutureEvent<Result> event) {
                TeamLoadDialog.this.fInitialized = true;
                TeamLoadDialog.this.showConnectionError(event.getTeamFuture().getStatus());
            }
        }));
        return this.fContents;
    }

    private void setBusy(boolean b) {
        if (b) {
            this.fBusyCount.incrementAndGet();
        } else {
            this.fBusyCount.decrementAndGet();
        }
        this.reflectBusy();
    }

    private void reflectBusy() {
        if (this.getShell().isDisposed()) {
            return;
        }
        this.getShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                switch (TeamLoadDialog.this.fBusyCount.get()) {
                    case 0: {
                        TeamLoadDialog.this.fEnableState.restore();
                        TeamLoadDialog.this.fEnableState = null;
                        TeamLoadDialog.this.update();
                        break;
                    }
                    case 1: {
                        if (TeamLoadDialog.this.fEnableState != null) break;
                        TeamLoadDialog.this.updateStatus((IStatus)new Status(1, PlanningUIPlugin.getPluginId(), Messages.TeamLoadDialog_MSG_LOADING_DATA));
                        TeamLoadDialog.this.fEnableState = ControlEnableState.disable((Control)TeamLoadDialog.this.getContents(), Arrays.asList(TeamLoadDialog.this.getButton(1)));
                    }
                }
            }
        });
    }

    protected void showConnectionError(IStatus status) {
        this.updateStatus(status);
        ControlEnableState.disable((Control)this.fContents, Arrays.asList(this.getButton(1)));
    }

    private void update() {
        String message = null;
        if (this.fTeamArea == null) {
            message = Messages.TeamLoadDialog_MSG_SELECT_TEAM_AREA;
        } else if (this.fIteration == null && !this.fCurrentIteration.getSelection()) {
            message = Messages.TeamLoadDialog_MSG_SELECT_ITERATION;
        }
        if (message != null) {
            this.updateStatus((IStatus)new Status(4, PlanningClientPlugin.getPluginId(), message));
        } else {
            this.updateStatus(Status.OK_STATUS);
        }
    }

    protected void updateStatus(IStatus status) {
        if (this.fInitialized || status.getSeverity() != 4) {
            super.updateStatus(status);
        } else {
            Button ok = this.getButton(0);
            if (ok != null) {
                super.updateStatus((IStatus)new Status(1, status.getPlugin(), status.getMessage()));
                ok.setEnabled(false);
            } else {
                super.updateStatus((IStatus)new Status(4, status.getPlugin(), ""));
            }
        }
    }

    private void updateProjectArea(final IProjectAreaHandle handle) {
        this.fProjectAreaHandle = handle;
        this.fBrowseTeamArea.setEnabled(this.fProjectAreaHandle != null);
        this.fBrowseIteration.setEnabled(this.fProjectAreaHandle != null);
        if (this.fProjectAreaHandle == null) {
            this.fProjectAreaTextPart.setText("");
            this.fProjectArea = null;
            this.updateTeamArea(null, "");
            this.updateSelectedIteration(null);
        } else {
            this.fProjectAreaTextPart.setText(TeamLoadDialog.projectAreaToString(this.fProjectAreaHandle));
            class Result {
                public IProjectArea projectArea;
                public IDevelopmentLine devLine;
                public ITeamArea teamArea;
                public String teamAreaLabel;
                public IIteration iteration;

                Result() {
                }
            }
            TeamFuture<Result> future = new TeamFuture<Result>(true){

                protected Result resolve(IProgressMonitor monitor) throws TeamRepositoryException {
                    try {
                        Result result = new Result();
                        TeamLoadDialog.this.setBusy(true);
                        IItemManager manager = PlanningClientPlugin.getTeamRepository((IItemHandle)handle).itemManager();
                        result.projectArea = (IProjectArea)manager.fetchCompleteItem((IItemHandle)handle, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        ITeamAreaHierarchy teamAreaHierarchy = result.projectArea.getTeamAreaHierarchy();
                        Set roots = teamAreaHierarchy.getRoots();
                        if (roots.isEmpty()) {
                            Result result2 = result;
                            return result2;
                        }
                        Iterator iter = roots.iterator();
                        while (result.teamArea == null && iter.hasNext()) {
                            ITeamArea teamArea = (ITeamArea)manager.fetchCompleteItem((IItemHandle)iter.next(), 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            if (teamArea.isArchived()) continue;
                            result.teamArea = teamArea;
                        }
                        if (result.teamArea == null) {
                            Result result3 = result;
                            return result3;
                        }
                        result.teamAreaLabel = TeamLoadDialog.teamAreaToString(result.teamArea, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        result.devLine = (IDevelopmentLine)manager.fetchCompleteItem((IItemHandle)teamAreaHierarchy.getDevelopmentLine((ITeamAreaHandle)result.teamArea), 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        result.iteration = IterationClient.getCurrentPlanLeafIteration((IDevelopmentLineHandle)result.devLine, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        Result result4 = result;
                        return result4;
                    }
                    finally {
                        TeamLoadDialog.this.setBusy(false);
                    }
                }
            };
            future.addListener((ITeamFutureListener)UITeamFutureAdapter.create(this.getShell().getDisplay(), new TeamFutureAdapter<Result>(){

                public void resolvingDone(TeamFutureEvent<Result> event) {
                    Result result = (Result)event.getTeamFuture().getResult();
                    TeamLoadDialog.this.fProjectArea = result.projectArea;
                    TeamLoadDialog.this.fDevLine = result.devLine;
                    TeamLoadDialog.this.updateTeamArea(result.teamArea, result.teamAreaLabel);
                    TeamLoadDialog.this.updateInferredIteration(result.iteration);
                }

                public void resolvingFailed(TeamFutureEvent<Result> event) {
                    TeamLoadDialog.this.showConnectionError(event.getTeamFuture().getStatus());
                }
            }));
        }
    }

    private static String projectAreaToString(IProjectAreaHandle projectArea) {
        String name1 = ConnectedProjectAreaRegistry.getDefault().getProjectAreaName(projectArea);
        String name2 = PlanningClientPlugin.getTeamRepository((IItemHandle)projectArea).getName();
        name2 = name2 == null ? PlanningClientPlugin.getTeamRepository((IItemHandle)projectArea).getRepositoryURI() : name2;
        StringBuilder text = new StringBuilder();
        text.append(name1);
        text.append(" [");
        text.append(name2);
        text.append(']');
        return text.toString();
    }

    private static String teamAreaToString(ITeamArea teamArea, IProgressMonitor monitor) throws TeamRepositoryException {
        StringBuilder result = new StringBuilder();
        IItemManager manager = PlanningClientPlugin.getTeamRepository((IItemHandle)teamArea).itemManager();
        IProjectArea projectArea = (IProjectArea)manager.fetchCompleteItem((IItemHandle)teamArea.getProjectArea(), 0, monitor);
        ITeamAreaHierarchy hierarchy = projectArea.getTeamAreaHierarchy();
        TeamLoadDialog.teamAreaToString(result, teamArea, hierarchy, manager, monitor);
        result.trimToSize();
        result.deleteCharAt(result.length() - 1);
        return result.toString();
    }

    private static void teamAreaToString(StringBuilder result, ITeamArea teamArea, ITeamAreaHierarchy hierarchy, IItemManager manager, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamAreaHandle parent = hierarchy.getParent((ITeamAreaHandle)teamArea);
        if (parent != null) {
            ITeamArea resolvedParent = (ITeamArea)manager.fetchCompleteItem((IItemHandle)parent, 0, monitor);
            TeamLoadDialog.teamAreaToString(result, resolvedParent, hierarchy, manager, monitor);
        }
        result.append(teamArea.getName());
        result.append("/");
    }

    private void updateTeamArea(final ITeamArea teamArea) {
        if (teamArea == null) {
            this.updateTeamArea(teamArea, "");
        } else {
            class Result {
                String teamAreaLabel;
                IDevelopmentLine devLine;
                IIteration iteration;

                Result() {
                }
            }
            TeamFuture<Result> future = new TeamFuture<Result>(true){

                protected Result resolve(IProgressMonitor monitor) throws TeamRepositoryException {
                    try {
                        TeamLoadDialog.this.setBusy(true);
                        Result result = new Result();
                        result.teamAreaLabel = TeamLoadDialog.teamAreaToString(teamArea, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        IDevelopmentLine line = PlanningClientPlugin.getAuditableClient((IItemHandle)teamArea).getDevelopmentLine((ITeamAreaHandle)teamArea, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        if (TeamLoadDialog.this.fDevLine == null || !TeamLoadDialog.this.fDevLine.sameItemId((IItemHandle)line)) {
                            result.devLine = line;
                            result.iteration = IterationClient.getCurrentPlanLeafIteration((IDevelopmentLineHandle)line, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        }
                        Result result2 = result;
                        return result2;
                    }
                    finally {
                        TeamLoadDialog.this.setBusy(false);
                    }
                }
            };
            future.addListener((ITeamFutureListener)UITeamFutureAdapter.create(this.getShell().getDisplay(), new TeamFutureAdapter<Result>(){

                public void resolvingDone(TeamFutureEvent<Result> event) {
                    Result result = (Result)event.getTeamFuture().getResult();
                    TeamLoadDialog.this.updateTeamArea(teamArea, result.teamAreaLabel);
                    if (result.devLine != null) {
                        TeamLoadDialog.this.fDevLine = result.devLine;
                        TeamLoadDialog.this.updateInferredIteration(result.iteration);
                    }
                }

                public void resolvingFailed(TeamFutureEvent<Result> event) {
                    TeamLoadDialog.this.showConnectionError(event.getTeamFuture().getStatus());
                }
            }));
        }
    }

    private void updateTeamArea(ITeamArea teamArea, String label) {
        this.fTeamArea = teamArea;
        if (this.fTeamArea == null) {
            this.fTeamAreaTextPart.setText("");
        } else {
            this.fTeamAreaTextPart.setText(label);
        }
        this.update();
    }

    private void updateCurrentIteration() {
        this.fIteration = this.fCurrentIteration.getSelection() ? null : (IIteration)this.fIterationTextPart.getData();
        this.fIterationTextPart.setEnabled(!this.fCurrentIteration.getSelection());
        this.fBrowseIteration.setEnabled(!this.fCurrentIteration.getSelection());
        this.update();
    }

    private void updateSelectedIteration(IIteration iteration) {
        this.fIteration = iteration;
        if (this.fIteration != null) {
            this.fIterationTextPart.setText(this.fIteration.getLabel());
            this.fIterationTextPart.setData((Object)this.fIteration);
        } else {
            this.fIterationTextPart.setText("");
            this.fIterationTextPart.setData(null);
        }
        this.update();
    }

    private void updateInferredIteration(IIteration iteration) {
        this.updateSelectedIteration(iteration);
        if (this.fCurrentIteration.getSelection()) {
            this.fIteration = null;
        }
    }
}

