/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.resource.widgets;

import com.ibm.team.workitem.common.model.DurationFormat;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;

public final class DurationPickerWidget
extends Composite {
    private static final DurationFormat fgDurationFormat = DurationFormat.getInstance((int)3);
    private final Label fHourLabel;
    private int fHours = 0;
    private final Spinner fHourSpinner;
    private final Label fMinuteLabel;
    private int fMinutes = 0;
    private final Spinner fMinuteSpinner;

    public DurationPickerWidget(Composite parent) {
        super(parent, 0);
        GridLayout layout = new GridLayout(4, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        this.fHourSpinner = new Spinner((Composite)this, 2112);
        this.fHourSpinner.setValues(this.fHours, 0, 23, 0, 1, 4);
        this.fHourSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DurationPickerWidget.this.fHours = DurationPickerWidget.this.fHourSpinner.getSelection();
            }
        });
        this.fHourSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                DurationPickerWidget.this.fHours = DurationPickerWidget.this.fHourSpinner.getSelection();
            }
        });
        this.fHourLabel = new Label((Composite)this, 64);
        this.fHourLabel.setText(fgDurationFormat.getUnitString(DurationFormat.UNIT_HOURS, Double.MAX_VALUE));
        this.fMinuteSpinner = new Spinner((Composite)this, 2112);
        this.fMinuteSpinner.setValues(this.fMinutes, 0, 59, 0, 1, 15);
        this.fMinuteSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DurationPickerWidget.this.fMinutes = DurationPickerWidget.this.fMinuteSpinner.getSelection();
            }
        });
        this.fMinuteSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                DurationPickerWidget.this.fMinutes = DurationPickerWidget.this.fMinuteSpinner.getSelection();
            }
        });
        this.fMinuteLabel = new Label((Composite)this, 64);
        this.fMinuteLabel.setText(fgDurationFormat.getUnitString(DurationFormat.UNIT_MINUTES, Double.MAX_VALUE));
    }

    public void addModifyListener(ModifyListener listener) {
        this.fHourSpinner.addModifyListener(listener);
        this.fMinuteSpinner.addModifyListener(listener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.fHourSpinner.addSelectionListener(listener);
        this.fMinuteSpinner.addSelectionListener(listener);
    }

    public int getHours() {
        return this.fHours;
    }

    public int getMinutes() {
        return this.fMinutes;
    }

    public void removeModifyListener(ModifyListener listener) {
        this.fHourSpinner.removeModifyListener(listener);
        this.fMinuteSpinner.removeModifyListener(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.fHourSpinner.removeSelectionListener(listener);
        this.fMinuteSpinner.removeSelectionListener(listener);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.fHourLabel.setEnabled(enabled);
        this.fHourSpinner.setEnabled(enabled);
        this.fMinuteLabel.setEnabled(enabled);
        this.fMinuteSpinner.setEnabled(enabled);
    }

    public void setHours(int hours) {
        Assert.isLegal((hours >= 0 && hours <= 23 ? 1 : 0) != 0);
        this.fHours = hours;
        this.fHourSpinner.setSelection(this.fHours);
    }

    public void setMinutes(int minutes) {
        Assert.isLegal((minutes >= 0 && minutes <= 59 ? 1 : 0) != 0);
        this.fMinutes = minutes;
        this.fMinuteSpinner.setSelection(this.fMinutes);
    }
}

