/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.resource.parts;

import com.ibm.icu.text.Collator;
import com.ibm.icu.util.Calendar;
import com.ibm.team.apt.common.resource.IContributorAbsence;
import com.ibm.team.apt.common.resource.IContributorAbsenceHandle;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.resource.OperationStatus;
import com.ibm.team.apt.internal.common.resource.model.ContributorAbsence;
import com.ibm.team.apt.internal.common.util.ItemArrayList;
import com.ibm.team.apt.internal.common.util.ItemCollection;
import com.ibm.team.apt.internal.common.util.ItemCollections;
import com.ibm.team.apt.internal.common.util.ItemHashSet;
import com.ibm.team.apt.internal.ide.ui.ImagePool;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.resource.AbstractContributorResourceFormPage;
import com.ibm.team.apt.internal.ide.ui.resource.AbstractContributorResourceInput;
import com.ibm.team.apt.internal.ide.ui.resource.ContributorAbsencesFormPage;
import com.ibm.team.apt.internal.ide.ui.resource.parts.AbstractContributorResourceFormPart;
import com.ibm.team.apt.internal.ide.ui.resource.parts.Messages;
import com.ibm.team.apt.internal.ide.ui.resource.widgets.ContributorAbsenceDialog;
import com.ibm.team.apt.internal.ide.ui.resource.widgets.DatePickerWidget;
import com.ibm.team.apt.internal.ide.ui.util.PixelConverter;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.process.internal.ide.ui.editors.contributor.ContributorEditor;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;

public final class ContributorAbsencesFormPart
extends AbstractContributorResourceFormPart {
    public static final String PART_ID = "com.ibm.team.apt.resource.contributor.absences.part.name";
    private final ContributorAbsencesDateFilter fAbsencesFilter = new ContributorAbsencesDateFilter();
    private TableViewer fAbsencesViewer;
    private Button fAddButton;
    private TableColumn fDateColumn;
    private final DateFormat fDateFormat = DateFormat.getDateInstance(2);
    private Button fDeselectAllButton;
    private Button fEditButton;
    private DatePickerWidget fEndDateWidget;
    private IProgressMonitor fMonitor = null;
    private Button fRemoveButton;
    private final ResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());
    private Button fSelectAllButton;
    private DatePickerWidget fStartDateWidget;
    private TableColumn fSummaryColumn;

    private static boolean coversSingleDay(IContributorAbsence absence) {
        Assert.isNotNull((Object)absence);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(absence.getStartDate());
        int startDay = calendar.get(6);
        calendar.setTime(absence.getEndDate());
        int endDay = calendar.get(6);
        return startDay == endDay;
    }

    private static Date normalizeEndDate(Date date) {
        Assert.isNotNull((Object)date);
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(date.getTime());
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    private static Date normalizeStartDate(Date date) {
        Assert.isNotNull((Object)date);
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(date.getTime());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    private static void setButtonWidth(Button button) {
        Assert.isNotNull((Object)button);
        Object data = button.getLayoutData();
        if (data instanceof GridData) {
            GridData extended = (GridData)data;
            extended.widthHint = Math.max(new PixelConverter((Control)button).convertHorizontalDLUsToPixels(61), button.computeSize((int)-1, (int)-1, (boolean)true).x);
            extended.horizontalAlignment = 4;
        }
    }

    public ContributorAbsencesFormPart(ContributorAbsencesFormPage page) {
        super(page);
        this.setId(PART_ID);
    }

    private void createAbsencesViewer(Composite parent) {
        Assert.isNotNull((Object)parent);
        FormToolkit toolkit = this.getToolkit();
        final Table table = toolkit.createTable(parent, 67586);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.fSummaryColumn = new TableColumn(table, 16384, 0);
        this.fSummaryColumn.setWidth(280);
        this.fSummaryColumn.setResizable(true);
        this.fSummaryColumn.setText(Messages.ContributorAbsencesFormPart_SUMMARY_COLUMN);
        this.fSummaryColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableColumn column = table.getSortColumn();
                if (column != ContributorAbsencesFormPart.this.fSummaryColumn) {
                    table.setSortColumn(ContributorAbsencesFormPart.this.fSummaryColumn);
                } else {
                    int direction = table.getSortDirection();
                    if (direction == 128) {
                        table.setSortDirection(1024);
                    } else if (direction == 1024) {
                        table.setSortDirection(128);
                    }
                }
                ContributorAbsencesFormPart.this.fAbsencesViewer.refresh(false);
            }
        });
        this.fDateColumn = new TableColumn(table, 16384, 1);
        this.fDateColumn.setWidth(160);
        this.fDateColumn.setResizable(true);
        this.fDateColumn.setText(Messages.ContributorAbsencesFormPart_DATE_COLUMN);
        this.fDateColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableColumn column = table.getSortColumn();
                if (column != ContributorAbsencesFormPart.this.fDateColumn) {
                    table.setSortColumn(ContributorAbsencesFormPart.this.fDateColumn);
                } else {
                    int direction = table.getSortDirection();
                    if (direction == 128) {
                        table.setSortDirection(1024);
                    } else if (direction == 1024) {
                        table.setSortDirection(128);
                    }
                }
                ContributorAbsencesFormPart.this.fAbsencesViewer.refresh(false);
            }
        });
        table.setSortColumn(this.fDateColumn);
        table.setSortDirection(128);
        this.fAbsencesViewer = new TableViewer(table);
        this.fAbsencesViewer.addFilter((ViewerFilter)this.fAbsencesFilter);
        this.fAbsencesViewer.setLabelProvider((IBaseLabelProvider)new ContributorAbsencesLabelProvider());
        this.fAbsencesViewer.setContentProvider((IContentProvider)new ContributorAbsencesContentProvider());
        this.fAbsencesViewer.setComparator((ViewerComparator)new ContributorAbsencesViewerComparator());
        this.fAbsencesViewer.setColumnProperties(new String[]{Messages.ContributorAbsencesFormPart_SUMMARY_PROPERTY, Messages.ContributorAbsencesFormPart_DATE_PROPERTY});
        this.fAbsencesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Assert.isNotNull((Object)event);
                int total = 0;
                ItemCollection absences = (ItemCollection)ContributorAbsencesFormPart.this.fAbsencesViewer.getInput();
                if (absences != null) {
                    total = absences.size();
                }
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                ContributorAbsencesFormPart.this.fRemoveButton.setEnabled(!selection.isEmpty());
                int size = selection.size();
                ContributorAbsencesFormPart.this.fEditButton.setEnabled(size == 1);
                ContributorAbsencesFormPart.this.fDeselectAllButton.setEnabled(size > 0);
                ContributorAbsencesFormPart.this.fSelectAllButton.setEnabled(size != total);
            }
        });
        this.fAbsencesViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.size() == 1) {
                    ContributorAbsencesFormPart.this.editSelection(selection);
                }
            }
        });
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menu) {
                final IStructuredSelection selection = (IStructuredSelection)ContributorAbsencesFormPart.this.fAbsencesViewer.getSelection();
                if (selection.size() == 1) {
                    menu.add((IAction)new Action(Messages.ContributorAbsencesFormPart_EDIT_CONTEXT_ACTION){

                        public void run() {
                            ContributorAbsencesFormPart.this.editSelection(selection);
                        }
                    });
                    menu.add((IContributionItem)new Separator());
                }
                if (selection.size() >= 1) {
                    menu.add((IAction)new Action(Messages.ContributorAbsencesFormPart_REMOVE_CONTEXT_ACTION){

                        public void run() {
                            ContributorAbsencesFormPart.this.removeSelection(selection);
                        }
                    });
                }
            }
        });
        Menu menu = manager.createContextMenu((Control)table);
        table.setMenu(menu);
        new TooltipSupport((Control)table, true, true){

            protected String getMarkup(Object element, boolean isFocus) {
                if (element instanceof IContributorAbsence) {
                    IContributorAbsence absence = (IContributorAbsence)element;
                    StringBuilder builder = new StringBuilder(256);
                    builder.append("<b>");
                    builder.append(absence.getSummary());
                    builder.append("</b><br/>");
                    if (ContributorAbsencesFormPart.coversSingleDay(absence)) {
                        builder.append(MessageFormat.format(Messages.ContributorAbsencesFormPart_DUE_PATTERN, ContributorAbsencesFormPart.this.fDateFormat.format(absence.getStartDate())));
                    } else {
                        builder.append(MessageFormat.format(Messages.ContributorAbsencesFormPart_START_PATTERN, ContributorAbsencesFormPart.this.fDateFormat.format(absence.getStartDate())));
                        builder.append("<br/>");
                        builder.append(MessageFormat.format(Messages.ContributorAbsencesFormPart_END_PATTERN, ContributorAbsencesFormPart.this.fDateFormat.format(absence.getEndDate())));
                    }
                    ContributorAbsencesFormPart.this.appendMailLinks(builder, isFocus);
                    return builder.toString();
                }
                return super.getMarkup(element, isFocus);
            }

            protected void openRequested(Object element) {
                if (element != null) {
                    ContributorAbsencesFormPart.this.editSelection((IStructuredSelection)new StructuredSelection(element));
                }
            }
        };
        this.getSite().registerSelectionProvider((ISelectionProvider)this.fAbsencesViewer, this.fAbsencesViewer.getControl());
    }

    private void createAbsencesWidgets(Composite parent) {
        Assert.isNotNull((Object)parent);
        FormToolkit toolkit = this.getToolkit();
        Composite composite = toolkit.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 5;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4, 0x1000000, true, false);
        data.horizontalSpan = 2;
        data.verticalIndent = 10;
        composite.setLayoutData((Object)data);
        Label label = toolkit.createLabel(composite, Messages.ContributorAbsencesFormPart_SHOW_ABSENCES_LABEL);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.fStartDateWidget = new DatePickerWidget(composite, this.fDateFormat, this.fResourceManager, toolkit);
        this.fStartDateWidget.getDecoration().setDescriptionText(Messages.ContributorAbsencesFormPart_ENTER_VALID_START_DATE);
        data = new GridData(16384, 0x1000000, false, false);
        data.horizontalIndent = 4;
        this.fStartDateWidget.setLayoutData(data);
        Text startText = this.fStartDateWidget.getText();
        Date date = this.fAbsencesFilter.getStartDate();
        if (date != null) {
            startText.setText(this.fDateFormat.format(date));
        }
        startText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                ContributorAbsencesFormPart.this.handleStartDateChanged();
                ContributorAbsencesFormPart.this.handleEndDateChanged();
            }
        });
        label = toolkit.createLabel(composite, Messages.ContributorAbsencesFormPart_TO_LABEL);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.fEndDateWidget = new DatePickerWidget(composite, this.fDateFormat, this.fResourceManager, toolkit);
        this.fEndDateWidget.getDecoration().setDescriptionText(Messages.ContributorAbsencesFormPart_ENTER_VALID_END_DATE);
        data = new GridData(16384, 0x1000000, false, false);
        data.horizontalIndent = 4;
        this.fEndDateWidget.setLayoutData(data);
        Text endText = this.fEndDateWidget.getText();
        date = this.fAbsencesFilter.getEndDate();
        if (date != null) {
            endText.setText(this.fDateFormat.format(date));
        }
        endText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                ContributorAbsencesFormPart.this.handleEndDateChanged();
            }
        });
        this.createRefreshLink(composite);
    }

    private Button createButton(Composite parent, String label) {
        Assert.isNotNull((Object)parent);
        Assert.isNotNull((Object)label);
        FormToolkit toolkit = this.getToolkit();
        Button button = toolkit.createButton(parent, label, 8);
        button.setLayoutData((Object)new GridData(258));
        ContributorAbsencesFormPart.setButtonWidth(button);
        return button;
    }

    private void createButtons(Composite parent) {
        Assert.isNotNull((Object)parent);
        FormToolkit toolkit = this.getToolkit();
        Composite composite = toolkit.createComposite(parent);
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(144));
        this.fAddButton = this.createButton(composite, Messages.ContributorAbsencesFormPart_NEW_BUTTON_LABEL);
        this.fAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AbstractContributorResourceInput input = ContributorAbsencesFormPart.this.getInput();
                if (input != null) {
                    ItemHashSet absences = new ItemHashSet((ItemCollection)ContributorAbsencesFormPart.this.fAbsencesViewer.getInput());
                    ContributorAbsenceDialog dialog = new ContributorAbsenceDialog(ContributorAbsencesFormPart.this.getShell(), Messages.ContributorAbsencesFormPart_NEW_ABSENCE_DIALOG_CAPTION, Messages.ContributorAbsencesFormPart_NEW_ABSENCE_DIALOG_DESCRIPTION, null, (ItemCollection<IContributorAbsence>)absences);
                    if (dialog.open() == 0) {
                        Date endDate;
                        ContributorAbsence absence = (ContributorAbsence)IContributorAbsence.ITEM_TYPE.createItem();
                        absence.setContributor((IContributorHandle)input.getContributor());
                        absence.setSummary(dialog.getSummary());
                        Date startDate = dialog.getStartDate();
                        if (startDate != null && ContributorAbsencesFormPart.this.fAbsencesFilter.getStartDate() != null && startDate.before(ContributorAbsencesFormPart.this.fAbsencesFilter.getStartDate())) {
                            ContributorAbsencesFormPart.this.fAbsencesFilter.setStartDate(ContributorAbsencesFormPart.normalizeStartDate(startDate));
                            ContributorAbsencesFormPart.this.fStartDateWidget.getText().setText(ContributorAbsencesFormPart.this.fDateFormat.format(startDate));
                        }
                        if ((endDate = dialog.getEndDate()) != null && ContributorAbsencesFormPart.this.fAbsencesFilter.getEndDate() != null && endDate.after(ContributorAbsencesFormPart.this.fAbsencesFilter.getEndDate())) {
                            ContributorAbsencesFormPart.this.fAbsencesFilter.setEndDate(ContributorAbsencesFormPart.normalizeEndDate(endDate));
                            ContributorAbsencesFormPart.this.fEndDateWidget.getText().setText(ContributorAbsencesFormPart.this.fDateFormat.format(endDate));
                        }
                        absence.setStartDate(new Timestamp(startDate.getTime()));
                        absence.setEndDate(new Timestamp(endDate.getTime()));
                        absences.add((Object)absence);
                        ContributorAbsencesFormPart.this.fAbsencesViewer.setInput((Object)absences);
                        ContributorAbsencesFormPart.this.getFormPage().setDirty(true);
                    }
                }
            }
        });
        this.fEditButton = this.createButton(composite, Messages.ContributorAbsencesFormPart_EDIT_BUTTON_LABEL);
        this.fEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ContributorAbsencesFormPart.this.fAbsencesViewer.getSelection();
                if (selection.size() == 1) {
                    ContributorAbsencesFormPart.this.editSelection(selection);
                }
            }
        });
        this.fEditButton.setEnabled(false);
        this.fRemoveButton = this.createButton(composite, Messages.ContributorAbsencesFormPart_REMOVE_BUTTON_LABEL);
        this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ContributorAbsencesFormPart.this.removeSelection((IStructuredSelection)ContributorAbsencesFormPart.this.fAbsencesViewer.getSelection());
            }
        });
        this.fRemoveButton.setEnabled(false);
        Label dummy = toolkit.createLabel(composite, "");
        this.fSelectAllButton = this.createButton(composite, Messages.ContributorAbsencesFormPart_SELECT_ALL_BUTTON_LABEL);
        this.fSelectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ContributorAbsencesFormPart.this.selectAll();
            }
        });
        this.fDeselectAllButton = this.createButton(composite, Messages.ContributorAbsencesFormPart_DESELECT_ALL_BUTTON_LABEL);
        this.fDeselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ContributorAbsencesFormPart.this.fAbsencesViewer.setSelection((ISelection)StructuredSelection.EMPTY);
            }
        });
        this.fDeselectAllButton.setEnabled(false);
        GridData data = new GridData();
        data.heightHint = new PixelConverter((Control)parent).convertHeightInCharsToPixels(1) / 2;
        dummy.setLayoutData((Object)data);
    }

    public void createContent(Composite parent) {
        Assert.isNotNull((Object)parent);
        FormToolkit toolkit = this.getToolkit();
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        parent.addDisposeListener(new DisposeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void widgetDisposed(DisposeEvent event) {
                14 var2_2 = this;
                synchronized (var2_2) {
                    if (ContributorAbsencesFormPart.this.fMonitor != null && !ContributorAbsencesFormPart.this.fMonitor.isCanceled()) {
                        ContributorAbsencesFormPart.this.fMonitor.setCanceled(true);
                    }
                }
            }
        });
        this.createDescription(parent);
        Composite composite = toolkit.createComposite(parent);
        layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginBottom = 10;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createAbsencesWidgets(composite);
        this.createAbsencesViewer(composite);
        this.createButtons(composite);
        this.hookGlobalActions();
    }

    private void createDescription(Composite parent) {
        Assert.isNotNull((Object)parent);
        FormToolkit toolkit = this.getToolkit();
        Label label = toolkit.createLabel(parent, Messages.ContributorAbsencesFormPart_ABSENCE_PART_HEADER);
        label.setLayoutData((Object)new GridData(4, 1, false, false));
    }

    private void createRefreshLink(Composite control) {
        Composite composite = new Composite(control, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        CLabel label = new CLabel(composite, 131072);
        label.setToolTipText(Messages.ContributorAbsencesFormPart_REFRESH_ABSENCES_TOOLTIP);
        label.setImage(this.fResourceManager.createImage(PlanningUIPlugin.getImageDescriptor("icons/elcl16/refresh.gif")));
        Hyperlink link = this.getToolkit().createHyperlink(composite, Messages.ContributorAbsencesFormPart_REFRESH_ABSENCES_LABEL, 64);
        link.setToolTipText(Messages.ContributorAbsencesFormPart_REFRESH_ABSENCES_TOOLTIP);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent event) {
                Assert.isNotNull((Object)event);
                AbstractContributorResourceInput input = ContributorAbsencesFormPart.this.getInput();
                if (input != null) {
                    Control control = ContributorAbsencesFormPart.this.fAbsencesViewer.getControl();
                    Display display = control.getDisplay();
                    Date date = ContributorAbsencesFormPart.this.fAbsencesFilter.getStartDate();
                    Timestamp stamp = date != null ? new Timestamp(date.getTime()) : new Timestamp(0L);
                    IContributor contributor = input.getContributor();
                    ItemHashSet predecessors = new ItemHashSet((ItemCollection)ContributorAbsencesFormPart.this.fAbsencesViewer.getInput());
                    FoundationJob job = new FoundationJob(Messages.ContributorAbsencesFormPart_REFRESH_ABSENCES_JOB_NAME, (IContributorHandle)contributor, stamp, (ItemCollection)predecessors, display, control){
                        private final /* synthetic */ IContributorHandle val$contributor;
                        private final /* synthetic */ Timestamp val$stamp;
                        private final /* synthetic */ ItemCollection val$predecessors;
                        private final /* synthetic */ Display val$display;
                        private final /* synthetic */ Control val$control;
                        {
                            this.val$contributor = iContributorHandle;
                            this.val$stamp = timestamp;
                            this.val$predecessors = itemCollection;
                            this.val$display = display;
                            this.val$control = control;
                            super($anonymous0);
                        }

                        protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                            ItemCollection successors = PlanningClientPlugin.getResourcePlanningManager((IItemHandle)this.val$contributor).getContributorInfo(ItemCollections.singleton((Object)this.val$contributor), this.val$stamp, null, true, true, monitor).getAbsences(this.val$contributor);
                            this.val$predecessors.removeAll(successors);
                            this.val$predecessors.addAll(successors);
                            ItemArrayList toRemove = new ItemArrayList(this.val$predecessors.size());
                            for (IContributorAbsence absence : this.val$predecessors) {
                                if (!absence.getEndDate().before(this.val$stamp) || absence.isWorkingCopy() || absence.isNewItem()) continue;
                                toRemove.add((Object)absence);
                            }
                            this.val$predecessors.removeAll((ItemCollection)toRemove);
                            if (!this.val$display.isDisposed()) {
                                this.val$display.asyncExec(new Runnable(){

                                    public void run() {
                                        if (!val$control.isDisposed()) {
                                            ContributorAbsencesFormPart.this.fAbsencesViewer.setInput((Object)val$predecessors);
                                            ContributorAbsencesFormPart.this.fAddButton.setEnabled(true);
                                            ContributorAbsencesFormPart.this.fEditButton.setEnabled(false);
                                            ContributorAbsencesFormPart.this.fRemoveButton.setEnabled(false);
                                            ContributorAbsencesFormPart.this.fSelectAllButton.setEnabled(!val$predecessors.isEmpty());
                                            ContributorAbsencesFormPart.this.fDeselectAllButton.setEnabled(false);
                                        }
                                    }
                                });
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    job.setSystem(false);
                    job.setUser(true);
                    job.setPriority(10);
                    job.schedule();
                }
            }
        });
    }

    public void dispose() {
        super.dispose();
        this.fResourceManager.dispose();
    }

    private void editSelection(IStructuredSelection selection) {
        if (!selection.isEmpty()) {
            IContributorAbsence absence = (IContributorAbsence)selection.getFirstElement();
            ItemHashSet absences = new ItemHashSet((ItemCollection)this.fAbsencesViewer.getInput());
            ItemHashSet existing = new ItemHashSet((ItemCollection)absences);
            existing.remove((Object)absence);
            ContributorAbsenceDialog dialog = new ContributorAbsenceDialog(this.getShell(), Messages.ContributorAbsencesFormPart_EDIT_ABSENCE_DIALOG_CAPTION, Messages.ContributorAbsencesFormPart_EDIT_ABSENCE_DIALOG_DESCRIPTION, absence, (ItemCollection<IContributorAbsence>)existing);
            if (dialog.open() == 0) {
                Date endDate;
                ContributorAbsence workingCopy = (ContributorAbsence)absence.getWorkingCopy();
                Date startDate = dialog.getStartDate();
                if (startDate != null && this.fAbsencesFilter.getStartDate() != null && startDate.before(this.fAbsencesFilter.getStartDate())) {
                    this.fAbsencesFilter.setStartDate(ContributorAbsencesFormPart.normalizeStartDate(startDate));
                    this.fStartDateWidget.getText().setText(this.fDateFormat.format(startDate));
                }
                if ((endDate = dialog.getEndDate()) != null && this.fAbsencesFilter.getEndDate() != null && endDate.after(this.fAbsencesFilter.getEndDate())) {
                    this.fAbsencesFilter.setEndDate(ContributorAbsencesFormPart.normalizeEndDate(endDate));
                    this.fEndDateWidget.getText().setText(this.fDateFormat.format(endDate));
                }
                workingCopy.setSummary(dialog.getSummary());
                workingCopy.setStartDate(new Timestamp(startDate.getTime()));
                workingCopy.setEndDate(new Timestamp(endDate.getTime()));
                absences.remove((Object)absence);
                absences.add((Object)workingCopy);
                this.fAbsencesViewer.setInput((Object)absences);
                this.getFormPage().setDirty(true);
            }
        }
    }

    void handleEndDateChanged() {
        boolean valid = true;
        try {
            String text = this.fEndDateWidget.getText().getText();
            if (!"".equals(text)) {
                this.fAbsencesFilter.setEndDate(ContributorAbsencesFormPart.normalizeEndDate(this.fDateFormat.parse(text)));
            } else {
                this.fAbsencesFilter.setEndDate(null);
            }
        }
        catch (ParseException parseException) {
            valid = false;
            this.fAbsencesFilter.setEndDate(null);
        }
        ControlDecoration decoration = this.fEndDateWidget.getDecoration();
        if (valid && this.fAbsencesFilter.isValid()) {
            decoration.hide();
        } else {
            decoration.show();
        }
        this.fAbsencesViewer.refresh(false);
    }

    void handleStartDateChanged() {
        boolean valid = true;
        try {
            String text = this.fStartDateWidget.getText().getText();
            if (!"".equals(text)) {
                this.fAbsencesFilter.setStartDate(ContributorAbsencesFormPart.normalizeStartDate(this.fDateFormat.parse(text)));
            } else {
                this.fAbsencesFilter.setStartDate(null);
            }
        }
        catch (ParseException parseException) {
            valid = false;
            this.fAbsencesFilter.setStartDate(null);
        }
        ControlDecoration decoration = this.fStartDateWidget.getDecoration();
        if (valid && this.fAbsencesFilter.isValid()) {
            decoration.hide();
        } else {
            decoration.show();
        }
        this.fAbsencesViewer.refresh(false);
    }

    private void hookGlobalActions() {
        IActionBars bars = this.getFormPage().getEditorSite().getActionBars();
        bars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)new Action(Messages.ContributorAbsencesFormPart_SELECT_ALL_GLOBAL_ACTION_LABEL){

            public void run() {
                ContributorAbsencesFormPart.this.selectAll();
            }
        });
        bars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)new Action(Messages.ContributorAbsencesFormPart_REMOVE_GLOBAL_ACTION_LABEL){

            public void run() {
                ContributorAbsencesFormPart.this.removeSelection((IStructuredSelection)ContributorAbsencesFormPart.this.fAbsencesViewer.getSelection());
            }
        });
        this.fAbsencesViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\u007f' && event.stateMask == 0) {
                    ContributorAbsencesFormPart.this.removeSelection((IStructuredSelection)ContributorAbsencesFormPart.this.fAbsencesViewer.getSelection());
                }
            }
        });
    }

    private void removeSelection(IStructuredSelection selection) {
        Assert.isNotNull((Object)selection);
        ItemHashSet absences = new ItemHashSet((ItemCollection)this.fAbsencesViewer.getInput());
        absences.removeAll((ItemCollection)new ItemArrayList((Collection)selection.toList()));
        this.fAbsencesViewer.setInput((Object)absences);
        this.getFormPage().setDirty(true);
    }

    public synchronized boolean save(IProgressMonitor monitor) {
        block14: {
            FormEditor editor;
            AbstractContributorResourceInput input = this.getInput();
            if (input != null && (editor = this.getFormPage().getEditor()) instanceof ContributorEditor) {
                final ContributorEditor extended = (ContributorEditor)editor;
                final Control control = this.fAbsencesViewer.getControl();
                Display display = control.getDisplay();
                try {
                    MultiStatus status;
                    IContributorAbsence[] absences = (IContributorAbsence[])input.getAbsences(monitor).getElements();
                    ItemCollection workingCopies = (ItemCollection)this.fAbsencesViewer.getInput();
                    ItemHashSet predecessors = new ItemHashSet((Collection)Arrays.asList(absences));
                    ItemArrayList successors = new ItemArrayList(workingCopies.size());
                    ArrayList<Object> collection = new ArrayList<Object>(workingCopies.size());
                    ArrayList<IContributorAbsence> toSave = new ArrayList<IContributorAbsence>(workingCopies.size());
                    for (IContributorAbsence workingCopy : workingCopies) {
                        if (workingCopy.isNewItem() || workingCopy.isWorkingCopy()) {
                            toSave.add(workingCopy);
                        } else {
                            successors.add((Object)workingCopy);
                        }
                        predecessors.remove((Object)workingCopy);
                    }
                    try {
                        status = input.saveAbsences(toSave.toArray(new IContributorAbsence[toSave.size()]), monitor);
                        if (!status.isOK()) {
                            collection.add(status);
                        } else {
                            successors.addAll((Collection)Arrays.asList((IContributorAbsence[])status.getElements()));
                        }
                    }
                    catch (TeamRepositoryException exception) {
                        collection.add(new Status(4, PlanningUIPlugin.getPluginId(), Messages.ContributorAbsencesFormPart_EXCEPTION_SAVING_ABSENCES, (Throwable)exception));
                    }
                    try {
                        status = input.deleteAbsences((IContributorAbsenceHandle[])predecessors.toArray((Object[])new IContributorAbsence[predecessors.size()]), monitor);
                        if (!status.isOK()) {
                            collection.add(status);
                        }
                    }
                    catch (TeamRepositoryException exception) {
                        collection.add(new Status(4, PlanningUIPlugin.getPluginId(), Messages.ContributorAbsencesFormPart_EXCEPTION_DELETING_ABSENCES, (Throwable)exception));
                    }
                    status = new MultiStatus(PlanningUIPlugin.getPluginId(), 0, collection.toArray(new IStatus[collection.size()]), Messages.ContributorAbsencesFormPart_CANNOT_SAVE_ABSENCES, null);
                    if (!display.isDisposed()) {
                        display.asyncExec(new Runnable((ItemCollection)successors){
                            private final /* synthetic */ ItemCollection val$successors;
                            {
                                this.val$successors = itemCollection;
                            }

                            public void run() {
                                if (!control.isDisposed()) {
                                    if (!status.isOK()) {
                                        extended.setStatus(Messages.ContributorAbsencesFormPart_SAVE_PROBLEM, (IStatus)status);
                                    } else {
                                        try {
                                            extended.setStatus(null, null);
                                            control.setRedraw(false);
                                            ContributorAbsencesFormPart.this.fAbsencesViewer.setInput((Object)this.val$successors);
                                        }
                                        finally {
                                            control.setRedraw(true);
                                        }
                                    }
                                }
                            }
                        });
                    }
                    return !status.matches(4);
                }
                catch (TeamRepositoryException teamRepositoryException) {
                    if (display.isDisposed()) break block14;
                    display.asyncExec(new Runnable(){

                        public void run() {
                            if (!control.isDisposed()) {
                                extended.setStatus(Messages.ContributorAbsencesFormPart_SAVE_PROBLEM, (IStatus)new Status(4, PlanningUIPlugin.getPluginId(), Messages.ContributorAbsencesFormPart_EXCEPTION_FETCHING_ABSENCES));
                            }
                        }
                    });
                }
            }
        }
        return false;
    }

    private void selectAll() {
        ItemCollection absences = (ItemCollection)this.fAbsencesViewer.getInput();
        this.fAbsencesViewer.setSelection((ISelection)new StructuredSelection(absences.toArray()), true);
        this.fAbsencesViewer.getTable().setFocus();
    }

    public synchronized void setInput(Object object) {
        AbstractContributorResourceInput predecessor = this.getInput();
        if (predecessor == object) {
            return;
        }
        super.setInput(object);
        final AbstractContributorResourceInput input = this.getInput();
        final Control control = this.fAbsencesViewer.getControl();
        final Display display = control.getDisplay();
        FoundationJob job = new FoundationJob(Messages.ContributorAbsencesFormPart_FETCHING_ABSENCES_JOB_NAME){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus runProtected(IProgressMonitor monitor) {
                block14: {
                    Assert.isNotNull((Object)monitor);
                    21 var2_2 = this;
                    synchronized (var2_2) {
                        ContributorAbsencesFormPart.this.fMonitor = monitor;
                    }
                    try {
                        boolean permissions;
                        OperationStatus<IContributorAbsence> status;
                        monitor.beginTask(Messages.ContributorAbsencesFormPart_FETCHING_ABSENCES_TASK_NAME, 200);
                        21 var4_6 = this;
                        synchronized (var4_6) {
                            if (input != null) {
                                status = input.getAbsences((IProgressMonitor)new SubProgressMonitor(monitor, 100));
                                permissions = input.checkWritePermissions((IProgressMonitor)new SubProgressMonitor(monitor, 100));
                            } else {
                                status = null;
                                permissions = true;
                            }
                        }
                        if (!display.isDisposed()) {
                            display.asyncExec(new Runnable(){

                                public void run() {
                                    if (!control.isDisposed()) {
                                        AbstractContributorResourceFormPage page = ContributorAbsencesFormPart.this.getFormPage();
                                        if (status != null) {
                                            if (!permissions) {
                                                page.setPermanentMessage(Messages.ContributorAbsencesFormPart_NO_PERMISSION_HINT, 1);
                                            }
                                            Collection elements = Arrays.asList((IContributorAbsence[])status.getElements());
                                            ContributorAbsencesFormPart.this.fAbsencesViewer.setInput((Object)new ItemHashSet(elements));
                                            ContributorAbsencesFormPart.this.fAddButton.setEnabled(true);
                                            ContributorAbsencesFormPart.this.fSelectAllButton.setEnabled(!elements.isEmpty());
                                        } else {
                                            ContributorAbsencesFormPart.this.fAddButton.setEnabled(false);
                                            ContributorAbsencesFormPart.this.fSelectAllButton.setEnabled(false);
                                        }
                                        ContributorAbsencesFormPart.this.fEditButton.setEnabled(false);
                                        ContributorAbsencesFormPart.this.fRemoveButton.setEnabled(false);
                                        ContributorAbsencesFormPart.this.fDeselectAllButton.setEnabled(false);
                                        page.getManagedForm().getForm().layout(true, true);
                                    }
                                }
                            });
                        }
                    }
                    catch (TeamRepositoryException exception) {
                        if (display.isDisposed()) break block14;
                        display.asyncExec(new Runnable(){

                            public void run() {
                                FormEditor editor;
                                AbstractContributorResourceFormPage page;
                                if (!control.isDisposed() && (page = ContributorAbsencesFormPart.this.getFormPage()) != null && (editor = page.getEditor()) instanceof ContributorEditor) {
                                    ContributorEditor extended = (ContributorEditor)editor;
                                    extended.setStatus(Messages.ContributorAbsencesFormPart_LOAD_PROBLEM, (IStatus)new Status(4, PlanningUIPlugin.getPluginId(), exception.getLocalizedMessage()));
                                }
                            }
                        });
                    }
                }
                21 var2_5 = this;
                synchronized (var2_5) {
                    ContributorAbsencesFormPart.this.fMonitor = null;
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(30);
        job.setSystem(true);
        job.schedule();
    }

    public boolean stretchHorizontally() {
        return true;
    }

    public boolean stretchVertically() {
        return true;
    }

    private final class ContributorAbsencesContentProvider
    implements IStructuredContentProvider {
        private ContributorAbsencesContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object element) {
            if (element instanceof ItemCollection) {
                ItemCollection collection = (ItemCollection)element;
                return collection.toArray();
            }
            return new Object[0];
        }

        public void inputChanged(Viewer viewer, Object predecessor, Object successor) {
        }
    }

    private final class ContributorAbsencesDateFilter
    extends ViewerFilter {
        private Date fEndDate;
        private Date fStartDate = ContributorAbsencesFormPart.access$0(new Date(System.currentTimeMillis()));

        public Date getEndDate() {
            return this.fEndDate;
        }

        public Date getStartDate() {
            return this.fStartDate;
        }

        public boolean isValid() {
            if (this.fStartDate == null) {
                return true;
            }
            if (this.fEndDate == null) {
                return true;
            }
            return !this.fStartDate.after(this.fEndDate);
        }

        public boolean select(Viewer viewer, Object parent, Object element) {
            if (element instanceof IContributorAbsence) {
                IContributorAbsence absence = (IContributorAbsence)element;
                if (this.fStartDate != null && absence.getEndDate().before(this.fStartDate)) {
                    return false;
                }
                return this.fEndDate == null || !absence.getStartDate().after(this.fEndDate);
            }
            return false;
        }

        public void setEndDate(Date date) {
            this.fEndDate = date;
        }

        public void setStartDate(Date date) {
            this.fStartDate = date;
        }
    }

    private final class ContributorAbsencesLabelProvider
    extends CellLabelProvider {
        private ContributorAbsencesLabelProvider() {
        }

        public void update(ViewerCell cell) {
            Assert.isNotNull((Object)cell);
            IContributorAbsence absence = (IContributorAbsence)cell.getElement();
            int index = cell.getColumnIndex();
            if (index == 0) {
                cell.setImage(ContributorAbsencesFormPart.this.fResourceManager.createImage(ImagePool.DATE));
                cell.setText(absence.getSummary());
            } else if (index == 1) {
                Date startDate = absence.getStartDate();
                Date endDate = absence.getEndDate();
                if (ContributorAbsencesFormPart.coversSingleDay(absence)) {
                    cell.setText(ContributorAbsencesFormPart.this.fDateFormat.format(startDate));
                } else {
                    cell.setText(MessageFormat.format(Messages.ContributorAbsencesFormPart_START_END_DATE_PATTERN, ContributorAbsencesFormPart.this.fDateFormat.format(startDate), ContributorAbsencesFormPart.this.fDateFormat.format(endDate)));
                }
            }
        }
    }

    private final class ContributorAbsencesViewerComparator
    extends ViewerComparator {
        private ContributorAbsencesViewerComparator() {
        }

        public int compare(Viewer viewer, Object first, Object second) {
            TableViewer extended = (TableViewer)viewer;
            IContributorAbsence firstAbsence = (IContributorAbsence)first;
            IContributorAbsence secondAbsence = (IContributorAbsence)second;
            Table table = extended.getTable();
            TableColumn column = table.getSortColumn();
            boolean up = table.getSortDirection() == 128;
            int result = 0;
            if (column == ContributorAbsencesFormPart.this.fSummaryColumn) {
                result = Collator.getInstance().compare(firstAbsence.getSummary(), secondAbsence.getSummary());
            } else {
                Date secondStart;
                Date firstStart = firstAbsence.getStartDate();
                if (firstStart.before(secondStart = secondAbsence.getStartDate())) {
                    result = -1;
                } else if (firstStart.after(secondStart)) {
                    result = 1;
                } else {
                    Date secondEnd;
                    Date firstEnd = firstAbsence.getEndDate();
                    if (firstEnd.before(secondEnd = secondAbsence.getEndDate())) {
                        result = -1;
                    } else if (firstEnd.after(secondEnd)) {
                        result = 1;
                    }
                }
                if (result == 0) {
                    result = Collator.getInstance().compare(firstAbsence.getSummary(), secondAbsence.getSummary());
                }
            }
            if (result != 0) {
                return up ? result : -1 * result;
            }
            return 0;
        }
    }
}

