/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.quickquery.workitem;

import com.ibm.team.apt.ide.ui.quickquery.IQuickQueryAttribute;
import com.ibm.team.apt.ide.ui.quickquery.IQuickQueryAttributeFactory;
import com.ibm.team.apt.ide.ui.quickquery.IQuickQueryContext;
import com.ibm.team.apt.internal.common.util.ItemHashMap;
import com.ibm.team.apt.internal.common.util.ItemMap;
import com.ibm.team.apt.internal.ide.ui.quickquery.workitem.CategoryAttribute;
import com.ibm.team.apt.internal.ide.ui.quickquery.workitem.DescriptionAttribute;
import com.ibm.team.apt.internal.ide.ui.quickquery.workitem.EstimateAttribute;
import com.ibm.team.apt.internal.ide.ui.quickquery.workitem.PriorityAttribute;
import com.ibm.team.apt.internal.ide.ui.quickquery.workitem.SeverityAttribute;
import com.ibm.team.apt.internal.ide.ui.quickquery.workitem.StateAttribute;
import com.ibm.team.apt.internal.ide.ui.quickquery.workitem.SummaryAttribute;
import com.ibm.team.apt.internal.ide.ui.quickquery.workitem.TagsAttribute;
import com.ibm.team.apt.internal.ide.ui.quickquery.workitem.TypeAttribute;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkItemAttributeFactory
implements IQuickQueryAttributeFactory {
    private ItemMap<IProjectAreaHandle, Map<String, IQuickQueryAttribute>> fAttributes = new ItemHashMap();

    @Override
    public IQuickQueryAttribute findAttribute(IQuickQueryContext context, String keyword) throws TeamRepositoryException {
        this.initialize(context);
        return (IQuickQueryAttribute)((Map)this.fAttributes.get((IItemHandle)context.getProjectArea())).get(keyword);
    }

    public List<IQuickQueryAttribute> findAllAttributes(IQuickQueryContext context) throws TeamRepositoryException {
        this.initialize(context);
        return new ArrayList<IQuickQueryAttribute>(((Map)this.fAttributes.get((IItemHandle)context.getProjectArea())).values());
    }

    private synchronized void initialize(IQuickQueryContext context) {
        if (!this.fAttributes.containsKey((IItemHandle)context.getProjectArea())) {
            HashMap<String, IQuickQueryAttribute> attributes = new HashMap<String, IQuickQueryAttribute>();
            for (IQuickQueryAttribute attribute : this.createContextInsensitiveAttributes()) {
                attributes.put(attribute.getKeyword(), attribute);
            }
            for (IQuickQueryAttribute attribute : this.createContextSensitiveAttributes(context)) {
                attributes.put(attribute.getKeyword(), attribute);
            }
            this.fAttributes.put((IItemHandle)context.getProjectArea(), attributes);
        }
    }

    private List<IQuickQueryAttribute> createContextInsensitiveAttributes() {
        ArrayList<IQuickQueryAttribute> result = new ArrayList<IQuickQueryAttribute>();
        return result;
    }

    private List<IQuickQueryAttribute> createContextSensitiveAttributes(IQuickQueryContext context) {
        ArrayList<IQuickQueryAttribute> result = new ArrayList<IQuickQueryAttribute>();
        result.add(new PriorityAttribute(context));
        result.add(new SeverityAttribute(context));
        result.add(new CategoryAttribute(context));
        result.add(new DescriptionAttribute(context));
        result.add(new StateAttribute(context));
        result.add(new EstimateAttribute(context));
        result.add(new SummaryAttribute(context));
        result.add(new TagsAttribute(context));
        result.add(new TypeAttribute(context));
        return result;
    }
}

