/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.quickquery.workitem;

import com.ibm.team.apt.ide.ui.quickquery.IQuickQueryContext;
import com.ibm.team.apt.ide.ui.quickquery.IQuickQueryParameter;
import com.ibm.team.apt.ide.ui.quickquery.QuickQueryOperator;
import com.ibm.team.apt.internal.ide.ui.quickquery.AbstractQuickQueryAttribute;
import com.ibm.team.apt.internal.ide.ui.quickquery.SimpleQuickQueryParameter;
import com.ibm.team.apt.internal.ide.ui.quickquery.workitem.Messages;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.expression.VariableAttributeExpression;
import com.ibm.team.workitem.common.expression.variables.IAttributeVariable;
import com.ibm.team.workitem.common.expression.variables.StatusVariable;
import com.ibm.team.workitem.common.model.AttributeOperation;
import com.ibm.team.workitem.common.model.IWorkItem;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateAttribute
extends AbstractQuickQueryAttribute {
    private static final StateGroupDetail[] STATE_GROUP_DETAILS = new StateGroupDetail[]{new StateGroupDetail("open", Messages.StateAttribute_STATE_OPEN, 1), new StateGroupDetail("complete", Messages.StateAttribute_STATE_COMPLETED, 2), new StateGroupDetail("incomplete", Messages.StateAttribute_STATE_IN_PROGRESS, 5)};

    public StateAttribute(IQuickQueryContext context) {
        super("state", Messages.StateAttribute_DESCRIPTION, context);
    }

    @Override
    public Collection<IQuickQueryParameter> getParameterProposals(boolean importantOnly, QuickQueryOperator operator, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IQuickQueryParameter> result = new ArrayList<IQuickQueryParameter>(STATE_GROUP_DETAILS.length);
        StateGroupDetail[] stateGroupDetailArray = STATE_GROUP_DETAILS;
        int n = STATE_GROUP_DETAILS.length;
        int n2 = 0;
        while (n2 < n) {
            StateGroupDetail quickQueryParameter = stateGroupDetailArray[n2];
            result.add(quickQueryParameter);
            ++n2;
        }
        return result;
    }

    @Override
    public Expression buildExpression(QuickQueryOperator operator, String parameter, IProgressMonitor monitor) throws TeamRepositoryException {
        StateGroupDetail[] stateGroupDetailArray = STATE_GROUP_DETAILS;
        int n = STATE_GROUP_DETAILS.length;
        int n2 = 0;
        while (n2 < n) {
            StateGroupDetail stateGroupDetail = stateGroupDetailArray[n2];
            if (parameter != null && parameter.equalsIgnoreCase(stateGroupDetail.getKeyword())) {
                IQueryableAttribute statusAttribute = this.findWorkItemQueryableAttribute(IWorkItem.STATE_PROPERTY, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                return new VariableAttributeExpression(statusAttribute, AttributeOperation.EQUALS, (IAttributeVariable)new StatusVariable(stateGroupDetail.fStateGroupId));
            }
            ++n2;
        }
        return null;
    }

    private static class StateGroupDetail
    extends SimpleQuickQueryParameter {
        public final int fStateGroupId;

        public StateGroupDetail(String keyword, String descriptionArg, int stateGroupId) {
            super(keyword, MessageFormat.format(Messages.StateAttribute_DESCRIPTION_PROPOSAL, descriptionArg));
            this.fStateGroupId = stateGroupId;
        }
    }
}

