/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.quickquery.workitem;

import com.ibm.icu.text.Collator;
import com.ibm.team.apt.ide.ui.quickquery.IQuickQueryContext;
import com.ibm.team.apt.ide.ui.quickquery.IQuickQueryParameter;
import com.ibm.team.apt.ide.ui.quickquery.QuickQueryOperator;
import com.ibm.team.apt.internal.ide.ui.quickquery.AbstractQuickQueryAttribute;
import com.ibm.team.apt.internal.ide.ui.quickquery.SimpleQuickQueryParameter;
import com.ibm.team.apt.internal.ide.ui.quickquery.workitem.Messages;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.internal.AuditableClient;
import com.ibm.team.workitem.common.expression.AttributeExpression;
import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.model.AttributeOperation;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OwnerAttribute
extends AbstractQuickQueryAttribute {
    public OwnerAttribute(IQuickQueryContext context) {
        super("owner", Messages.OwnerAttribute_DESCRIPTION, context);
    }

    @Override
    public Collection<IQuickQueryParameter> getParameterProposals(boolean importantOnly, QuickQueryOperator operator, IProgressMonitor monitor) throws TeamRepositoryException {
        List<IContributor> cachedContributors = this.getContributors();
        Collections.sort(cachedContributors, new Comparator<IContributor>(){

            @Override
            public int compare(IContributor o1, IContributor o2) {
                return Collator.getInstance().compare(o1.getName(), o2.getName());
            }
        });
        ArrayList<IQuickQueryParameter> result = new ArrayList<IQuickQueryParameter>(cachedContributors.size());
        for (IContributor contributor : cachedContributors) {
            String label = contributor.getName();
            String description = MessageFormat.format(Messages.OwnerAttribute_DESCRIPTION_PROPOSAL, label);
            result.add(new SimpleQuickQueryParameter(label, description));
        }
        return result;
    }

    @Override
    public Expression buildExpression(QuickQueryOperator operator, String parameter, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask(Messages.OwnerAttribute_MONITOR_BUILD_EXPRESSION, 2);
        try {
            IQueryableAttribute ownerAttribute = this.findWorkItemQueryableAttribute(IWorkItem.OWNER_PROPERTY, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            List<IContributor> cachedContributors = this.getContributors();
            for (IContributor contributor : cachedContributors) {
                if (!contributor.getName().equalsIgnoreCase(parameter) && !contributor.getUserId().equalsIgnoreCase(parameter)) continue;
                AttributeExpression attributeExpression = new AttributeExpression(ownerAttribute, AttributeOperation.EQUALS, (Object)contributor);
                return attributeExpression;
            }
            return null;
        }
        finally {
            monitor.done();
        }
    }

    private List<IContributor> getContributors() {
        AuditableClient auditableClient = (AuditableClient)this.getAuditableClient();
        List cachedContributors = auditableClient.findAllCachedAuditables(ItemProfile.CONTRIBUTOR_DEFAULT);
        return cachedContributors;
    }
}

