/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.quickquery;

import com.ibm.team.apt.ide.ui.quickquery.QuickQueryOperator;
import com.ibm.team.apt.internal.ide.ui.quickquery.IParsedQuickQueryElement;
import com.ibm.team.apt.internal.ide.ui.quickquery.Messages;
import com.ibm.team.apt.internal.ide.ui.quickquery.ParseError;
import com.ibm.team.apt.internal.ide.ui.quickquery.ParsedAttributePredicate;
import com.ibm.team.apt.internal.ide.ui.quickquery.ParsedKeywordPredicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuickQueryParser
implements Iterable<IParsedQuickQueryElement> {
    private static final Pattern IDENTIFIER = Pattern.compile("[a-zA-Z_][\\w]*");
    private final String fQuickFilterText;
    private final List<IParsedQuickQueryElement> fParsedQuickFilter;

    public QuickQueryParser(String quickFilterText) {
        this.fQuickFilterText = quickFilterText;
        this.fParsedQuickFilter = Collections.unmodifiableList(this.doParse(this.fQuickFilterText));
    }

    public String getInput() {
        return this.fQuickFilterText;
    }

    @Override
    public Iterator<IParsedQuickQueryElement> iterator() {
        return this.fParsedQuickFilter.iterator();
    }

    private List<IParsedQuickQueryElement> doParse(CharSequence input) {
        ArrayList<IParsedQuickQueryElement> result = new ArrayList<IParsedQuickQueryElement>();
        CharSequenceIterator chars = new CharSequenceIterator(input);
        boolean negate = false;
        int posElementStart = -1;
        int maxLoops = input.length();
        while (chars.hasNext()) {
            char c;
            if (maxLoops-- == 0) break;
            if (this.skipWhitespace(chars)) continue;
            if (posElementStart == -1) {
                posElementStart = chars.getIndex();
            }
            if ((c = chars.next()) == '-' || c == '+') {
                negate = c == '-';
                continue;
            }
            chars.pushback();
            boolean foundOperation = false;
            int posOperationNameStart = chars.getIndex();
            String keyword = this.parseWord(chars);
            if (keyword != null && IDENTIFIER.matcher(keyword).matches() && chars.hasNext()) {
                int posOperationNameEnd = chars.getIndex();
                QuickQueryOperator operator = null;
                char operatorChar = chars.next();
                QuickQueryOperator[] quickQueryOperatorArray = QuickQueryOperator.values();
                int n = quickQueryOperatorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    QuickQueryOperator candidateOperator = quickQueryOperatorArray[n2];
                    if (candidateOperator.getToken().charAt(0) == operatorChar) {
                        operator = candidateOperator;
                        break;
                    }
                    ++n2;
                }
                if (operator != null) {
                    int posAfterColon = chars.getIndex();
                    String parameter = this.parseString(chars);
                    if (parameter == null) {
                        chars.reset(posAfterColon);
                        parameter = this.parseParameter(chars);
                        if (parameter == null) {
                            result.add(new ParseError(Messages.QuickQueryParser_FAILURE_PARAMETER_EXPECTED, input, posAfterColon, chars.getIndex()));
                        }
                    }
                    int posAfterParameter = chars.getIndex();
                    result.add(new ParsedAttributePredicate(keyword, operator, parameter, negate, posOperationNameStart, posOperationNameEnd, posAfterColon, posAfterParameter, input, posElementStart, chars.getIndex()));
                    foundOperation = true;
                } else {
                    chars.pushback();
                }
            } else if (keyword == null) {
                chars.reset(posElementStart);
                keyword = this.parseString(chars);
            }
            if (!foundOperation) {
                if (keyword != null) {
                    result.add(new ParsedKeywordPredicate(keyword, negate, input, posElementStart, chars.getIndex()));
                } else if (chars.hasNext()) {
                    chars.next();
                    result.add(new ParseError(Messages.QuickQueryParser_FAILURE_INVALID_INPUT, input, posElementStart, chars.getIndex()));
                }
            }
            negate = false;
            posElementStart = -1;
        }
        return result;
    }

    private boolean skipWhitespace(CharSequenceIterator chars) {
        boolean result = false;
        while (chars.hasNext()) {
            if (!Character.isWhitespace(chars.next())) {
                chars.pushback();
                break;
            }
            result = true;
        }
        return result;
    }

    private String parseWord(CharSequenceIterator chars) {
        int start = chars.getIndex();
        while (chars.hasNext()) {
            char c = chars.next();
            if (Character.isLetterOrDigit(c)) continue;
            chars.pushback();
            break;
        }
        return start != chars.getIndex() ? chars.substring(start) : null;
    }

    private String parseParameter(CharSequenceIterator chars) {
        int start = chars.getIndex();
        while (chars.hasNext()) {
            char c = chars.next();
            if (!Character.isWhitespace(c)) continue;
            chars.pushback();
            break;
        }
        return start != chars.getIndex() ? chars.substring(start) : null;
    }

    private String parseString(CharSequenceIterator chars) {
        if (!chars.hasNext()) {
            return null;
        }
        char c = chars.next();
        if (c != '\"') {
            chars.pushback();
            return null;
        }
        StringBuilder result = new StringBuilder();
        boolean foundEnd = false;
        while (chars.hasNext()) {
            c = chars.next();
            if (c == '\"') {
                foundEnd = true;
                break;
            }
            if (c == '\\') {
                if (!chars.hasNext()) {
                    return null;
                }
                switch (chars.next()) {
                    case '\\': {
                        result.append('\\');
                        break;
                    }
                    case '\"': {
                        result.append('\"');
                        break;
                    }
                    case '\'': {
                        result.append('\'');
                        break;
                    }
                    case 'r': {
                        result.append('\r');
                        break;
                    }
                    case 'n': {
                        result.append('\n');
                        break;
                    }
                    case 't': {
                        result.append('\t');
                    }
                }
                continue;
            }
            result.append(c);
        }
        return foundEnd ? result.toString() : null;
    }

    private class CharSequenceIterator {
        private final CharSequence fInput;
        private final int fLength;
        private int fIndex;

        CharSequenceIterator(CharSequence input) {
            this.fInput = input;
            this.fLength = input.length();
        }

        public String subString(int start, int end) {
            return this.fInput.subSequence(start, end).toString();
        }

        public String substring(int start) {
            return this.fInput.subSequence(start, this.fIndex).toString();
        }

        public int getIndex() {
            return this.fIndex;
        }

        public boolean hasNext() {
            return this.fIndex < this.fLength;
        }

        public char next() {
            if (this.fIndex >= this.fLength) {
                throw new StringIndexOutOfBoundsException();
            }
            return this.fInput.charAt(this.fIndex++);
        }

        public void pushback() {
            if (this.fIndex == 0) {
                throw new StringIndexOutOfBoundsException();
            }
            --this.fIndex;
        }

        public void reset(int position) {
            if (position < 0 || position > this.fLength) {
                throw new StringIndexOutOfBoundsException();
            }
            this.fIndex = position;
        }
    }
}

