/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.quickquery;

import com.ibm.team.apt.ide.ui.quickquery.IQuickQueryContext;
import com.ibm.team.apt.ide.ui.quickquery.IQuickQueryParameter;
import com.ibm.team.apt.ide.ui.quickquery.QuickQueryOperator;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.common.util.ItemCollection;
import com.ibm.team.apt.internal.common.util.IterationHierarchy;
import com.ibm.team.apt.internal.ide.ui.quickquery.AbstractQuickQueryAttribute;
import com.ibm.team.apt.internal.ide.ui.quickquery.Messages;
import com.ibm.team.apt.internal.ide.ui.quickquery.SimpleQuickQueryParameter;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.expression.AttributeExpression;
import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.expression.Term;
import com.ibm.team.workitem.common.model.AttributeOperation;
import com.ibm.team.workitem.common.model.IWorkItem;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanAwareDevLineAttribute
extends AbstractQuickQueryAttribute {
    public PlanAwareDevLineAttribute(IQuickQueryContext context) {
        super("devline", Messages.PlanAwareDevLineAttribute_DESCRIPTION, context);
    }

    @Override
    public Collection<IQuickQueryParameter> getParameterProposals(boolean importantOnly, QuickQueryOperator operator, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IQuickQueryParameter> result = new ArrayList<IQuickQueryParameter>();
        for (IDevelopmentLine devLine : this.getDevelopmentLines()) {
            result.add(new SimpleQuickQueryParameter(devLine.getLabel(), MessageFormat.format(Messages.PlanAwareDevLineAttribute_DESCRIPTION_PROPOSAL, devLine.getLabel())));
        }
        return result;
    }

    @Override
    public Expression buildExpression(QuickQueryOperator operator, String parameter, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask(Messages.PlanAwareDevLineAttribute_MONITOR_BUILD_EXPRESSION, 2);
        try {
            IQueryableAttribute targetAttribute = this.findWorkItemQueryableAttribute(IWorkItem.TARGET_PROPERTY, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            for (IDevelopmentLine devLine : this.getDevelopmentLines()) {
                if (!devLine.getLabel().equalsIgnoreCase(parameter)) continue;
                Term orExpression = new Term(Term.Operator.OR);
                for (IIteration iteration : this.getIterations((IDevelopmentLineHandle)devLine)) {
                    orExpression.add((Expression)new AttributeExpression(targetAttribute, AttributeOperation.EQUALS, (Object)iteration));
                }
                Term term = orExpression;
                return term;
            }
            return null;
        }
        finally {
            monitor.done();
        }
    }

    private ItemCollection<IDevelopmentLine> getDevelopmentLines() throws TeamRepositoryException {
        return this.getPlanContext().getDevelopmentLines();
    }

    private ItemCollection<IIteration> getIterations(IDevelopmentLineHandle devLine) throws TeamRepositoryException {
        IterationHierarchy hierarchy = this.getPlanContext().getDevelopmentLineIterationHierarchy(devLine);
        return hierarchy.getAllIterations();
    }

    private ResolvedPlan getPlanContext() {
        ResolvedPlan result = (ResolvedPlan)this.getContext().getAdapter(ResolvedPlan.class);
        if (result == null) {
            throw new IllegalArgumentException("IQuickQueryContext not compatible with PlanAwareDevLineAttribute");
        }
        return result;
    }
}

