/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.quickquery;

import com.ibm.team.apt.ide.ui.quickquery.IQuickQueryAttribute;
import com.ibm.team.apt.ide.ui.quickquery.IQuickQueryContext;
import com.ibm.team.apt.ide.ui.quickquery.QuickQueryOperator;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.ide.ui.ImagePool;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.expression.IQueryableAttributeFactory;
import com.ibm.team.workitem.common.expression.QueryableAttributes;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IAttributeHandle;
import com.ibm.team.workitem.common.model.IEnumeration;
import com.ibm.team.workitem.common.model.ILiteral;
import com.ibm.team.workitem.common.model.IWorkItem;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractQuickQueryAttribute
implements IQuickQueryAttribute {
    private final String fKeyword;
    private final String fDescripton;
    private final ImageDescriptor fIcon;
    private final IQuickQueryContext fContext;
    private final Collection<QuickQueryOperator> fSupportedOperations;

    public AbstractQuickQueryAttribute(String keyword, String descripton, IQuickQueryContext context) {
        this(keyword, descripton, ImagePool.QUICKFILTER_ATTRIBUTE, (Collection<QuickQueryOperator>)Arrays.asList(QuickQueryOperator.DEFAULT), context);
    }

    public AbstractQuickQueryAttribute(String keyword, String descripton, Collection<QuickQueryOperator> supportedOperations, IQuickQueryContext context) {
        this(keyword, descripton, ImagePool.QUICKFILTER_ATTRIBUTE, supportedOperations, context);
    }

    public AbstractQuickQueryAttribute(String keyword, String descripton, ImageDescriptor icon, IQuickQueryContext context) {
        this(keyword, descripton, icon, (Collection<QuickQueryOperator>)Arrays.asList(QuickQueryOperator.DEFAULT), context);
    }

    public AbstractQuickQueryAttribute(String keyword, String descripton, ImageDescriptor icon, Collection<QuickQueryOperator> supportedOperations, IQuickQueryContext context) {
        this.fKeyword = keyword;
        this.fDescripton = descripton;
        this.fIcon = icon;
        this.fSupportedOperations = supportedOperations;
        this.fContext = context;
    }

    @Override
    public IQuickQueryAttribute.Mode getAttributeCombination() {
        return IQuickQueryAttribute.Mode.Or;
    }

    @Override
    public String getKeyword() {
        return this.fKeyword;
    }

    @Override
    public String getDescription() {
        return this.fDescripton;
    }

    @Override
    public ImageDescriptor getIcon() {
        return this.fIcon;
    }

    @Override
    public Collection<QuickQueryOperator> getSupportedOperations() {
        return this.fSupportedOperations;
    }

    protected IQuickQueryContext getContext() {
        return this.fContext;
    }

    protected IQueryableAttribute findWorkItemQueryableAttribute(String attributeIdentifier, IProgressMonitor monitor) throws TeamRepositoryException {
        IQueryableAttributeFactory factory = QueryableAttributes.getFactory((IItemType)IWorkItem.ITEM_TYPE);
        return factory.findAttribute(this.fContext.getProjectArea(), attributeIdentifier, (IAuditableCommon)this.getAuditableClient(), monitor);
    }

    protected <T extends ILiteral> List<T> getValues(IAttribute attribute, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkItemClient workItemClient = this.getWorkItemClient();
        IEnumeration values = workItemClient.resolveEnumeration((IAttributeHandle)attribute, monitor);
        return values != null ? values.getEnumerationLiterals() : null;
    }

    protected IAuditableClient getAuditableClient() {
        return PlanningClientPlugin.getAuditableClient((IItemHandle)this.fContext.getProjectArea());
    }

    protected IWorkItemClient getWorkItemClient() {
        return PlanningClientPlugin.getWorkItemClient((IItemHandle)this.fContext.getProjectArea());
    }
}

