/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.preview;

import com.ibm.team.apt.internal.common.ProgressInformation;
import com.ibm.team.apt.internal.common.ProgressItem;
import com.ibm.team.apt.internal.common.duration.TimeUnit;
import com.ibm.team.apt.internal.ide.ui.preview.Messages;
import com.ibm.team.apt.internal.ide.ui.util.Html;
import com.ibm.team.jface.itemview.MarkupUtil;
import com.ibm.team.jface.preview.DomainAdapter;
import com.ibm.team.jface.preview.IDomainAdapter;
import com.ibm.team.repository.common.util.NLS;
import java.util.HashMap;

public class ProgressItemDomainAdapter
extends DomainAdapter {
    private static final String GENERAL_CSS = "GENERAL_CSS";

    protected Object convertToDomainObject(Object object) {
        if (object instanceof ProgressItem) {
            return object;
        }
        return null;
    }

    public String generateJobInfo(Object input, IDomainAdapter.Info info) {
        return Messages.ProgressItemDomainAdapter_JOB_INFO;
    }

    protected void generateHead(HashMap map) {
        if (map.containsKey(GENERAL_CSS)) {
            return;
        }
        String font = MarkupUtil.getFont();
        StringBuilder css = new StringBuilder();
        css.append("<style type=\"text/css\">");
        css.append("body { overflow: auto; }\n");
        css.append("table{ ").append(font).append(" }");
        css.append("a:link { text-decoration: none; }");
        css.append("a:visited { color:#0000FF; text-decoration: none; }");
        css.append("a:hover { text-decoration: underline; }");
        css.append("</style>");
        map.put(GENERAL_CSS, css.toString());
    }

    public void generateContentAsHTML(HashMap head, StringBuffer body, Object input, IDomainAdapter.Info info) {
        if (!(input instanceof ProgressInformation)) {
            return;
        }
        Html.H5.open(body, new Html.Attribute("style", "margin-bottom: 0px;"));
        body.append(Messages.ProgressItemDomainAdapter_CONTENT_HEADER);
        Html.H5.close(body);
        ProgressItem item = ProgressItem.create((ProgressInformation)((ProgressInformation)input));
        ProgressItemDomainAdapter.appendProgressReport(body, item);
    }

    public static void appendProgressReport(StringBuffer body, ProgressItem item) {
        switch (item.getKind()) {
            case MESSAGE: 
            case LOADING: {
                body.append(item.getMessage().getMessage());
                break;
            }
            case DONE: {
                body.append(NLS.bind((String)Messages.ProgressItemDomainAdapter_CONTENT_ACTUAL_WORK, (Object[])new Object[]{item.getWorkHoursDone(TimeUnit.HOURS), item.getWorkHoursTotal(TimeUnit.HOURS)}));
                Html.BR.open(body, new Html.Attribute[0]);
                body.append(Messages.ProgressItemDomainAdapter_ITEMS_COMPLETED_ALL);
                Html.BR.open(body, new Html.Attribute[0]);
                break;
            }
            case BAR: {
                body.append(NLS.bind((String)Messages.ProgressItemDomainAdapter_CONTENT_ACTUAL_WORK, (Object[])new Object[]{item.getWorkHoursDone(TimeUnit.HOURS), item.getWorkHoursTotal(TimeUnit.HOURS)}));
                Html.BR.open(body, new Html.Attribute[0]);
                body.append(NLS.bind((String)Messages.ProgressItemDomainAdapter_CONTENT_QUALITY, (Object[])new Object[]{(int)item.getQualityOfPlanning()}));
                Html.BR.open(body, new Html.Attribute[0]);
                body.append(NLS.bind((String)Messages.ProgressItemDomainAdapter_CONTENT_OPEN_CLOSE, (Object[])new Object[]{item.getCloseCount(), item.getOpenCount() + item.getCloseCount(), (int)((float)item.getCloseCount() / (float)(item.getOpenCount() + item.getCloseCount()) * 100.0f)}));
                Html.BR.open(body, new Html.Attribute[0]);
                break;
            }
            case BAR_WITH_PROJECTION: {
                body.append(NLS.bind((String)Messages.ProgressItemDomainAdapter_CONTENT_ACTUAL_WORK, (Object[])new Object[]{item.getWorkHoursDone(TimeUnit.HOURS), item.getWorkHoursTotal(TimeUnit.HOURS)}));
                Html.BR.open(body, new Html.Attribute[0]);
                body.append(NLS.bind((String)Messages.ProgressItemDomainAdapter_CONTENT_EXPECTED_WORK, (Object[])new Object[]{item.getExpectedWorkHours(TimeUnit.HOURS), item.isAhead() ? Messages.ProgressItemDomainAdapter_CONTENT_AHEAD : Messages.ProgressItemDomainAdapter_CONTENT_BEHIND, Math.abs(item.getAheadTime(TimeUnit.HOURS))}));
                Html.BR.open(body, new Html.Attribute[0]);
                Html.BR.open(body, new Html.Attribute[0]);
                body.append(NLS.bind((String)Messages.ProgressItemDomainAdapter_CONTENT_QUALITY, (Object[])new Object[]{(int)item.getQualityOfPlanning()}));
                Html.BR.open(body, new Html.Attribute[0]);
                body.append(NLS.bind((String)Messages.ProgressItemDomainAdapter_CONTENT_OPEN_CLOSE, (Object[])new Object[]{item.getCloseCount(), item.getOpenCount() + item.getCloseCount(), (int)((float)item.getCloseCount() / (float)(item.getOpenCount() + item.getCloseCount()) * 100.0f)}));
                Html.BR.open(body, new Html.Attribute[0]);
            }
        }
    }
}

