/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.preview;

import com.ibm.team.apt.common.IIterationPlanRecord;
import com.ibm.team.apt.common.IIterationPlanRecordHandle;
import com.ibm.team.apt.internal.client.IIterationPlanClient;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.common.Iterations;
import com.ibm.team.apt.internal.common.ProgressInformation;
import com.ibm.team.apt.internal.common.ProgressItem;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.preview.AbstractPlanHTMLGenerator;
import com.ibm.team.apt.internal.ide.ui.preview.Messages;
import com.ibm.team.apt.internal.ide.ui.preview.ProgressItemDomainAdapter;
import com.ibm.team.apt.internal.ide.ui.util.BlockingItemResolver;
import com.ibm.team.apt.internal.ide.ui.util.Html;
import com.ibm.team.jface.preview.IDomainAdapter;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class PlanHTMLGenerator
extends AbstractPlanHTMLGenerator {
    private IIterationPlanRecordHandle fIterationPlan;

    public PlanHTMLGenerator(IIterationPlanRecordHandle iterationPlan) {
        this.fIterationPlan = iterationPlan;
    }

    public void generate(HashMap headDefinitions, StringBuffer targetBuffer, IDomainAdapter.Info info) {
        block13: {
            StringBuffer body = new StringBuffer();
            try {
                ProgressInformation information;
                BlockingItemResolver itemResolver = new BlockingItemResolver();
                IIterationPlanRecord iterationPlan = (IIterationPlanRecord)itemResolver.resolvePartial((IItemHandle)this.fIterationPlan, IIterationPlanRecord.FULL_PROFILE);
                this.fIterationPlan = iterationPlan;
                if (info.isEmbeddeble) {
                    URI uri = Location.itemLocation((IItemHandle)iterationPlan.getItemHandle(), null).toRelativeUri();
                    if (uri != null) {
                        Html.ANCHOR.open(body, new Html.Attribute("href", uri.toASCIIString()));
                        Html.append(body, iterationPlan.getName());
                        Html.ANCHOR.close(body);
                    }
                    break block13;
                }
                IIteration iteration = (IIteration)itemResolver.resolvePartial((IItemHandle)iterationPlan.getIteration(), Iterations.UI_PROFILE);
                IIterationPlanClient client = PlanningClientPlugin.getIterationPlanClient((IItemHandle)iterationPlan);
                try {
                    information = client.fetchPlanProgress2((IIterationPlanRecordHandle)iterationPlan, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (TeamRepositoryException e) {
                    throw new InvocationTargetException(e);
                }
                ProgressItem item = ProgressItem.create((ProgressInformation)information);
                Html.DIV.open(body, new Html.Attribute[0]);
                Html.H5.open(body, new Html.Attribute[0]);
                Html.append(body, NLS.bind((String)Messages.PlanHTMLGenerator_CONTENT_TITLE, (Object[])new Object[]{iterationPlan.getName(), iteration.getLabel()}));
                Html.H5.close(body);
                if (iteration.getStartDate() != null && iteration.getEndDate() != null) {
                    body.append(MessageFormat.format(Messages.PlanHTMLGenerator_CONTENT_DATES_BOTH, iteration.getStartDate(), iteration.getEndDate()));
                } else if (iteration.getStartDate() != null) {
                    body.append(MessageFormat.format(Messages.PlanHTMLGenerator_CONTENT_DATES_START, iteration.getStartDate()));
                } else if (iteration.getEndDate() != null) {
                    body.append(MessageFormat.format(Messages.PlanHTMLGenerator_CONTENT_DATES_END, iteration.getEndDate()));
                } else {
                    body.append(Messages.PlanHTMLGenerator_CONTENT_DATES_NONE);
                }
                Html.BR.open(body, new Html.Attribute[0]);
                Html.DIV.close(body);
                Html.DIV.open(body, new Html.Attribute("style", "margin-top: 0.5em; margin-bottom: 0.5em;"));
                AbstractPlanHTMLGenerator.renderProgressBar(body, item);
                Html.DIV.close(body);
                ProgressItemDomainAdapter.appendProgressReport(body, item);
                targetBuffer.append(body.toString());
            }
            catch (InvocationTargetException e) {
                targetBuffer.append(Messages.PlanHTMLGenerator_FAILURE_CREATE_CONTENT);
                PlanningUIPlugin.log("An exception occurred during the creation of the IIterationPlanRecord tooltip content", e);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.generateHead(headDefinitions);
    }
}

