/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.preview;

import com.ibm.team.apt.common.resource.IContributorAbsence;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.teamload.LoadItem;
import com.ibm.team.apt.internal.client.teamload.LoadItems;
import com.ibm.team.apt.internal.ide.ui.ImagePool;
import com.ibm.team.apt.internal.ide.ui.preview.Messages;
import com.ibm.team.apt.internal.ide.ui.util.Html;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.itemview.MarkupUtil;
import com.ibm.team.jface.preview.DomainAdapter;
import com.ibm.team.jface.preview.IDomainAdapter;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.util.NLS;
import java.text.MessageFormat;
import java.util.HashMap;
import org.eclipse.jface.resource.ImageDescriptor;

public class LoadItemDomainAdapter
extends DomainAdapter {
    private static final String GENERAL_CSS = "GENERAL_CSS";

    public String generateJobInfo(Object input, IDomainAdapter.Info info) {
        if (!(input instanceof LoadItem)) {
            return null;
        }
        return Messages.LoadItemDomainAdapter_JOB_INFO;
    }

    protected Object convertToDomainObject(Object object) {
        if (object instanceof LoadItem) {
            return object;
        }
        return null;
    }

    protected void generateHead(HashMap map) {
        if (map.containsKey(GENERAL_CSS)) {
            return;
        }
        String font = MarkupUtil.getFont();
        StringBuilder css = new StringBuilder();
        css.append("<style type=\"text/css\">");
        css.append("body { overflow: auto; }\n");
        css.append("table{ ").append(font).append(" }");
        css.append("a:link { text-decoration: none; }");
        css.append("a:visited { color:#0000FF; text-decoration: none; }");
        css.append("a:hover { text-decoration: underline; }");
        css.append("</style>");
        map.put(GENERAL_CSS, css.toString());
    }

    public void generateContentAsHTML(HashMap head, StringBuffer body, Object input, IDomainAdapter.Info info) {
        String text;
        if (!(input instanceof LoadItem)) {
            return;
        }
        this.generateHead(head);
        LoadItem item = (LoadItem)input;
        body.append(this.generateTitle(item));
        if (item.usesDefaultWorkAssignment() && item.usesDefaultWorkLocation()) {
            text = NLS.bind((String)Messages.LoadItemDomainAdapter_MSG_DEFAULT_INFO, (Object[])new Object[]{this.userEditorLink(item.getContributor())});
            body.append(this.warning(text));
        } else if (item.usesDefaultWorkAssignment()) {
            text = NLS.bind((String)Messages.LoadItemDomainAdapter_MSG_DEFAULT_ASSIGNMENT, (Object[])new Object[]{this.userEditorLink(item.getContributor())});
            body.append(this.warning(text));
        } else if (item.usesDefaultWorkLocation()) {
            text = NLS.bind((String)Messages.LoadItemDomainAdapter_MSG_DEFAULT_WORK_DAYS, (Object[])new Object[]{item.getContributor()});
            body.append(this.warning(text));
        }
        Html.BR.open(body, new Html.Attribute[0]);
        body.append(NLS.bind((String)Messages.LoadItemDomainAdapter_CONTENT_HOURS_AVAILABLE, (Object[])new Object[]{LoadItems.getTextWorkTimeLeft((LoadItem)item)}));
        Html.BR.open(body, new Html.Attribute[0]);
        body.append(NLS.bind((String)Messages.LoadItemDomainAdapter_CONTENT_HOURS_ESTIMATED, (Object[])new Object[]{LoadItems.getTextSumOfEstimates((LoadItem)item)}));
        Html.BR.open(body, new Html.Attribute[0]);
        if (LoadItems.isOverbooked((LoadItem)item)) {
            body.append(NLS.bind((String)Messages.LoadItemDomainAdapter_CONTENT_HOURS_OVERBOOKED, (Object[])new Object[]{LoadItems.getHoursOverbooked((LoadItem)item)}));
            Html.BR.open(body, new Html.Attribute[0]);
        }
        Html.BR.open(body, new Html.Attribute[0]);
        body.append(NLS.bind((String)Messages.LoadItemDomainAdapter_CONTENT_RATIO_ESTIMATED, (Object[])new Object[]{item.getEstimatedItems().size(), item.getOpenItems().size(), LoadItems.getQualityOfPlanning((LoadItem)item)}));
        Html.BR.open(body, new Html.Attribute[0]);
        body.append(NLS.bind((String)Messages.LoadItemDomainAdapter_CONTENT_QUALITY_OF_PLANNING, (Object[])new Object[]{String.valueOf(Html.ITALIC.open) + LoadItems.getTextQualityOfPlanning((LoadItem)item) + Html.ITALIC.close}));
        Html.BR.open(body, new Html.Attribute[0]);
        if (!item.getAbsences().isEmpty()) {
            Html.BR.open(body, new Html.Attribute[0]);
            body.append(Messages.LoadItemDomainAdapter_CONTENT_ABSENCES_HEADER);
            Html.OL.open(body, new Html.Attribute("style", "margin-top: 0px;"));
            for (IContributorAbsence absence : item.getAbsences()) {
                Html.LI.open(body, new Html.Attribute[0]);
                body.append(MessageFormat.format(Messages.LoadItemDomainAdapter_CONTENT_ABSENCE_DETAIL, absence.getSummary(), absence.getStartDate(), absence.getEndDate()));
                Html.LI.close(body);
            }
            Html.OL.close(body);
        }
    }

    private CharSequence userEditorLink(IContributor contributor) {
        ITeamRepository repository = PlanningClientPlugin.getTeamRepository((IItemHandle)contributor);
        Location location = Location.itemLocation((IItemHandle)contributor, (String)repository.getRepositoryURI());
        StringBuilder body = new StringBuilder();
        Html.ANCHOR.open(body, new Html.Attribute("href", location.toAbsoluteUri().toASCIIString()));
        body.append(contributor.getName());
        Html.ANCHOR.close(body);
        return body;
    }

    private CharSequence warning(String warning) {
        StringBuffer body = new StringBuffer();
        Html.TABLE.open(body, new Html.Attribute[0]);
        Html.TR.open(body, new Html.Attribute[0]);
        Html.TD.open(body, new Html.Attribute[0]);
        Html.IMG.open(body, new Html.Attribute("src", JazzResources.createURL((ImageDescriptor)ImagePool.WARNING_OBJ).toString()));
        Html.TD.close(body);
        Html.TD.open(body, new Html.Attribute[0]);
        body.append(warning);
        Html.TD.close(body);
        Html.TR.close(body);
        Html.TABLE.close(body);
        return body;
    }

    public String generateTitle(Object input) {
        if (!(input instanceof LoadItem)) {
            return null;
        }
        LoadItem item = (LoadItem)input;
        StringBuilder body = new StringBuilder();
        Html.H5.open(body, new Html.Attribute("style", "margin-bottom: 0px;"));
        body.append(NLS.bind((String)Messages.LoadItemDomainAdapter_CONTENT_TITLE, (Object[])new Object[]{item.getContributor().getName()}));
        Html.H5.close(body);
        body.append(NLS.bind((String)Messages.LoadItemDomainAdapter_CONTENT_ASSIGNMENT, (Object[])new Object[]{item.getAssignment()}));
        Html.BR.open(body, new Html.Attribute[0]);
        return body.toString();
    }
}

