/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.preview;

import com.ibm.team.apt.common.IIterationPlanRecord;
import com.ibm.team.apt.common.IIterationPlanRecordHandle;
import com.ibm.team.apt.internal.client.IIterationPlanClient;
import com.ibm.team.apt.internal.client.IterationPlanClient;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.common.ProgressInformation;
import com.ibm.team.apt.internal.common.ProgressItem;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.navigator.AbstractIterationFolder;
import com.ibm.team.apt.internal.ide.ui.preview.AbstractPlanHTMLGenerator;
import com.ibm.team.apt.internal.ide.ui.preview.Messages;
import com.ibm.team.apt.internal.ide.ui.util.Html;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.jface.preview.IDomainAdapter;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.process.rcp.ui.teamnavigator.DomainSubtreeRoot;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.query.IItemQueryPage;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.model.DurationFormat;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IterationFolderHTMLGenerator
extends AbstractPlanHTMLGenerator {
    private AbstractIterationFolder fIterationFolder;

    public IterationFolderHTMLGenerator(AbstractIterationFolder iterationFolder) {
        this.fIterationFolder = iterationFolder;
    }

    public void generate(HashMap headDefinitions, StringBuffer targetBuffer, IDomainAdapter.Info info) {
        StringBuilder buffer = new StringBuilder();
        IIteration iteration = this.fIterationFolder.getIteration();
        Html.H5.open(buffer, new Html.Attribute[0]);
        XMLString name = XMLString.createFromPlainText((String)this.fIterationFolder.getName());
        buffer.append(name.getXMLText());
        Html.H5.close(buffer);
        Html.DIV.open(buffer, new Html.Attribute[0]);
        Date startDate = iteration.getStartDate();
        Date endDate = iteration.getEndDate();
        boolean datesSet = startDate != null && endDate != null;
        Html.SPAN.open(buffer, new Html.Attribute[0]);
        if (datesSet) {
            buffer.append(MessageFormat.format(Messages.IterationFolderHTMLGenerator_DURATION_RANGE_DATES, startDate, endDate));
        } else if (startDate != null) {
            buffer.append(MessageFormat.format(Messages.IterationFolderHTMLGenerator_DURATION_RANGE_NO_END_DATE, startDate));
        } else if (endDate != null) {
            buffer.append(MessageFormat.format(Messages.IterationFolderHTMLGenerator_DURATION_RANGE_NO_START_END, endDate));
        } else {
            buffer.append(Messages.IterationFolderHTMLGenerator_DURATION_RANGE_NO_DATES);
        }
        if (datesSet) {
            buffer.append(' ');
            Html.SPAN.open(buffer, new Html.Attribute("class", "days-left"));
            long remainingDays = Math.max(this.getTotalIntervalWorkdays(iteration) - this.getIntervalWorkdaysSinceStart(iteration), 0L);
            String unit = DurationFormat.getInstance().getUnitString(DurationFormat.UNIT_DAYS, (double)remainingDays, 0);
            buffer.append(NLS.bind((String)Messages.IterationFolderHTMLGenerator_DURATION_TIME_LEFT, (Object[])new Object[]{remainingDays, unit}));
            Html.SPAN.close(buffer);
        }
        Html.SPAN.close(buffer);
        Html.DIV.close(buffer);
        Html.HR.close(buffer);
        Html.TABLE.open(buffer, new Html.Attribute("border", "0"), new Html.Attribute("width", "100%"));
        DomainSubtreeRoot parent = this.fIterationFolder.getRoot().getDomainSubtreeRoot();
        Object categoryElement = parent.getCategoryElement();
        if (categoryElement instanceof ITeamArea) {
            categoryElement = ((ITeamArea)categoryElement).getProjectArea();
        }
        IProjectAreaHandle projectAreaHandle = (IProjectAreaHandle)categoryElement;
        List teamAreas = ConnectedProjectAreaRegistry.getDefault().getSelectedTeamAreas(projectAreaHandle);
        if (teamAreas.isEmpty()) {
            return;
        }
        ITeamRepository repository = (ITeamRepository)projectAreaHandle.getOrigin();
        IterationPlanClient client = (IterationPlanClient)PlanningClientPlugin.getIterationPlanClient((ITeamRepository)repository);
        try {
            boolean planExists = false;
            IItemQueryPage page = client.fetchIterationPlanRecords(teamAreas, (IIterationHandle)this.fIterationFolder.getIteration(), 10);
            List itemHandles = page.getItemHandles();
            if (!itemHandles.isEmpty()) {
                this.renderIterationPlan(buffer, itemHandles);
                planExists = true;
            }
            while (page.hasNext()) {
                itemHandles = (page = client.fetchNextQueryPage(page, 10)).getItemHandles();
                if (itemHandles.isEmpty()) continue;
                this.renderIterationPlan(buffer, itemHandles);
                planExists = true;
            }
            if (!planExists) {
                Html.TR.open(buffer, new Html.Attribute[0]);
                Html.TD.open(buffer, new Html.Attribute[0]);
                buffer.append(Messages.IterationFolderHTMLGenerator_NO_PLANS);
                Html.TD.close(buffer);
                Html.TR.close(buffer);
            }
            targetBuffer.append(buffer.toString());
        }
        catch (TeamRepositoryException e) {
            this.handleException(targetBuffer, (Exception)((Object)e));
        }
        catch (InvocationTargetException e) {
            this.handleException(targetBuffer, e);
        }
        Html.TABLE.close(buffer);
        this.generateHead(headDefinitions);
    }

    private void renderIterationPlan(StringBuilder buffer, List<IIterationPlanRecordHandle> handles) throws TeamRepositoryException, InvocationTargetException {
        if (handles.isEmpty()) {
            return;
        }
        IItemManager manager = PlanningClientPlugin.getTeamRepository((IItemHandle)((IItemHandle)handles.get(0))).itemManager();
        IIterationPlanClient client = PlanningClientPlugin.getIterationPlanClient((IItemHandle)((IItemHandle)handles.get(0)));
        List progressInformations = client.fetchPlanProgress2(handles, (IProgressMonitor)new NullProgressMonitor());
        List partialPlans = manager.fetchPartialItems(handles, 0, (Collection)Arrays.asList(IIterationPlanRecord.NAME_PROPERTY), (IProgressMonitor)new NullProgressMonitor());
        ListIterator iter = partialPlans.listIterator();
        while (iter.hasNext()) {
            IIterationPlanRecord planRecord = (IIterationPlanRecord)iter.next();
            ProgressInformation progressInformation = (ProgressInformation)progressInformations.get(iter.nextIndex() - 1);
            Html.TR.open(buffer, new Html.Attribute[0]);
            Html.TD.open(buffer, new Html.Attribute[0]);
            Html.append(buffer, XMLString.createFromPlainText((String)planRecord.getName()).getXMLText());
            Html.TD.close(buffer);
            Html.TD.open(buffer, new Html.Attribute("width", "100%"));
            IterationFolderHTMLGenerator.renderProgressBar(buffer, ProgressItem.create((ProgressInformation)progressInformation));
            Html.TD.close(buffer);
            Html.TR.close(buffer);
        }
    }

    private void handleException(StringBuffer targetBuffer, Exception e) {
        targetBuffer.append(Messages.IterationFolderHTMLGenerator_FAILURE_CREATING_CONTENT);
        PlanningUIPlugin.log("An exception occurred during the creation of the IterationFolder tooltip content", e);
    }
}

