/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.preview;

import com.ibm.team.apt.common.IIterationPlanRecord;
import com.ibm.team.apt.common.IIterationPlanRecordHandle;
import com.ibm.team.apt.internal.client.IIterationPlanClient;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.common.ProgressInformation;
import com.ibm.team.apt.internal.common.ProgressItem;
import com.ibm.team.apt.internal.ide.ui.util.Html;
import com.ibm.team.jface.itemview.MarkupUtil;
import com.ibm.team.jface.preview.HTMLGenerator;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPlanHTMLGenerator
extends HTMLGenerator {
    private static final String GENERAL_CSS = "GENERAL_ITERATIONPLAN_CSS";

    protected void generateHead(HashMap map) {
        if (map.containsKey(GENERAL_CSS)) {
            return;
        }
        String font = MarkupUtil.getFont();
        StringBuilder css = new StringBuilder();
        Html.STYLE.open(css, new Html.Attribute("type", "text/css"));
        css.append("body {overflow: auto;}\n");
        css.append("table {").append(font).append("}");
        css.append("h5 {margin-bottom: 0px;}");
        css.append("a:link {text-decoration: none;}a:visited {color:#0000FF; text-decoration: none;}a:hover {text-decoration: underline;}");
        css.append(".noWorkEstimatedLabel {height: 1.3em; width: 100%; border:1pt solid #cccccc; overflow:hidden; position:relative; z-index:0; background-color: #ffffff; text-align: center; vertical-align: middle; color: gray;}div {margin: 0pt; padding: 0pt;}.bar {padding: 1pt; background-color:white; border:1pt solid #cccccc; height: 1.3em; }.barContainer {background-color:white; height: 100%; width: 100%; overflow:hidden; position:relative; z-index:0;}.barContainer .barPart {overflow:hidden; position:absolute; z-index:-1;}.barContainer .barPartTitle {bottom:0pt; height:auto; left:0pt; margin:0pt; overflow:hidden; padding:0pt; position:absolute; right:0pt; top:0pt; width:100%;}.barContainer .completed .barPartTitle {border-right: 1pt solid white;}.barContainer .completed {left: 0pt;background-color: #9ebf9e;}.barContainer .difference.none {display: none;}.barContainer .estimated.difference.ahead {background-color: #b9d6b9;}.barContainer .estimated.difference.behind {background-color: #de9c9c;}.barContainer .notEstimated { top: 0pt; background-color: #e0e0e0;}.barContainer .estimated { bottom: 0pt;}.barContainer .open { right: 0pt; background-color: #ffffff;}");
        Html.STYLE.close(css);
        map.put(GENERAL_CSS, css.toString());
    }

    protected void createControl(HTMLGenerator.Composite composite) {
    }

    public static <T extends Appendable & CharSequence> void renderProgressBar(T body, IIterationPlanRecord record, IProgressMonitor monitor) throws TeamRepositoryException {
        IIterationPlanClient client = PlanningClientPlugin.getIterationPlanClient((IItemHandle)record);
        ProgressInformation information = client.fetchPlanProgress2((IIterationPlanRecordHandle)record, monitor);
        ProgressItem item = ProgressItem.create((ProgressInformation)information);
        AbstractPlanHTMLGenerator.renderProgressBar(body, item);
    }

    public static <T extends Appendable & CharSequence> void renderProgressBar(T body, ProgressItem item) {
        switch (item.getKind()) {
            case MESSAGE: 
            case LOADING: {
                AbstractPlanHTMLGenerator.internalRenderMessage(body, item);
                break;
            }
            case BAR_WITH_PROJECTION: 
            case BAR: 
            case DONE: {
                AbstractPlanHTMLGenerator.internalRenderProgressBar(body, item);
            }
        }
    }

    private static <T extends Appendable & CharSequence> void internalRenderMessage(T body, ProgressItem item) {
        Html.DIV.open(body, new Html.Attribute[]{AbstractPlanHTMLGenerator.classAttribute("noWorkEstimatedLabel")});
        Html.append(body, item.getMessage().getMessage());
        Html.DIV.close(body);
    }

    private static <T extends Appendable & CharSequence> void internalRenderProgressBar(T body, ProgressItem item) {
        int widthCompleted;
        boolean done = item.getKind() == ProgressItem.Kind.DONE;
        float quality = item.getQualityOfPlanning();
        int heightEstimated = done ? 100 : (int)quality;
        int heightNotEstimated = 100 - heightEstimated;
        StringBuilder buffer = new StringBuilder();
        String heightAttr = "height: ";
        String widthAttr = "width: ";
        String leftAttr = "left: ";
        String invisible = "visible: none;";
        String percent = "%;";
        buffer.setLength(0);
        buffer.append(heightAttr).append(heightNotEstimated).append(percent);
        String cssHeightNotEstimated = buffer.toString();
        buffer.setLength(0);
        buffer.append(heightAttr).append(heightEstimated).append(percent);
        String cssHeightEstimated = buffer.toString();
        int widthProjection = (int)(100.0f * Math.abs(item.getProjection()));
        buffer.setLength(0);
        buffer.append(widthAttr).append(widthProjection).append(percent);
        if (done) {
            buffer.append(invisible);
        }
        String cssWidthDifference = buffer.toString();
        int n = widthCompleted = done ? 100 : (int)(100.0f * item.getRealTimeRatio());
        if (!item.isAhead()) {
            widthCompleted -= widthProjection;
        }
        buffer.setLength(0);
        buffer.append(widthAttr).append(widthCompleted).append(percent);
        String cssWidthCompleted = buffer.toString();
        int widthOpen = Math.max(0, 100 - (widthProjection + widthCompleted));
        buffer.setLength(0);
        buffer.append(widthAttr).append(widthOpen).append(percent);
        if (done) {
            buffer.append(invisible);
        }
        String cssWidthOpen = buffer.toString();
        buffer.setLength(0);
        buffer.append(leftAttr).append(widthCompleted).append(percent);
        String cssLeftDifference = buffer.toString();
        StringBuilder style = new StringBuilder();
        Html.DIV.open(body, new Html.Attribute[]{AbstractPlanHTMLGenerator.classAttribute("bar")});
        Html.DIV.open(body, new Html.Attribute[]{AbstractPlanHTMLGenerator.classAttribute("barContainer")});
        style.setLength(0);
        AbstractPlanHTMLGenerator.renderProgressBarPart(body, new Html.Attribute[]{AbstractPlanHTMLGenerator.classAttribute("barPart notEstimated completed"), AbstractPlanHTMLGenerator.styleAttribute(style.append(cssHeightNotEstimated).append(cssWidthCompleted).toString())});
        style.setLength(0);
        AbstractPlanHTMLGenerator.renderProgressBarPart(body, new Html.Attribute[]{AbstractPlanHTMLGenerator.classAttribute("barPart notEstimated difference"), AbstractPlanHTMLGenerator.styleAttribute(style.append(cssHeightNotEstimated).append(cssWidthDifference).append(cssLeftDifference).toString())});
        style.setLength(0);
        AbstractPlanHTMLGenerator.renderProgressBarPart(body, new Html.Attribute[]{AbstractPlanHTMLGenerator.classAttribute("barPart notEstimated open"), AbstractPlanHTMLGenerator.styleAttribute(style.append(cssHeightNotEstimated).append(cssWidthOpen).toString())});
        style.setLength(0);
        AbstractPlanHTMLGenerator.renderProgressBarPart(body, new Html.Attribute[]{AbstractPlanHTMLGenerator.classAttribute("barPart estimated completed"), AbstractPlanHTMLGenerator.styleAttribute(style.append(cssHeightEstimated).append(cssWidthCompleted).toString())});
        style.setLength(0);
        AbstractPlanHTMLGenerator.renderProgressBarPart(body, new Html.Attribute[]{AbstractPlanHTMLGenerator.classAttribute("barPart estimated difference " + (item.isAhead() ? "ahead" : "behind")), AbstractPlanHTMLGenerator.styleAttribute(style.append(cssHeightEstimated).append(cssWidthDifference).append(cssLeftDifference).toString())});
        style.setLength(0);
        AbstractPlanHTMLGenerator.renderProgressBarPart(body, new Html.Attribute[]{AbstractPlanHTMLGenerator.classAttribute("barPart estimated open"), AbstractPlanHTMLGenerator.styleAttribute(style.append(cssHeightEstimated).append(cssWidthOpen).toString())});
        Html.DIV.close(body);
        Html.DIV.close(body);
    }

    private static <T extends Appendable & CharSequence> void renderProgressBarPart(T body, Html.Attribute ... attributes) {
        Html.DIV.open(body, attributes);
        Html.DIV.open(body, new Html.Attribute[]{AbstractPlanHTMLGenerator.classAttribute("barPartTitle")});
        Html.DIV.close(body);
        Html.DIV.close(body);
    }

    private static Html.Attribute classAttribute(String value) {
        return new Html.Attribute("class", value);
    }

    private static Html.Attribute styleAttribute(String value) {
        return new Html.Attribute("style", value);
    }

    protected long getTotalIntervalWorkdays(IIteration interval) {
        return this.getDays(interval.getStartDate().getTime(), interval.getEndDate().getTime());
    }

    protected long getIntervalWorkdaysSinceStart(IIteration interval) {
        return this.getDays(interval.getStartDate().getTime(), System.currentTimeMillis());
    }

    private long getDays(long start, long end) {
        double days = (end - start) / 86400000L;
        return (days -= days / 7.0 * 2.0) < 1.0 ? 0L : (long)days;
    }
}

