/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.navigator;

import com.ibm.team.apt.internal.common.util.ItemArrayList;
import com.ibm.team.apt.internal.common.util.ItemCollections;
import com.ibm.team.apt.internal.common.util.ItemList;
import com.ibm.team.apt.internal.ide.ui.navigator.RootFolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PlanningDomainFolder {
    private PlanningDomainFolder fParent;
    private ItemList<PlanningDomainFolder> fChildren;

    protected PlanningDomainFolder(PlanningDomainFolder parent) {
        this.fParent = parent;
        if (this.fParent instanceof PlanningDomainFolder) {
            this.fParent.addChild(this);
        }
    }

    public Object getParent() {
        return this.fParent;
    }

    public RootFolder getRoot() {
        if (this.fParent != null) {
            return this.fParent.getRoot();
        }
        return null;
    }

    public ItemList<PlanningDomainFolder> getChildren() {
        if (this.fChildren == null) {
            return ItemCollections.emptyList();
        }
        return ItemCollections.unmodifiableItemList(this.fChildren);
    }

    public void clearChildren() {
        if (this.fChildren == null) {
            return;
        }
        this.doClearChildren(this.getRoot());
    }

    private void doClearChildren(RootFolder root) {
        if (this.fChildren == null) {
            return;
        }
        for (PlanningDomainFolder folder : this.fChildren) {
            folder.doClearChildren(root);
            folder.unmanage(root);
        }
        this.fChildren = null;
    }

    private void addChild(PlanningDomainFolder element) {
        if (this.fChildren == null) {
            this.fChildren = new ItemArrayList(4);
        }
        this.fChildren.add((Object)element);
    }

    public abstract String getName();

    protected abstract void unmanage(RootFolder var1);
}

