/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.navigator;

import com.ibm.team.apt.common.IIterationPlanRecord;
import com.ibm.team.apt.common.IIterationPlanRecordHandle;
import com.ibm.team.apt.internal.client.IterationPlanClient;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.ide.core.PlanDeletedEvent;
import com.ibm.team.apt.internal.ide.core.PlanEvent;
import com.ibm.team.apt.internal.ide.core.PlanModel;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.navigator.ITANAction;
import com.ibm.team.apt.internal.ide.ui.navigator.Messages;
import com.ibm.team.apt.internal.ide.ui.util.TeamExceptionHandler;
import com.ibm.team.apt.internal.ide.ui.util.TeamRunnable;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchSite;

public class DeleteIterationPlanAction
implements ITANAction {
    public boolean isEnabled(IStructuredSelection selection) {
        return selection.size() == 1;
    }

    public void run(final IWorkbenchSite site, IStructuredSelection selection) {
        final IIterationPlanRecord iterationPlanRecord = (IIterationPlanRecord)selection.getFirstElement();
        MessageDialog dialog = new MessageDialog(site.getShell(), Messages.DeleteIterationPlanAction_CONFIRM, null, NLS.bind((String)Messages.DeleteIterationPlanAction_CONFIRM_DETAIL, (Object[])new Object[]{iterationPlanRecord.getName()}), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
        int open = dialog.open();
        if (open == 0) {
            try {
                site.getWorkbenchWindow().getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)new TeamRunnable(){

                    protected void execute(IProgressMonitor monitor) throws TeamRepositoryException, InvocationTargetException, InterruptedException {
                        try {
                            monitor.beginTask(Messages.DeleteIterationPlanAction_FAILURE_DELETE_PLAN, 3);
                            IterationPlanClient client = (IterationPlanClient)PlanningClientPlugin.getIterationPlanClient((IItemHandle)iterationPlanRecord);
                            IOperationReport report = client.delete((IIterationPlanRecordHandle)iterationPlanRecord);
                            if (report.getSeverity() == 0) {
                                UI.syncExec((Control)site.getShell(), new Runnable(){

                                    public void run() {
                                        PlanningUIPlugin.closeIterationPlanEditor((IIterationPlanRecordHandle)iterationPlanRecord, site.getPage(), false);
                                    }
                                });
                                PlanModel.INSTANCE.firePlanEvent((PlanEvent)new PlanDeletedEvent(PlanningClientPlugin.getTeamRepository((IItemHandle)iterationPlanRecord), iterationPlanRecord));
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                TeamExceptionHandler.handle(e, site.getShell(), Messages.DeleteIterationPlanAction_FAILURE_DELETE_PLAN, e.getLocalizedMessage());
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

