/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.mywork;

import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.ide.ui.common.GadgetFactory;
import com.ibm.team.apt.internal.ide.ui.common.PlanViewer;
import com.ibm.team.apt.internal.ide.ui.common.PlanViewerDragAdapter;
import com.ibm.team.apt.internal.ide.ui.common.PlanViewerDropAdapter;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineEntry;
import com.ibm.team.apt.internal.ide.ui.mywork.ISelectionMediator;
import com.ibm.team.apt.internal.ide.ui.mywork.MyWorkCanvas;
import com.ibm.team.apt.internal.ide.ui.mywork.MyWorkOutlineItem;
import com.ibm.team.apt.internal.ide.ui.testing.ITimelineViewerTestAccess;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Outline;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineItem;
import com.ibm.team.foundation.rcp.ui.dnd.URIReferenceTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyWorkViewer
extends PlanViewer {
    private final IWorkbenchPartSite fSite;
    private boolean fIsFiringSelectionEvent;
    private final ISelectionMediator fSelectionMediator;
    private final ITimelineViewerTestAccess fTestAccess = new ITimelineViewerTestAccess(){

        public OutlineItem findItem(Object element) {
            return (OutlineItem)MyWorkViewer.this.findItem(element);
        }
    };

    public MyWorkViewer(GadgetFactory gadgetFactory, MyWorkCanvas canvas, ISelectionMediator selectionMediator, IWorkbenchPartSite site) {
        super(gadgetFactory, canvas);
        this.fSelectionMediator = selectionMediator;
        this.fSite = site;
        this.setUseHashlookup(true);
        this.hookDragAndDrop();
    }

    @Override
    public MyWorkCanvas getOutline() {
        return (MyWorkCanvas)super.getOutline();
    }

    public void setTopItem(OutlineEntry<?> first) {
        Widget findItem = this.findItem(first);
        if (findItem instanceof OutlineItem) {
            this.getOutline().setTopItem((OutlineItem)findItem);
        }
    }

    public void dispose() {
    }

    protected Item newItem(Widget parent, int style, int index) {
        MyWorkOutlineItem result = parent instanceof Outline ? new MyWorkOutlineItem((MyWorkCanvas)parent, style, index) : new MyWorkOutlineItem((MyWorkOutlineItem)parent, style, index);
        return result;
    }

    protected void fireSelectionChanged(SelectionChangedEvent event) {
        try {
            this.fIsFiringSelectionEvent = true;
            super.fireSelectionChanged(event);
        }
        finally {
            this.fIsFiringSelectionEvent = false;
        }
    }

    public void setSelection(ISelection selection, boolean reveal) {
        if (this.fSelectionMediator != null) {
            this.fSelectionMediator.setSelection(selection, reveal);
        } else {
            this.internalSetSelection(selection, reveal);
        }
    }

    void internalSetSelection(ISelection selection, boolean reveal) {
        if (!this.fIsFiringSelectionEvent) {
            boolean ignoreSelection = false;
            if (selection instanceof IStructuredSelection) {
                ignoreSelection = !selection.isEmpty();
                Object[] objectArray = ((IStructuredSelection)selection).toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    if (this.internalExpand(element, false) != null) {
                        ignoreSelection = false;
                        break;
                    }
                    ++n2;
                }
            }
            if (!ignoreSelection) {
                super.setSelection(selection, reveal);
            }
        }
    }

    private void hookDragAndDrop() {
        DragSource dragSource = new DragSource((Control)this.getOutline(), 6);
        dragSource.setTransfer(new Transfer[]{LocalSelectionTransfer.getInstance(), URIReferenceTransfer.getInstance()});
        dragSource.addDragListener((DragSourceListener)new PlanViewerDragAdapter(this){

            protected Object convertToExternal(Object in) {
                return in instanceof PlanItem ? ((PlanItem)in).getWorkItemHandle() : null;
            }
        });
        DropTarget dropTarget = new DropTarget((Control)this.getOutline(), 6);
        dropTarget.setTransfer(new Transfer[]{LocalSelectionTransfer.getInstance()});
        dropTarget.addDropListener((DropTargetListener)new PlanViewerDropAdapter(this, this.fSite){

            protected int computeLocation(DropTargetEvent event) {
                int result = 0;
                if (event.item instanceof OutlineItem && ((OutlineItem)event.item).getContent() != null) {
                    MyWorkCanvas outline = MyWorkViewer.this.getOutline();
                    int eventY = outline.getTransformation().toPane((Point)outline.toControl((int)event.x, (int)event.y)).y;
                    OutlineItem item = (OutlineItem)event.item;
                    Rectangle itemBounds = item.getContent().getBounds();
                    result = item.getElement() instanceof PlanItem ? (eventY < itemBounds.y + itemBounds.height / 2 ? 2 : 4) : super.computeLocation(event);
                }
                return result;
            }
        });
    }

    public ITimelineViewerTestAccess testAccess() {
        return this.fTestAccess;
    }
}

