/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.mywork;

import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryUtils;
import com.ibm.team.apt.internal.ide.ui.common.model.IOutlineModelReader;
import com.ibm.team.apt.internal.ide.ui.common.model.ModelReadRunnable;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineEntry;
import com.ibm.team.apt.internal.ide.ui.common.structure.GroupElement;
import com.ibm.team.apt.internal.ide.ui.mywork.Messages;
import com.ibm.team.apt.internal.ide.ui.mywork.MyWorkResources;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GLabel;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GTreeNode;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GTreeNodeContent;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Insets;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Rectangles;
import com.ibm.team.repository.common.util.NLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyWorkGroupNodeContent
extends GTreeNodeContent {
    private final GroupElement fGroupElement;
    GLabel fNameLabel;
    GLabel fStatusLabel;
    private Insets fInsets;

    public MyWorkGroupNodeContent(GTreeNode parent, final OutlineEntry<GroupElement> groupEntry) {
        super(parent);
        this.fGroupElement = groupEntry.getElement();
        MyWorkResources timelineResources = this.getTimelineResources();
        this.fNameLabel = new GLabel(this, this.fGroupElement.getLabel(), 64);
        this.fNameLabel.setColor(timelineResources.getGroupTextColor());
        this.fNameLabel.setFont(timelineResources.getGroupTextFont());
        this.fNameLabel.setReturnParentElement(true);
        int[] counts = groupEntry.getModel().readModel(new ModelReadRunnable<int[], RuntimeException>(){

            @Override
            public int[] run(IOutlineModelReader readAccessor) throws RuntimeException {
                int[] result = new int[2];
                for (PlanItem planItem : EntryUtils.elementsOfType(readAccessor.getChildren(groupEntry), PlanItem.class)) {
                    int n = planItem.isResolved() ? 1 : 0;
                    result[n] = result[n] + 1;
                }
                return result;
            }
        });
        int openCount = counts[0];
        int closedCount = counts[1];
        String label = openCount != 0 && closedCount != 0 ? NLS.bind((String)Messages.MyWorkGroupNodeContent_LABEL_OPEN_AND_CLOSE_COUNT, (Object[])new Object[]{openCount, closedCount}) : NLS.bind((String)Messages.MyWorkGroupNodeContent_LABEL_OPEN_OR_CLOSE_COUNT, (Object[])new Object[]{closedCount != 0 ? closedCount : openCount});
        this.fStatusLabel = new GLabel(this, label, 64);
        this.fStatusLabel.setColor(timelineResources.getGroupStatusColor());
        this.fStatusLabel.setFont(timelineResources.getGroupStatusFont());
        this.fInsets = new Insets(2, 4, 2, 4);
    }

    @Override
    public int computeMinimalWidth() {
        return this.max(this.fNameLabel.computeMinimalWidth(), this.fStatusLabel.computeMinimalWidth());
    }

    @Override
    protected Point arrangeContent(int x, int y, int wHint, int hHint) {
        this.fNameLabel.layout(x, y, -1, -1);
        this.fStatusLabel.layout(x += this.fNameLabel.getWidth() + this.getTimelineResources().getSpaceWidth() * 2, y, -1, -1);
        int moveY = 0;
        if (this.fStatusLabel.getHeight() < this.fNameLabel.getHeight()) {
            moveY = this.fNameLabel.getHeight() - this.fStatusLabel.getHeight() - (this.fNameLabel.getDescent() - this.fStatusLabel.getDescent());
            this.fStatusLabel.move(0, moveY);
        }
        return new Point(this.max(wHint, this.fNameLabel.getWidth() + this.fStatusLabel.getWidth()), this.max(this.fNameLabel.getHeight(), this.fStatusLabel.getHeight()));
    }

    public void relayout() {
        Rectangle oldBounds = Rectangles.create(this.getBounds());
        this.layout(oldBounds.x, oldBounds.y, oldBounds.width, -1);
        this.getOutlineItem().getOutline().redraw(this, false);
    }

    @Override
    public Insets getInsets() {
        return this.fInsets;
    }

    private MyWorkResources getTimelineResources() {
        return (MyWorkResources)this.getOutlineResources();
    }

    @Override
    public Object getElement() {
        return this.fGroupElement;
    }
}

