/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.mywork;

import com.ibm.team.apt.internal.client.IPlanElementChangeEvent;
import com.ibm.team.apt.internal.client.IPlanElementDelta;
import com.ibm.team.apt.internal.client.IPlanElementDeltaVisitor;
import com.ibm.team.apt.internal.client.IPlanElementListener;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.ResolvedPersonalPlan;
import com.ibm.team.apt.internal.ide.ui.actions.AssignActionFactory;
import com.ibm.team.apt.internal.ide.ui.actions.DeleteDraftItemAction;
import com.ibm.team.apt.internal.ide.ui.actions.MovePlanItemDownAction;
import com.ibm.team.apt.internal.ide.ui.actions.MovePlanItemUpAction;
import com.ibm.team.apt.internal.ide.ui.actions.OpenAbsenceAction;
import com.ibm.team.apt.internal.ide.ui.actions.OpenPlanItemAction;
import com.ibm.team.apt.internal.ide.ui.actions.PlanViewModelAction;
import com.ibm.team.apt.internal.ide.ui.actions.RevertPlanItemAction;
import com.ibm.team.apt.internal.ide.ui.actions.SelectAllAction;
import com.ibm.team.apt.internal.ide.ui.actions.WorkItemTypeSelectionAction;
import com.ibm.team.apt.internal.ide.ui.common.PlanViewModel;
import com.ibm.team.apt.internal.ide.ui.mywork.AbstractPlanItemViewerSection;
import com.ibm.team.apt.internal.ide.ui.mywork.AcceptWorkAction;
import com.ibm.team.apt.internal.ide.ui.mywork.ExpandPlanningContolsAction;
import com.ibm.team.apt.internal.ide.ui.mywork.SectionCurrentWork;
import com.ibm.team.apt.internal.ide.ui.mywork.SectionMyFuturePastWork;
import com.ibm.team.apt.internal.ide.ui.mywork.ShowDetailsAction;
import com.ibm.team.apt.internal.ide.ui.mywork.ShowRecentNewsAction;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.handlers.IHandlerService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyWorkActionGroup
extends ActionGroup {
    private IWorkbenchSite fSite;
    private ResolvedPersonalPlan fPlan;
    private UpdateListener fUpdateListener;
    private AssignActionFactory fAssignActionFactory;
    private OpenAbsenceAction fOpenAbsenceAction;
    private SelectAllAction fSelectAllAction;
    private OpenPlanItemAction fOpenPlanItemAction;
    private ExpandPlanningContolsAction fExpandPlanningToolsAction;
    private ShowDetailsAction fShowDetailsAction;
    private ShowRecentNewsAction fShowNewsAction;
    private RevertPlanItemAction fRevertPlanItemAction;
    private DeleteDraftItemAction fDeleteDraftItemAction;
    private IHandlerService fHandlerService;
    private WorkItemTypeSelectionAction fWorkItemSelectionAction;
    private MovePlanItemUpAction fMovePlanItemUpAction;
    private MovePlanItemDownAction fMovePlanItemDownAction;
    private AcceptWorkAction fAcceptWorkAction;
    private Map<String, Action> fActions;
    private final PlanViewModel fViewModel;
    private ISelectionProvider fSelectionProvider;
    private final AbstractPlanItemViewerSection fSection;

    public MyWorkActionGroup(IWorkbenchSite site, PlanViewModel viewModel, AbstractPlanItemViewerSection section) {
        this.fSite = site;
        this.fViewModel = viewModel;
        this.fSection = section;
        this.fSelectionProvider = viewModel.getSelectionProvider();
        this.fUpdateListener = new UpdateListener();
        this.fActions = new HashMap<String, Action>();
        this.fOpenPlanItemAction = new OpenPlanItemAction(this.fSite, viewModel);
        this.initAction(this.fOpenPlanItemAction, "com.ibm.team.apt.actions.myWork.openWorkItem");
        this.fOpenAbsenceAction = new OpenAbsenceAction(this.fSite, viewModel);
        this.initAction(this.fOpenAbsenceAction, null);
        this.fSelectAllAction = new SelectAllAction(this.fSite, viewModel);
        this.initAction(this.fSelectAllAction, ActionFactory.SELECT_ALL.getId());
        this.fExpandPlanningToolsAction = new ExpandPlanningContolsAction(this.fSite, viewModel);
        this.initAction(this.fExpandPlanningToolsAction, "com.ibm.team.apt.actions.myWork.expandPlanningTools");
        this.fShowDetailsAction = new ShowDetailsAction(this.fSite, viewModel, section);
        this.initAction(this.fShowDetailsAction, "com.ibm.team.apt.actions.myWork.showDetails");
        this.fShowNewsAction = new ShowRecentNewsAction(this.fSite, viewModel, section);
        this.initAction(this.fShowNewsAction, "com.ibm.team.apt.actions.myWork.showNews");
        this.fRevertPlanItemAction = new RevertPlanItemAction(this.fSite, viewModel);
        this.initAction(this.fRevertPlanItemAction, null);
        this.fDeleteDraftItemAction = new DeleteDraftItemAction(this.fSite, viewModel);
        this.initAction(this.fDeleteDraftItemAction, null);
        this.fMovePlanItemUpAction = new MovePlanItemUpAction(this.fSite, viewModel);
        this.initAction(this.fMovePlanItemUpAction, "com.ibm.team.apt.actions.iterationPlan.move.up");
        this.fMovePlanItemDownAction = new MovePlanItemDownAction(this.fSite, viewModel);
        this.initAction(this.fMovePlanItemDownAction, "com.ibm.team.apt.actions.iterationPlan.move.down");
        this.fAcceptWorkAction = new AcceptWorkAction(this.fSite, viewModel);
        this.initAction(this.fAcceptWorkAction, "com.ibm.team.apt.actions.myWork.acceptWork");
        if (section instanceof SectionCurrentWork) {
            this.installQuickAccessAction();
        }
    }

    private void installQuickAccessAction() {
        this.fHandlerService = (IHandlerService)this.fSite.getService(IHandlerService.class);
        if (this.fHandlerService != null) {
            this.fWorkItemSelectionAction = new WorkItemTypeSelectionAction(this.fSite, this.fViewModel, "com.ibm.team.apt.actions.iterationPlan.add.below");
            this.fWorkItemSelectionAction.activate(this.fHandlerService);
        }
    }

    public void inputChanged(Object oldInput, Object newInput) {
        if (this.fPlan != null) {
            this.fPlan.removeListener((IPlanElementListener)this.fUpdateListener);
        }
        this.fPlan = null;
        this.fAssignActionFactory = null;
        if (newInput instanceof ResolvedPersonalPlan) {
            this.fPlan = (ResolvedPersonalPlan)newInput;
            this.fPlan.addListener((IPlanElementListener)this.fUpdateListener);
            this.fAssignActionFactory = new AssignActionFactory(this.fSite, this.fViewModel);
        }
    }

    public Action getAction(String id) {
        return this.fActions.get(id);
    }

    public Action[] getActions() {
        Collection<Action> values = this.fActions.values();
        return values.toArray(new Action[values.size()]);
    }

    private void initAction(PlanViewModelAction<?> action, String id) {
        this.fSelectionProvider.addSelectionChangedListener(action);
        action.setActionDefinitionId(id);
        action.setId(id);
        action.update();
        if (id != null) {
            this.fActions.put(id, action);
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        IMenuManager addItemMenu;
        super.fillContextMenu(menu);
        this.addAction(menu, this.fOpenAbsenceAction, "group.open");
        this.addAction(menu, this.fOpenPlanItemAction, "group.open");
        this.addAction(menu, this.fShowDetailsAction, "group.open");
        this.addAction(menu, this.fShowNewsAction, "group.open");
        this.addAction(menu, this.fRevertPlanItemAction, "group.open");
        this.addAction(menu, this.fDeleteDraftItemAction, "group.open");
        if (this.fSection instanceof SectionCurrentWork || this.fSection instanceof SectionMyFuturePastWork) {
            this.addAction(menu, this.fExpandPlanningToolsAction, "group.schedule");
        }
        if (this.fAssignActionFactory != null) {
            this.addAction(menu, this.fAcceptWorkAction, "group.schedule");
            menu.appendToGroup("group.schedule", (IContributionItem)this.fAssignActionFactory.getPlanningMenu());
            menu.appendToGroup("group.schedule", (IContributionItem)this.fAssignActionFactory.getAssignCategoryMenu());
            menu.appendToGroup("group.schedule", (IContributionItem)this.fAssignActionFactory.getAssignTagMenu());
        }
        if (this.fWorkItemSelectionAction != null && (addItemMenu = this.fWorkItemSelectionAction.buildContextMenu(menu)) != null) {
            menu.appendToGroup("group.edit", (IContributionItem)addItemMenu);
        }
        this.addAction(menu, this.fMovePlanItemUpAction, "group.edit");
        this.addAction(menu, this.fMovePlanItemDownAction, "group.edit");
    }

    private int addAction(IMenuManager menu, PlanViewModelAction<?> action, String groupName) {
        action.update();
        if (!action.isEnabled()) {
            return 0;
        }
        menu.appendToGroup(groupName, action);
        return 1;
    }

    public void dispose() {
        super.dispose();
        if (this.fPlan != null) {
            this.fPlan.removeListener((IPlanElementListener)this.fUpdateListener);
        }
        for (Action action : this.fActions.values()) {
            if (!(action instanceof ISelectionChangedListener)) continue;
            this.disposeAction((ISelectionChangedListener)action);
        }
        if (this.fHandlerService != null) {
            this.fWorkItemSelectionAction.deactivate(this.fHandlerService);
        }
    }

    private void disposeAction(ISelectionChangedListener action) {
        if (action != null) {
            this.fSelectionProvider.removeSelectionChangedListener(action);
        }
        if (this.fHandlerService != null && this.fWorkItemSelectionAction != null) {
            this.fWorkItemSelectionAction.deactivate(this.fHandlerService);
        }
    }

    private class UpdateListener
    implements IPlanElementListener {
        private UpdateListener() {
        }

        public void planElementChanged(IPlanElementChangeEvent event) {
            event.getDelta().accept(new IPlanElementDeltaVisitor(){

                public boolean visit(IPlanElementDelta delta) {
                    if (delta.isChanged() && delta.getAttributeDelta(PlanItem.SEQUENCE_VALUE) != null) {
                        MyWorkActionGroup.this.fSite.getShell().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                MyWorkActionGroup.this.fMovePlanItemUpAction.update();
                                MyWorkActionGroup.this.fMovePlanItemDownAction.update();
                            }
                        });
                        return false;
                    }
                    return true;
                }
            });
        }
    }
}

