/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.mywork;

import com.ibm.team.apt.internal.client.Attribute;
import com.ibm.team.apt.internal.client.IScheduleItem;
import com.ibm.team.apt.internal.client.OutOfOfficeItem;
import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.ResolvedPersonalPlan;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.common.Timespan;
import com.ibm.team.apt.internal.common.util.ItemSet;
import com.ibm.team.apt.internal.ide.ui.common.MessageElement;
import com.ibm.team.apt.internal.ide.ui.common.PlanViewModel;
import com.ibm.team.apt.internal.ide.ui.common.model.IOutlineModelUpdater;
import com.ibm.team.apt.internal.ide.ui.common.model.ModelUpdateRunnable;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineEntry;
import com.ibm.team.apt.internal.ide.ui.common.structure.CommonGroupBySequenceDescription;
import com.ibm.team.apt.internal.ide.ui.common.structure.GroupElement;
import com.ibm.team.apt.internal.ide.ui.common.structure.ItemMovePolicy;
import com.ibm.team.apt.internal.ide.ui.common.structure.PlanModelSequenceTransformer;
import com.ibm.team.apt.internal.ide.ui.common.structure.PlanModelTransformer;
import com.ibm.team.apt.internal.ide.ui.common.structure.SequenceItemMovePolicy;
import com.ibm.team.apt.internal.ide.ui.common.structure.SortMode;
import com.ibm.team.apt.internal.ide.ui.common.structure.TimeElement;
import com.ibm.team.apt.internal.ide.ui.common.structure.TimeSpanFactory;
import com.ibm.team.apt.internal.ide.ui.mywork.Messages;
import com.ibm.team.apt.internal.ide.ui.mywork.MyWorkOutlineItem;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineItem;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupByMyCurrentWorkSequenceDescription
extends CommonGroupBySequenceDescription {
    private static final List<SortMode> DEFAULT_SORT_MODES = Collections.unmodifiableList(Arrays.asList(SortMode.PRIORITY, SortMode.MODIFIED_DATE));

    public GroupByMyCurrentWorkSequenceDescription() {
        super(Messages.GroupByMyCurrentWorkSequenceDescription_LABEL);
    }

    @Override
    protected PlanModelTransformer createModelTransformer(TimeSpanFactory timeSpanFactory) {
        return new CurrentWorkGroupingTransformer(timeSpanFactory);
    }

    @Override
    protected ItemMovePolicy createItemMovePolicy() {
        return new SequenceItemMovePolicy(){

            protected void itemAdded(PlanItem newPlanItem, OutlineItem newOutlineItem) {
                if (newOutlineItem instanceof MyWorkOutlineItem) {
                    ((MyWorkOutlineItem)newOutlineItem).setShowDetails(true);
                }
                IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                WorkItemUI.open((IWorkbenchPage)activePage, (Object)newPlanItem.getWorkItemHandle());
            }
        };
    }

    @Override
    public List<SortMode> getSortModes() {
        return DEFAULT_SORT_MODES;
    }

    @Override
    public SortMode getDefaultSortMode() {
        return SortMode.PRIORITY;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CurrentWorkGroupingTransformer
    extends PlanModelSequenceTransformer {
        private final MessageElement fNoCurrentWorkMessage = new MessageElement(Messages.GroupByMyCurrentWorkSequenceDescription_MSG_NO_WORK);
        private final NoCurrentWorkMessageManager fNoCurrentWorkMessageManager = new NoCurrentWorkMessageManager();
        private ItemSet<IIteration> fPlannedIntervals;
        private TimeElement fCurrentWorkGroupElement;

        public CurrentWorkGroupingTransformer(TimeSpanFactory timeSpanFactory) {
            super(timeSpanFactory, (Collection<Attribute>)Arrays.asList(IScheduleItem.SCHEDULED_TIME, IScheduleItem.RESOLVED, IScheduleItem.SEQUENCE_VALUE, IScheduleItem.FIXEDSTARTDATE));
        }

        @Override
        public void inputChanged(PlanViewModel newModel, ResolvedPlan newInput) {
            PlanViewModel oldModel = this.getViewModel();
            if (oldModel != null) {
                oldModel.removePostUpdateRunnable(this.fNoCurrentWorkMessageManager, true);
            }
            if (newModel != null) {
                newModel.addPostUpdateRunnable(this.fNoCurrentWorkMessageManager, true);
            }
            super.inputChanged(newModel, newInput);
        }

        @Override
        protected void onBeginRefresh() {
            ResolvedPersonalPlan plan = (ResolvedPersonalPlan)this.getPlan();
            if (plan != null) {
                Date workStart = plan.getItemSequenceManager().getWorkStart();
                this.fCurrentWorkGroupElement = new TimeElement(this.getPlanOwner(), this.findTimeSpan(new Timespan(workStart, workStart), false));
                this.fPlannedIntervals = plan.getPlannedIterations();
            } else {
                this.fPlannedIntervals = null;
            }
            super.onBeginRefresh();
        }

        protected Collection<PlanElement> getAllPlanElements() {
            ArrayList<PlanElement> result = new ArrayList<PlanElement>(super.getAllPlanElements());
            for (IScheduleItem fixScheduledItem : ((ResolvedPersonalPlan)this.getPlan()).getItemSequenceManager().getAbsences()) {
                if (!(fixScheduledItem instanceof PlanElement)) continue;
                result.add((PlanElement)fixScheduledItem);
            }
            return result;
        }

        @Override
        protected boolean isElementIncluded(PlanElement element) {
            if (!super.isElementIncluded(element)) {
                return false;
            }
            if (element instanceof PlanItem) {
                PlanItem item = (PlanItem)element;
                IIteration target = item.getTarget();
                return target != null && this.fPlannedIntervals != null && this.fPlannedIntervals.contains((Object)target) && !item.isNewItem() && !item.isAuxiliaryPlanItem();
            }
            return element instanceof OutOfOfficeItem;
        }

        @Override
        protected Collection<GroupElement[]> getGroups(List<PlanModelTransformer.ElementInfo> elementInfoPath) {
            Assert.isTrue((elementInfoPath.size() >= 1 ? 1 : 0) != 0);
            Object[] structureValues = elementInfoPath.get(0).getStructureValues();
            Timespan scheduledTime = (Timespan)structureValues[0];
            boolean isResolved = (Boolean)structureValues[1];
            return Collections.singleton(new GroupElement[]{new TimeElement(this.getPlanOwner(), this.findTimeSpan(scheduledTime, isResolved))});
        }

        private IContributor getPlanOwner() {
            return ((ResolvedPersonalPlan)this.getPlan()).getPlanOwner();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class NoCurrentWorkMessageManager
        implements ModelUpdateRunnable<Void, RuntimeException> {
            private NoCurrentWorkMessageManager() {
            }

            @Override
            public Void run(IOutlineModelUpdater updateAccessor) {
                OutlineEntry groupEntry = this.getFirstEntry(updateAccessor.getElementEntries(CurrentWorkGroupingTransformer.this.fCurrentWorkGroupElement));
                if (groupEntry == null) {
                    updateAccessor.addEntry(new Object[]{CurrentWorkGroupingTransformer.this.fCurrentWorkGroupElement}, CurrentWorkGroupingTransformer.this.fNoCurrentWorkMessage);
                    final OutlineEntry toExpand = this.getFirstEntry(updateAccessor.getElementEntries(CurrentWorkGroupingTransformer.this.fCurrentWorkGroupElement));
                    final PlanViewModel viewModel = CurrentWorkGroupingTransformer.this.getViewModel();
                    if (toExpand != null) {
                        updateAccessor.executeAfterUpdate(new Runnable(){

                            public void run() {
                                viewModel.setEntryExpandState(toExpand, true);
                            }
                        });
                    }
                } else {
                    OutlineEntry messageEntry = this.getFirstEntry(updateAccessor.getElementEntries(CurrentWorkGroupingTransformer.this.fNoCurrentWorkMessage));
                    List<OutlineEntry<?>> currentWorkEntries = updateAccessor.getChildren(groupEntry);
                    if (currentWorkEntries.size() > 1 && messageEntry != null) {
                        updateAccessor.removeEntry(messageEntry);
                    }
                }
                return null;
            }

            private <T> OutlineEntry<T> getFirstEntry(Collection<OutlineEntry<T>> entries) {
                Iterator<OutlineEntry<T>> iterator = entries.iterator();
                return iterator.hasNext() ? iterator.next() : null;
            }
        }
    }
}

