/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.mywork;

import com.ibm.team.apt.internal.ide.ui.common.gadgets.GStatusLineItem;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.CompositeGadget;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Gadget;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.graphics.Point;

public class GColumnBox
extends CompositeGadget {
    private boolean fEnabled;
    private int fHorizontalSpacing = 2;
    private int fVerticalSpacing = 2;

    protected GColumnBox(CompositeGadget parent) {
        super(parent);
    }

    public boolean isEnabled() {
        return this.fEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.fEnabled = enabled;
        Gadget[] gadgetArray = this.fChildren;
        int n = this.fChildren.length;
        int n2 = 0;
        while (n2 < n) {
            Gadget child = gadgetArray[n2];
            GStatusLineItem item = (GStatusLineItem)child;
            item.setEnabled(enabled);
            ++n2;
        }
    }

    public void setHorizontalSpacing(int horizontalSpacing) {
        this.fHorizontalSpacing = horizontalSpacing;
    }

    public void setVerticalSpacing(int verticalSpacing) {
        this.fVerticalSpacing = verticalSpacing;
    }

    public int computeMinimalWidth() {
        this.verifyChildCount();
        return this.computeCompleteWidth(this.computeColumnWidths(true));
    }

    protected Point arrangeContent(int x, int y, int wHint, int hHint) {
        this.verifyChildCount();
        int[] columnWidths = this.computeColumnWidths(false);
        int completeWidth = this.computeCompleteWidth(columnWidths);
        if (wHint != -1 && wHint < completeWidth) {
            columnWidths = this.computeColumnWidths(true);
            completeWidth = this.computeCompleteWidth(columnWidths);
        }
        if (wHint != -1) {
            int correction = 2 * (wHint - completeWidth) / columnWidths.length;
            int i = 1;
            while (i < columnWidths.length) {
                int n = i;
                columnWidths[n] = columnWidths[n] + correction;
                completeWidth += correction;
                i += 2;
            }
        }
        int currentY = y;
        int rowHeight = 0;
        int currentX = x;
        int i = 0;
        while (i < this.fChildren.length) {
            int column = i % columnWidths.length;
            if (column == 0) {
                currentY += rowHeight + this.fVerticalSpacing;
                currentX = x;
            }
            int columnWidth = columnWidths[column];
            Gadget child = this.fChildren[i];
            child.layout(currentX, currentY, columnWidth, -1);
            rowHeight = this.max(child.getHeight(), rowHeight);
            currentX += columnWidth + this.fHorizontalSpacing;
            ++i;
        }
        return new Point(completeWidth, this.max(currentY - y + rowHeight - this.fVerticalSpacing, 0));
    }

    private int[] computeColumnWidths(boolean singleColumn) {
        this.verifyChildCount();
        int columnCount = singleColumn ? 2 : 4;
        int[] result = new int[columnCount];
        int rows = (int)Math.ceil((double)this.fChildren.length / (double)columnCount);
        int i = 0;
        while (i < columnCount) {
            int columnWidth = 0;
            int j = 0;
            while (j < rows) {
                if (j * columnCount + i < this.fChildren.length) {
                    Gadget element = this.fChildren[j * columnCount + i];
                    columnWidth = this.max(element.computeMinimalWidth(), columnWidth);
                }
                ++j;
            }
            result[i] = columnWidth;
            ++i;
        }
        return result;
    }

    private int computeCompleteWidth(int[] columnWidths) {
        int result = 0;
        int[] nArray = columnWidths;
        int n = columnWidths.length;
        int n2 = 0;
        while (n2 < n) {
            int columnWidth = nArray[n2];
            result += columnWidth + this.fHorizontalSpacing;
            ++n2;
        }
        return this.max(result - this.fHorizontalSpacing, 0);
    }

    private void verifyChildCount() {
        Assert.isTrue((this.fChildren.length % 2 == 0 ? 1 : 0) != 0);
    }
}

