/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.mywork;

import com.ibm.team.apt.internal.ide.ui.util.GCState;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.CompositeGadget;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GLabel;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.IEventHandler;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.IGadgetEditor;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Outline;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineResources;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;

public abstract class GAbstractLabelButton
extends CompositeGadget {
    private boolean fEnabled = true;
    private Image fImage = null;
    private String fLabel = null;
    private IAction fAction = null;
    protected GLabel fLabelGadget = null;
    private int fLabelWidth = -1;
    private boolean fDrawRollover = false;
    private int fStyle;

    public GAbstractLabelButton(CompositeGadget parent) {
        this(parent, null, null, 0x1000000);
    }

    public GAbstractLabelButton(CompositeGadget parent, Image image, String label) {
        this(parent, image, label, 0x1000000);
    }

    public GAbstractLabelButton(CompositeGadget parent, Image image, String label, int style) {
        super(parent);
        this.fImage = image;
        this.fLabel = label;
        this.fStyle = style;
        this.fEnabled = true;
        this.fLabelGadget = new GLabel(this, this.fLabel, 0);
    }

    public void dispose() {
        if (this.fAction != null && this.fAction.getMenuCreator() != null) {
            this.fAction.getMenuCreator().dispose();
        }
        super.dispose();
    }

    public Image getImage() {
        return this.fImage;
    }

    public void setImage(Image image) {
        this.fImage = image;
    }

    public String getLabel() {
        return this.fLabel;
    }

    public void setLabel(String label) {
        this.fLabel = label;
        this.fLabelGadget.setText(label);
    }

    public void setAction(IAction action) {
        this.fAction = action;
    }

    public boolean isEnabled() {
        return this.fEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.fEnabled = enabled;
    }

    public void setLabelWidth(int labelWidth) {
        this.fLabelWidth = labelWidth;
    }

    public int getLabelWidth() {
        return this.fLabelWidth;
    }

    public void setColor(Color color) {
        this.fLabelGadget.setColor(color);
    }

    public void setReturnParentElement(boolean value) {
        super.setReturnParentElement(value);
        this.fLabelGadget.setReturnParentElement(value);
    }

    public int computeMinimalWidth() {
        OutlineResources resources = this.getOutlineResources();
        int width = 2 * resources.getSpaceWidth();
        if (this.fImage != null) {
            width += this.fImage.getBounds().width;
            width += resources.getSpaceWidth();
        }
        return width += this.max(this.fLabelGadget.computeMinimalWidth(), this.fLabelWidth);
    }

    protected Point arrangeContent(int x, int y, int wHint, int hHint) {
        OutlineResources resources = this.getOutlineResources();
        int tx = x + resources.getSpaceWidth();
        if (this.fImage != null) {
            tx += this.fImage.getBounds().width;
            tx += resources.getSpaceWidth();
        }
        this.fLabelGadget.layout(tx, y, -1, -1);
        tx += this.max(this.fLabelGadget.getWidth(), this.fLabelWidth);
        int height = this.max(this.fImage != null ? this.fImage.getBounds().height : 0, this.fLabelGadget.getHeight());
        if ((this.fStyle & 0x1000000) == 0x1000000) {
            this.fLabelGadget.move(0, (height - this.fLabelGadget.getHeight()) / 2);
        }
        return new Point(this.max(wHint, (tx += resources.getSpaceWidth()) - x), height);
    }

    public void paint(GC gc, OutlineResources resources) {
        Rectangle view = this.getTransformation().toViewPort(this.fBounds);
        if (this.fEnabled && this.fDrawRollover) {
            Color color = gc.getBackground();
            int antialias = gc.getAntialias();
            gc.setAntialias(1);
            gc.setBackground(this.getOutlineResources().getHoverHightlightColor());
            gc.fillRoundRectangle(view.x, view.y, view.width, view.height, 5, 5);
            gc.setBackground(color);
            gc.setAntialias(antialias);
        }
        if (this.fImage != null) {
            int y = view.y;
            if ((this.fStyle & 0x1000000) == 0x1000000) {
                y += (this.getBounds().height - this.fImage.getBounds().height) / 2;
            }
            gc.drawImage(this.getImage(), view.x, y);
        }
        super.paint(gc, resources);
        if (this.fImage != null && this.hasDropdown() && this.isEnabled() && (this.fDrawRollover || GAbstractLabelButton.hasStyle(this.getShell().getSelectionMode(), 1))) {
            GCState state = GCState.save(gc, 8);
            try {
                int startX = view.x + this.fImage.getBounds().width - 7;
                int startY = view.y + 6;
                int width = 7;
                int centerX = 4;
                int height = 5;
                gc.setBackground(gc.getDevice().getSystemColor(1));
                gc.fillPolygon(new int[]{startX, startY, startX + width, startY, startX + width, startY + 1, startX + centerX, startY + height, startX, startY + 1});
                gc.setBackground(resources.getDropDownTriangleColor());
                gc.fillPolygon(new int[]{startX + 1, startY + 1, startX + width - 1, startY + 1, startX + centerX, startY + height - 1});
            }
            finally {
                state.restore();
            }
            if (resources.debugLayout) {
                gc.drawRectangle(view.x, view.y, view.width - 1, view.height - 1);
            }
        }
    }

    protected void handleMouseEnter(IEventHandler receiver, MouseEvent e) {
        if (!this.fEnabled) {
            return;
        }
        this.fDrawRollover = true;
        this.redraw(false);
    }

    protected void handleMouseExit(IEventHandler handler, MouseEvent e) {
        if (!this.fEnabled) {
            return;
        }
        this.fDrawRollover = false;
        this.redraw(false);
    }

    protected IGadgetEditor handleMouseDown(IEventHandler receiver, MouseEvent e) {
        if (!this.fEnabled || this.fAction == null || e.button != 1) {
            return null;
        }
        Outline outline = this.getOutline();
        outline.setSelection(this.getOutlineItem());
        if (this.hasDropdown()) {
            Menu menu = this.fAction.getMenuCreator().getMenu((Control)outline);
            Rectangle viewBounds = this.getTransformation().toViewPort(this.getBounds());
            Point p = outline.toDisplay(new Point(viewBounds.x, viewBounds.y + viewBounds.height));
            menu.setLocation(p.x, p.y);
            menu.setVisible(true);
            Display display = outline.getDisplay();
            while (!menu.isDisposed() && menu.isVisible()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            if (!menu.isDisposed()) {
                menu.dispose();
            }
        } else {
            this.fAction.run();
        }
        return null;
    }

    protected void stop(IEventHandler receiver) {
        super.stop(receiver);
        if (this.fDrawRollover) {
            this.fDrawRollover = false;
            this.redraw(false);
        }
    }

    private boolean hasDropdown() {
        return this.fAction != null && this.fAction.getStyle() == 4;
    }
}

