/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.mywork;

import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.ide.ui.actions.PlanViewModelAction;
import com.ibm.team.apt.internal.ide.ui.common.PlanViewModel;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryUtils;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineEntry;
import com.ibm.team.apt.internal.ide.ui.mywork.Messages;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.util.NLS;
import java.util.Collection;
import org.eclipse.ui.IWorkbenchSite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceptWorkAction
extends PlanViewModelAction<PlanItem> {
    protected AcceptWorkAction(IWorkbenchSite site, PlanViewModel planViewModel) {
        super(site, planViewModel, PlanItem.class, ONE_OR_MORE);
        this.setText(Messages.AcceptWorkAction_LABEL);
    }

    @Override
    protected boolean checkElement(OutlineEntry<PlanItem> selectedEntry) {
        return selectedEntry.getElement().isNewItem();
    }

    @Override
    protected void updateAction(Collection<OutlineEntry<PlanItem>> selectedEntries) {
        IIterationHandle referenceTargetHandle = ((PlanItem)EntryUtils.firstElement(selectedEntries)).getTargetHandle();
        boolean singleTarget = true;
        for (OutlineEntry entry : selectedEntries) {
            IIterationHandle itemTarget = ((PlanItem)entry.getElement()).getTargetHandle();
            if ((referenceTargetHandle != null || itemTarget == null) && (referenceTargetHandle == null || referenceTargetHandle.sameItemId((IItemHandle)itemTarget))) continue;
            singleTarget = false;
            break;
        }
        String label = null;
        if (singleTarget) {
            if (referenceTargetHandle == null) {
                label = Messages.AcceptWorkAction_LABEL_UNPLANNED;
            } else {
                IIteration referenceTarget = ((ResolvedPlan)this.getPlanViewModel().getInput()).getResolvedIteration(referenceTargetHandle);
                if (referenceTarget != null) {
                    label = NLS.bind((String)Messages.AcceptWorkAction_LABEL_SPECIFIC, (Object[])new Object[]{referenceTarget.getLabel()});
                }
            }
        }
        if (label == null) {
            label = Messages.AcceptWorkAction_LABEL;
        }
        this.setText(label);
    }

    @Override
    public void run(Collection<OutlineEntry<PlanItem>> selectedEntries) {
        for (OutlineEntry outlineEntry : selectedEntries) {
            PlanItem item = (PlanItem)outlineEntry.getElement();
            item.markAsNewItem(false);
            item.markRead();
        }
        this.getPlanViewModel().setSelectedElements(EntryUtils.elements(selectedEntries));
    }
}

