/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.mywork;

import com.ibm.team.apt.internal.client.IPlanElementChangeEvent;
import com.ibm.team.apt.internal.client.IPlanElementDelta;
import com.ibm.team.apt.internal.client.IPlanElementDeltaVisitor;
import com.ibm.team.apt.internal.client.IPlanElementListener;
import com.ibm.team.apt.internal.client.ResolvedPersonalPlan;
import com.ibm.team.apt.internal.ide.ui.actions.IActionProvider;
import com.ibm.team.apt.internal.ide.ui.mywork.MyWorkView;
import com.ibm.team.apt.internal.ide.ui.mywork.MyWorkViewListener;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.dashboard.ISectionListener;
import com.ibm.team.jface.dashboard.ISectionSite;
import com.ibm.team.jface.dashboard.Section;
import com.ibm.team.jface.dashboard.SectionLabel;
import com.ibm.team.jface.internal.dashboard.views.SectionPart;
import java.text.MessageFormat;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IMemento;

public abstract class AbstractPlanSection
extends Section
implements ISectionListener,
IActionProvider {
    private static final int DEFAULT_SECTION_HEIGHT = 192;
    private volatile boolean fIsDisposed = false;
    private boolean fIsExpanded;
    private SectionLabel fTeaserLabel;
    private SectionLabel fProjectAreaLabel;
    private final String fContextId;
    private MyWorkView fMyWorkView;
    private ViewListener fViewListener;
    private ResolvedPersonalPlan fPlan;
    private IPlanElementListener fPlanListener;

    public AbstractPlanSection(String contextId) {
        this.fContextId = contextId;
        this.fPlanListener = new PlanListener();
    }

    public String getContextId() {
        return this.fContextId;
    }

    public boolean isExpanded() {
        return this.fIsExpanded;
    }

    public ResolvedPersonalPlan getPlan() {
        return this.fPlan;
    }

    protected MyWorkView getPersonalPlanService() {
        return this.fMyWorkView;
    }

    protected Composite getHeaderComposite() {
        if (this.fTeaserLabel == null) {
            return null;
        }
        return this.fTeaserLabel.getParent();
    }

    protected boolean isDisposed() {
        return this.fIsDisposed;
    }

    public Point getDefaultContentSize() {
        return new Point(-1, 192);
    }

    protected abstract void onInit(IMemento var1);

    protected abstract void onInputChanged(ResolvedPersonalPlan var1, ResolvedPersonalPlan var2);

    protected abstract void onUpdateSectionHeader(SectionLabel var1);

    protected boolean onPlanElementChanged(IPlanElementDelta delta) {
        return true;
    }

    protected abstract void onDispose();

    protected void onSectionActivate() {
        this.fMyWorkView.notifyPlanSectionActivated(this);
    }

    protected void onSectionDeactivate() {
        this.fMyWorkView.notifyPlanSectionDeactivated(this);
    }

    public void init(ISectionSite sectionSite, IMemento memento) {
        super.init(sectionSite, memento);
        sectionSite.addSectionListener((ISectionListener)this);
        this.fMyWorkView = (MyWorkView)sectionSite.getViewSite().getPart();
        this.fViewListener = new ViewListener();
        this.fMyWorkView.addViewListener(this.fViewListener);
        this.onInit(memento);
    }

    public void dispose() {
        this.fIsDisposed = true;
        this.setInput(null);
        this.onDispose();
        this.getSectionSite().removeSectionListener((ISectionListener)this);
        if (this.fViewListener != null) {
            this.fMyWorkView.removeViewListener(this.fViewListener);
            this.fViewListener = null;
        }
        super.dispose();
    }

    public void createTeaser(Composite parent) {
        GridLayoutFactory.fillDefaults().numColumns(3).margins(1, 0).spacing(4, 5).applyTo(parent);
        parent.getParent().getChildren()[0].setLayoutData((Object)new GridData(4, 4, false, true));
        LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        Color textColor = JazzResources.getColor((ResourceManager)resourceManager, (RGB)new RGB(80, 80, 80));
        this.fProjectAreaLabel = new SectionLabel(parent, 0);
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, true).indent(4, 0).applyTo((Control)this.fProjectAreaLabel);
        this.fProjectAreaLabel.setBackground(parent.getBackground());
        this.fProjectAreaLabel.setForeground(textColor);
        this.fTeaserLabel = new SectionLabel(parent, 131072);
        this.fTeaserLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, true));
        this.fTeaserLabel.setBackground(parent.getBackground());
        this.fTeaserLabel.setForeground(textColor);
        Font defaultFont = JFaceResources.getDefaultFont();
        FontData[] fontData = defaultFont.getFontData();
        int i = 0;
        while (i < fontData.length) {
            fontData[i].setHeight(fontData[i].getHeight() - 1);
            ++i;
        }
        this.fTeaserLabel.setFont(JazzResources.getFont((ResourceManager)resourceManager, (FontDescriptor)FontDescriptor.createFrom((FontData[])fontData), (Font)defaultFont));
        this.updateSectionName();
        this.updateSectionHeader();
        this.getSectionSite().setContext(this.getContextId());
        this.registerFocusHandler(parent);
    }

    public void sectionCollapsed() {
        this.fIsExpanded = false;
        this.updateSectionHeader();
    }

    public void sectionExpanded() {
        this.fIsExpanded = true;
        this.updateSectionHeader();
    }

    public void sectionMaximized(boolean isContentClipped) {
    }

    public void sectionOpened() {
    }

    public void sectionResized() {
    }

    private void registerFocusHandler(Composite candidate) {
        while (candidate != null) {
            if (candidate instanceof SectionPart) {
                candidate.addListener(26, new Listener(){

                    public void handleEvent(Event event) {
                        AbstractPlanSection.this.onSectionActivate();
                    }
                });
                candidate.addListener(27, new Listener(){

                    public void handleEvent(Event event) {
                        AbstractPlanSection.this.onSectionDeactivate();
                    }
                });
                break;
            }
            candidate = candidate.getParent();
        }
    }

    protected void runInUI(final Runnable code) {
        Display dispaly;
        Display display = dispaly = !this.fTeaserLabel.isDisposed() ? this.fTeaserLabel.getDisplay() : null;
        if (!this.fIsDisposed && !dispaly.isDisposed()) {
            dispaly.asyncExec(new Runnable(){

                public void run() {
                    if (!AbstractPlanSection.this.fIsDisposed && !dispaly.isDisposed()) {
                        code.run();
                    }
                }
            });
        }
    }

    protected void updateSectionHeader() {
        this.runInUI(new Runnable(){

            public void run() {
                AbstractPlanSection.this.onUpdateSectionHeader(AbstractPlanSection.this.fTeaserLabel);
                AbstractPlanSection.this.getSectionSite().layoutTeaser();
            }
        });
    }

    private void setInput(ResolvedPersonalPlan resolvedPlan) {
        ResolvedPersonalPlan oldInput = this.fPlan;
        if (this.fPlan != null) {
            this.fPlan.removeListener(this.fPlanListener);
        }
        this.fPlan = resolvedPlan;
        if (this.fPlan != null) {
            this.fPlan.addListener(this.fPlanListener);
        }
        this.updateSectionName();
        this.onInputChanged(oldInput, this.fPlan);
    }

    private void updateSectionName() {
        this.runInUI(new Runnable(){

            public void run() {
                String projectAreaLabel = "";
                if (AbstractPlanSection.this.fPlan != null) {
                    projectAreaLabel = MessageFormat.format("({0})", AbstractPlanSection.this.fPlan.getProjectArea().getName());
                }
                AbstractPlanSection.this.fProjectAreaLabel.setText(projectAreaLabel);
            }
        });
    }

    private class PlanListener
    implements IPlanElementListener {
        private PlanListener() {
        }

        public void planElementChanged(IPlanElementChangeEvent event) {
            IPlanElementDelta delta = event.getDelta();
            delta.accept(new IPlanElementDeltaVisitor(){

                public boolean visit(IPlanElementDelta delta) {
                    return AbstractPlanSection.this.onPlanElementChanged(delta);
                }
            });
        }
    }

    private class ViewListener
    implements MyWorkViewListener {
        private ViewListener() {
        }

        public void inputChanged(ResolvedPersonalPlan oldInput, ResolvedPersonalPlan newInput) {
            AbstractPlanSection.this.setInput(newInput);
        }
    }
}

