/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.wiki.compare;

import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.wiki.ResolvedWikiPage;
import com.ibm.team.apt.internal.client.wiki.WikiClient;
import com.ibm.team.apt.internal.common.wiki.IWikiPage;
import com.ibm.team.apt.internal.common.wiki.IWikiPageHandle;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.WikiDocument;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.compare.Messages;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.compare.WikiMergeViewer;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.repository.client.IContentManager;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.compare.BufferedContent;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.IPropertyChangeNotifier;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class WikiCompareEditorInput
extends CompareEditorInput {
    private final WikiDocument fDocument;
    private final ResolvedWikiPage fPage;
    private CompareObject fLeft;
    private IWikiPage fLatest;
    private Viewer fViewer;
    private IPropertyChangeListener fDirtyStateListener;
    private boolean fDirty;
    private Object fDifference;

    public WikiCompareEditorInput(WikiDocument document) {
        super(WikiCompareEditorInput.createDefaultConfiguration());
        Assert.isNotNull((Object)((Object)document));
        this.fDocument = document;
        this.fPage = document.getPage();
        this.fDirtyStateListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                String propertyName = e.getProperty();
                if ("DIRTY_STATE".equals(propertyName)) {
                    boolean changed = false;
                    Object newValue = e.getNewValue();
                    if (newValue instanceof Boolean) {
                        changed = (Boolean)newValue;
                        WikiCompareEditorInput.this.fDirty = changed;
                        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "DIRTY_STATE", e.getOldValue(), e.getNewValue());
                        WikiCompareEditorInput.this.firePropertyChange(event);
                    }
                }
            }
        };
    }

    public Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        if (this.fDifference != null) {
            return this.fDifference;
        }
        try {
            byte[] bytes;
            monitor.beginTask(Messages.WikiCompareEditorInput_MONITOR_COMPARE_PAGES, 2000);
            ITeamRepository repository = PlanningClientPlugin.getTeamRepository((IItemHandle)this.fPage.getWikiPage());
            IWikiPage latest = WikiCompareEditorInput.fetchPage(repository, this.fPage.getWikiPage(), null, (IProgressMonitor)new SubProgressMonitor(monitor, 250));
            IWikiPage ancestor = WikiCompareEditorInput.fetchPage(repository, this.fPage.getWikiPage(), this.fPage.getWikiPage().getStateId(), (IProgressMonitor)new SubProgressMonitor(monitor, 250));
            this.fLatest = latest;
            try {
                bytes = this.fPage.getContent2().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new InvocationTargetException(e);
            }
            this.fLeft = new CompareObject(bytes){

                public void setContent(final byte[] contents) {
                    super.setContent(contents);
                    if (WikiCompareEditorInput.this.fViewer != null) {
                        UI.syncExec(WikiCompareEditorInput.this.fViewer.getControl(), new Runnable(){

                            public void run() {
                                WikiCompareEditorInput.this.postToDocument(WikiCompareEditorInput.this.fLatest, contents);
                            }
                        });
                    }
                }
            };
            CompareObject ancestorObj = new CompareObject(WikiCompareEditorInput.readContent(repository, ancestor.getContent(), (IProgressMonitor)new SubProgressMonitor(monitor, 250)));
            CompareObject rightObj = new CompareObject(WikiCompareEditorInput.readContent(repository, latest.getContent(), (IProgressMonitor)new SubProgressMonitor(monitor, 250)));
            if (Arrays.equals(this.fLeft.getContent(), rightObj.getContent())) {
                return null;
            }
            IContributor contributor = (IContributor)repository.itemManager().fetchPartialItem((IItemHandle)latest.getModifiedBy(), 0, (Collection)Arrays.asList(IContributor.NAME_PROPERTY), (IProgressMonitor)new SubProgressMonitor(monitor, 250));
            CompareConfiguration configuration = this.getCompareConfiguration();
            configuration.setLeftLabel(NLS.bind((String)Messages.WikiCompareEditorInput_LEFT_LOCAL, (Object[])new Object[]{WikiClient.getLabel((IWikiPage)latest)}));
            configuration.setRightLabel(NLS.bind((String)Messages.WikiCompareEditorInput_RIGHT_SERVER, (Object[])new Object[]{WikiClient.getLabel((IWikiPage)latest), contributor.getName()}));
            this.setTitle(WikiCompareEditorInput.getTitle(this.fPage));
            Object object = this.fDifference = new Differencer().findDifferences(true, (IProgressMonitor)new SubProgressMonitor(monitor, 750), null, (Object)ancestorObj, (Object)this.fLeft, (Object)rightObj);
            return object;
        }
        catch (TeamRepositoryException e) {
            throw new InvocationTargetException(e);
        }
        finally {
            monitor.done();
        }
    }

    protected static String getTitle(ResolvedWikiPage page) {
        return NLS.bind((String)Messages.WikiCompareEditorInput_TITLE, (Object[])new Object[]{WikiClient.getLabel((IWikiPage)page.getWikiPage())});
    }

    private static IWikiPage fetchPage(ITeamRepository repository, IWikiPage page, UUID state, IProgressMonitor monitor) throws TeamRepositoryException {
        IItemManager itemManager = repository.itemManager();
        if (state == null) {
            return (IWikiPage)itemManager.fetchCompleteItem((IItemHandle)page, 1, monitor);
        }
        IWikiPageHandle handle = (IWikiPageHandle)IWikiPage.ITEM_TYPE.createItemHandle(page.getItemId(), state);
        return (IWikiPage)itemManager.fetchCompleteState((IAuditableHandle)handle, monitor);
    }

    protected static byte[] readContent(ITeamRepository repository, IContent content, IProgressMonitor monitor) throws TeamRepositoryException {
        IContentManager manager = repository.contentManager();
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        manager.retrieveContent(content, (OutputStream)outStream, monitor);
        return outStream.toByteArray();
    }

    protected static CompareConfiguration createDefaultConfiguration() {
        CompareConfiguration configuration = new CompareConfiguration();
        configuration.setLeftEditable(true);
        configuration.setRightEditable(false);
        return configuration;
    }

    public Viewer findContentViewer(Viewer oldViewer, ICompareInput input, Composite parent) {
        this.fViewer = new WikiMergeViewer(parent, 0, this.getCompareConfiguration());
        if (this.fViewer != oldViewer && this.fViewer instanceof IPropertyChangeNotifier) {
            final IPropertyChangeNotifier dsp = (IPropertyChangeNotifier)this.fViewer;
            dsp.addPropertyChangeListener(this.fDirtyStateListener);
            Control c = this.fViewer.getControl();
            c.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    dsp.removePropertyChangeListener(WikiCompareEditorInput.this.fDirtyStateListener);
                }
            });
        }
        return this.fViewer;
    }

    private void postToDocument(IWikiPage page, byte[] data) {
        try {
            this.fDocument.set(new String(data, "UTF-8"));
            this.fPage.postSave(page, false);
            this.firePropertyChange(new PropertyChangeEvent((Object)this, "DIRTY_STATE", (Object)this.fDirty, (Object)false));
        }
        catch (UnsupportedEncodingException e) {
            this.fDocument.set(e.getLocalizedMessage());
        }
    }

    public boolean isDirty() {
        return this.fDirty;
    }

    public IWikiPage getLatest() {
        return this.fLatest;
    }

    private class CompareObject
    extends BufferedContent
    implements ITypedElement,
    IEditableContent,
    IEncodedStreamContentAccessor {
        public CompareObject(byte[] data) {
            this.setContent(data);
        }

        public Image getImage() {
            return null;
        }

        public String getName() {
            return WikiCompareEditorInput.this.fPage.getWikiName();
        }

        public String getType() {
            return "txt";
        }

        public boolean isEditable() {
            return true;
        }

        protected InputStream createStream() throws CoreException {
            throw new UnsupportedOperationException();
        }

        public ITypedElement replace(ITypedElement dest, ITypedElement src) {
            throw new UnsupportedOperationException();
        }

        public String getCharset() throws CoreException {
            return "UTF-8";
        }
    }
}

