/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.wiki;

import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.wiki.ResolvedWikiPage;
import com.ibm.team.apt.internal.common.wiki.transformer.IItemReferenceDetector;
import com.ibm.team.apt.internal.common.wiki.transformer.IVariableResolver;
import com.ibm.team.apt.internal.common.wiki.transformer.Transformer;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.editor.ClientReferenceDetector;
import com.ibm.team.apt.internal.ide.ui.editor.DeferredVariableResolver;
import com.ibm.team.apt.internal.ide.ui.editor.StyledWikiDocument;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.WikiDocument;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.WikiPartitionScanner;
import com.ibm.team.jface.tooltip.EditorTooltipSupport;
import com.ibm.team.repository.common.IItemHandle;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.DefaultTextHover;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public final class WikiTextHover
extends DefaultTextHover
implements ITextHoverExtension {
    private Transformer fTransformer;
    private final ISourceViewer fSourceViewer;
    private IInformationControlCreator fInfomationControlCreator;

    public WikiTextHover(ISourceViewer sourceViewer) {
        super(sourceViewer);
        this.fSourceViewer = sourceViewer;
    }

    protected void initTransformer(ResolvedWikiPage page) {
        this.fTransformer = new Transformer();
        this.fTransformer.setItemReferenceDetector((IItemReferenceDetector)new ClientReferenceDetector(page));
        this.fTransformer.setVariableResolver((IVariableResolver)new DeferredVariableResolver(DeferredVariableResolver.Mode.Blocking, PlanningClientPlugin.getTeamRepository((IItemHandle)page.getWikiPage()).itemManager(), null));
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion region) {
        if (!(this.fSourceViewer.getDocument() instanceof WikiDocument)) {
            return null;
        }
        long now = System.currentTimeMillis();
        final StyledWikiDocument document = (StyledWikiDocument)this.fSourceViewer.getDocument();
        if (this.fTransformer == null) {
            this.initTransformer(document.getPage());
        }
        try {
            ITypedRegion partition = document.getPartition(WikiPartitionScanner.Partitions.WIKI_PARTITING, region.getOffset(), true);
            final String[] xhtml = new String[]{this.fTransformer.transform(document.get(partition.getOffset(), partition.getLength()))};
            Display display = this.fSourceViewer.getTextWidget().getDisplay();
            display.syncExec(new Runnable(){

                public void run() {
                    xhtml[0] = document.getStyledDocument(xhtml[0]);
                }
            });
            try {
                Thread.sleep(Math.max(0L, 500L - (System.currentTimeMillis() - now)));
            }
            catch (InterruptedException interruptedException) {}
            return xhtml[0];
        }
        catch (BadLocationException e) {
            PlanningUIPlugin.log(e);
            return null;
        }
        catch (BadPartitioningException e) {
            PlanningUIPlugin.log(e);
            return null;
        }
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (this.fInfomationControlCreator == null) {
            this.fInfomationControlCreator = new IInformationControlCreator(){
                private IInformationControl fInformationControl;

                public IInformationControl createInformationControl(Shell parent) {
                    if (this.fInformationControl == null) {
                        this.fInformationControl = new EditorTooltipSupport(parent, true, false){

                            protected String getMarkup(Object element, boolean isFocus) {
                                if (element instanceof String) {
                                    return (String)element;
                                }
                                return null;
                            }
                        };
                    }
                    return this.fInformationControl;
                }
            };
        }
        return this.fInfomationControlCreator;
    }
}

