/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.wiki;

import com.ibm.team.apt.internal.client.wiki.ResolvedWikiPage;
import com.ibm.team.apt.internal.common.wiki.transformer.Transformer;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.WikiPartitionScanner;
import java.util.EnumSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiDocument
extends Document {
    protected Transformer fTransformer;
    private final ResolvedWikiPage fPage;
    private boolean fIgnoreChanges = false;

    public WikiDocument(ResolvedWikiPage page, Transformer transformer) {
        super(page.getContent2());
        Assert.isNotNull((Object)page);
        Assert.isNotNull((Object)transformer);
        this.fPage = page;
        this.fTransformer = transformer;
        this.addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent event) {
                if (!WikiDocument.this.fIgnoreChanges) {
                    WikiDocument.this.fPage.markAsDirty();
                }
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }
        });
    }

    public ResolvedWikiPage getPage() {
        return this.fPage;
    }

    protected void internalSet(String content) {
        this.fIgnoreChanges = true;
        this.set(content);
        this.fIgnoreChanges = false;
    }

    public String transform() {
        if (this.getLength() == 0) {
            return null;
        }
        try {
            return this.transform(0, this.getLength());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public String transform(int offset, int length) throws BadLocationException {
        return this.transform(offset, length, Transformer.DEFAULT_OPTIONS);
    }

    public String transform(int offset, int length, EnumSet<Transformer.Option> options) throws BadLocationException {
        String wiki = this.get(offset, length);
        return this.fTransformer.transform(wiki, options);
    }

    public String transformLine(int offset) throws BadLocationException {
        IRegion region = this.getLineInformationOfOffset(offset);
        return this.transform(region.getOffset(), region.getLength());
    }

    public String transformPartition(int offset) throws BadLocationException, BadPartitioningException {
        ITypedRegion region = this.getPartition(WikiPartitionScanner.Partitions.WIKI_PARTITING, offset, true);
        return this.transform(region.getOffset(), region.getLength());
    }
}

