/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.wiki;

import com.ibm.team.apt.internal.client.wiki.Attachments;
import com.ibm.team.apt.internal.client.wiki.ResolvedWikiPageAttachment;
import com.ibm.team.apt.internal.common.wiki.transformer.Token;
import com.ibm.team.apt.internal.common.wiki.transformer.Tokens;
import com.ibm.team.apt.internal.common.wiki.transformer.Transformer;
import com.ibm.team.apt.internal.ide.ui.ImagePool;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.Messages;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.WikiDocument;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.WikiPartitionScanner;
import com.ibm.team.repository.common.util.NLS;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiCompletionProcessor
implements IContentAssistProcessor {
    private final ICompletionListener fCompletionListener = new ICompletionListener(){

        public void assistSessionStarted(ContentAssistEvent event) {
            WikiCompletionProcessor.this.fInvocationCount = 0;
        }

        public void assistSessionEnded(ContentAssistEvent event) {
        }

        public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
        }
    };
    private static final String MSG_ATTACHMENT = Messages.WikiCompletionProcessor_SHOW_ATTACHMENT_PROPOSAL_MESSAGE;
    private static final String MSG_DEFAULT = Messages.WikiCompletionProcessor_SHOW_DEFAULT_PROPOSAL_MESSAGE;
    private static final String MSG_COLORS = Messages.WikiCompletionProcessor_SHOW_COLOR_PROPOSAL_MESSAGE;
    private static final String[] STATUS = new String[]{MSG_ATTACHMENT, MSG_COLORS, MSG_DEFAULT};
    private final String fPartition;
    private final ISourceViewer fViewer;
    private final Transformer fTransformer;
    private final ResourceManager fResources;
    private Map<Token, Image> fImageMap = new HashMap<Token, Image>();
    private Image fImgAttachment;
    private final ContentAssistant fAssistent;
    private int fInvocationCount;

    public WikiCompletionProcessor(ContentAssistant assistent, ISourceViewer viewer, ResourceManager resources, WikiPartitionScanner.Partitions partition) {
        this.fAssistent = assistent;
        this.fAssistent.addCompletionListener(this.fCompletionListener);
        this.fViewer = viewer;
        this.fResources = resources;
        this.fPartition = partition.id;
        this.fTransformer = new Transformer();
        this.createResources();
    }

    protected void createResources() {
        Image image = this.fResources.createImage(ImagePool.LIST_BULLETED);
        this.fImageMap.put(Token.BULLET_1, image);
        this.fImageMap.put(Token.BULLET_2, image);
        this.fImageMap.put(Token.BULLET_3, image);
        this.fImageMap.put(Token.BULLET_4, image);
        this.fImageMap.put(Token.BULLET_5, image);
        image = this.fResources.createImage(ImagePool.LIST_NUMBERED);
        this.fImageMap.put(Token.NUMBERED_1, image);
        this.fImageMap.put(Token.NUMBERED_2, image);
        this.fImageMap.put(Token.NUMBERED_3, image);
        this.fImageMap.put(Token.NUMBERED_4, image);
        this.fImageMap.put(Token.NUMBERED_5, image);
        image = this.fResources.createImage(ImagePool.HEADINGS);
        this.fImageMap.put(Token.HEADING_1, image);
        this.fImageMap.put(Token.HEADING_2, image);
        this.fImageMap.put(Token.HEADING_3, image);
        this.fImageMap.put(Token.HEADING_4, image);
        this.fImageMap.put(Token.HEADING_5, image);
        this.fImageMap.put(Token.HEADING_6, image);
        image = this.fResources.createImage(ImagePool.EMPHASIS_BOLD);
        this.fImageMap.put(Token.BOLD, image);
        image = this.fResources.createImage(ImagePool.EMPHASIS_ITALIC);
        this.fImageMap.put(Token.ITALICS, image);
        image = this.fResources.createImage(ImagePool.EMPHASIS_UNDERLINE);
        this.fImageMap.put(Token.UNDERLINE, image);
        image = this.fResources.createImage(ImagePool.EMPHASIS_STRIKEOUT);
        this.fImageMap.put(Token.STRIKE_OUT, image);
        image = this.fResources.createImage(ImagePool.CODE_INLINE);
        this.fImageMap.put(Token.CODE_START, image);
        image = this.fResources.createImage(ImagePool.HLINE);
        this.fImageMap.put(Token.HORIZONTAL_LINE, image);
        this.fImgAttachment = this.fResources.createImage(ImagePool.ADD_ATTACHMENT);
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        LinkedList<TokenBasedProposal> proposals = new LinkedList<TokenBasedProposal>();
        int mode = this.fInvocationCount % STATUS.length;
        this.fAssistent.setStatusMessage(STATUS[mode]);
        switch (mode) {
            case 0: {
                if (WikiPartitionScanner.Partitions.HEADING.id.equals(this.fPartition)) {
                    this.computeProposals(proposals, offset, Tokens.HEADINGS);
                    break;
                }
                if (WikiPartitionScanner.Partitions.BULLET_LIST.id.equals(this.fPartition)) {
                    this.computeBulletProposals(proposals, offset);
                    this.computeNumberedProposals(proposals, offset);
                    this.computeFormatsProposals(proposals, offset);
                    this.computeCodeProposal(proposals, offset);
                    break;
                }
                if (WikiPartitionScanner.Partitions.NUMBERED_LIST.id.equals(this.fPartition)) {
                    this.computeNumberedProposals(proposals, offset);
                    this.computeBulletProposals(proposals, offset);
                    this.computeFormatsProposals(proposals, offset);
                    this.computeCodeProposal(proposals, offset);
                    break;
                }
                this.computeFormatsProposals(proposals, offset);
                this.computeProposals(proposals, offset, Tokens.HEADINGS);
                this.computeBulletProposals(proposals, offset);
                this.computeNumberedProposals(proposals, offset);
                this.computeProposals(proposals, offset, Token.HORIZONTAL_LINE);
                this.computeCodeProposal(proposals, offset);
                break;
            }
            case 1: {
                this.computeAttachmentProposals(proposals, offset);
                break;
            }
            case 2: {
                this.computeForegroundProposals(proposals, offset);
                this.computeBackgroundProposals(proposals, offset);
            }
        }
        ++this.fInvocationCount;
        Collections.sort(proposals);
        return proposals.toArray(new TokenBasedProposal[0]);
    }

    protected void computeBulletProposals(List<TokenBasedProposal> list, int offset) {
        int count = this.countCharAtBeginOfPreviousLine('*', offset);
        Token[] tokens = new Token[Math.min(count + 1, Tokens.BULLET_ITEMS.length)];
        System.arraycopy(Tokens.BULLET_ITEMS, 0, tokens, 0, tokens.length);
        this.computeProposals(list, offset, tokens);
    }

    protected void computeNumberedProposals(List<TokenBasedProposal> list, int offset) {
        int count = this.countCharAtBeginOfPreviousLine('#', offset);
        Token[] tokens = new Token[Math.min(count + 1, Tokens.NUMBERED_ITEMS.length)];
        System.arraycopy(Tokens.NUMBERED_ITEMS, 0, tokens, 0, tokens.length);
        this.computeProposals(list, offset, tokens);
    }

    protected void computeProposals(List<TokenBasedProposal> proposals, int offset, Token ... tokens) {
        String prefix = this.getPrefix(offset);
        if (prefix.length() == 0 && this.offsetInLine(offset) != 0) {
            return;
        }
        Token[] tokenArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            final Token token = tokenArray[n2];
            if (token.wiki.startsWith(prefix)) {
                String replaceStr = String.valueOf(token.wiki) + ' ';
                proposals.add(new TokenBasedProposal(token, replaceStr, offset - prefix.length(), prefix.length(), replaceStr.length()){

                    public String getAdditionalProposalInfo() {
                        return WikiCompletionProcessor.this.computeFormattingsInfo(token, token.wiki, null);
                    }
                });
            }
            ++n2;
        }
    }

    protected void computeFormatsProposals(List<TokenBasedProposal> list, int offset) {
        Token[] formats = new Token[]{Token.BOLD, Token.ITALICS, Token.UNDERLINE, Token.STRIKE_OUT};
        String prefix = this.getPrefix(offset);
        Token[] tokenArray = formats;
        int n = formats.length;
        int n2 = 0;
        while (n2 < n) {
            Token token = tokenArray[n2];
            String replaceStr = String.valueOf(token.wiki) + token.wiki;
            int replaceOffset = offset;
            int replaceLength = 0;
            if (token.wiki.startsWith(prefix)) {
                replaceOffset -= prefix.length();
                replaceLength = prefix.length();
            }
            list.add(new TokenBasedProposal(token, replaceStr, replaceOffset, replaceLength, token.wiki.length()));
            ++n2;
        }
    }

    protected void computeCodeProposal(List<TokenBasedProposal> list, int offset) {
        String prefix = this.getPrefix(offset);
        if (Token.CODE_START.wiki.startsWith(prefix)) {
            final StringBuilder text = new StringBuilder();
            text.append(Token.CODE_START.wiki);
            text.append(Token.CODE_END.wiki);
            list.add(new TokenBasedProposal(Token.CODE_START, text.toString(), offset - prefix.length(), prefix.length(), 3){

                public String getDisplayString() {
                    return text.toString();
                }

                public String getAdditionalProposalInfo() {
                    return WikiCompletionProcessor.this.computeFormattingsInfo(NLS.bind((String)"{0}{1}{0}", (Object[])new Object[]{Token.BOLD.wiki, Messages.WikiCompletionProcessor_UNFORMATTED_TEXT}), Token.CODE_START.wiki, Token.CODE_END.wiki);
                }
            });
        }
    }

    protected void computeForegroundProposals(List<TokenBasedProposal> list, int offset) {
        String prefix = this.getPrefix(offset);
        Token[] tokenArray = Tokens.BASE_COLORS;
        int n = Tokens.BASE_COLORS.length;
        int n2 = 0;
        while (n2 < n) {
            final Token token = tokenArray[n2];
            final String before = String.valueOf(token.wiki) + Token.COLOR.wiki;
            final String after = Token.COLOR.wiki;
            int replaceOffset = offset;
            int replaceLength = 0;
            if (token.wiki.startsWith(prefix)) {
                replaceOffset -= prefix.length();
                replaceLength = prefix.length();
            }
            list.add(new TokenBasedProposal(token, String.valueOf(before) + after, replaceOffset, replaceLength, before.length()){

                public String getDisplayString() {
                    return NLS.bind((String)Messages.WikiCompletionProcessor_FOREGROUND_PROPOSAL, (Object[])new Object[]{Tokens.getDisplayString((Token)token), Token.COLOR.wiki});
                }

                public String getAdditionalProposalInfo() {
                    return WikiCompletionProcessor.this.computeFormattingsInfo(token, before, after);
                }
            });
            ++n2;
        }
    }

    protected void computeBackgroundProposals(List<TokenBasedProposal> list, int offset) {
        String prefix = this.getPrefix(offset);
        Token[] tokenArray = Tokens.BASE_COLORS;
        int n = Tokens.BASE_COLORS.length;
        int n2 = 0;
        while (n2 < n) {
            final Token token = tokenArray[n2];
            final String before = Token.COLOR.wiki;
            final String after = String.valueOf(Token.COLOR.wiki) + token.wiki;
            int colorTokenLength = Token.COLOR.wiki.length();
            String replaceString = String.valueOf(before) + after;
            int cursorOffset = colorTokenLength;
            int replaceOffset = offset;
            int replaceLength = 0;
            if (Token.COLOR.wiki.startsWith(prefix)) {
                replaceOffset -= prefix.length();
                replaceLength = prefix.length();
            } else if (prefix.endsWith(Token.COLOR.wiki)) {
                replaceString = token.wiki;
                cursorOffset = token.wiki.length();
            }
            list.add(new TokenBasedProposal(token, replaceString, replaceOffset, replaceLength, cursorOffset){

                public String getDisplayString() {
                    return NLS.bind((String)Messages.WikiCompletionProcessor_BACKGROUND_PROPOSAL, (Object[])new Object[]{Tokens.getDisplayString((Token)token), Token.COLOR.wiki});
                }

                public String getAdditionalProposalInfo() {
                    return WikiCompletionProcessor.this.computeFormattingsInfo(token, before, after);
                }
            });
            ++n2;
        }
    }

    protected void computeAttachmentProposals(List<TokenBasedProposal> list, int offset) {
        String prefix = this.getPrefix(offset);
        WikiDocument document = (WikiDocument)this.fViewer.getDocument();
        List attachments = document.getPage().getAttachments();
        for (ResolvedWikiPageAttachment attachment : attachments) {
            String name = attachment.getAttachment().getName();
            int len = 0;
            if (name.startsWith(prefix)) {
                len = prefix.length();
            }
            final String replaceStr = Attachments.asWiki((ResolvedWikiPageAttachment)attachment);
            list.add(new TokenBasedProposal(replaceStr, this.fImgAttachment, offset - len, len, replaceStr.length()){

                public String getDisplayString() {
                    return replaceStr;
                }

                public String getAdditionalProposalInfo() {
                    return replaceStr;
                }
            });
        }
    }

    private String computeFormattingsInfo(Token token, String before, String after) {
        return this.computeFormattingsInfo(Tokens.getDisplayString((Token)token), before, after);
    }

    private String computeFormattingsInfo(String token, String before, String after) {
        StringBuilder text = new StringBuilder();
        if (before != null) {
            text.append(before);
        }
        text.append(token);
        if (after != null) {
            text.append(after);
        }
        text.append(this.fTransformer.transform(text.toString()));
        return text.toString();
    }

    protected int offsetInLine(int offset) {
        try {
            IDocument document = this.fViewer.getDocument();
            IRegion region = document.getLineInformationOfOffset(offset);
            return offset - region.getOffset();
        }
        catch (BadLocationException e) {
            PlanningUIPlugin.log(e);
            return -1;
        }
    }

    private String getPrefix(int offset) {
        IDocument document = this.fViewer.getDocument();
        StringBuilder prefix = new StringBuilder();
        try {
            char ch;
            while (offset != 0 && !Character.isWhitespace(ch = document.getChar(--offset))) {
                prefix.insert(0, ch);
            }
        }
        catch (BadLocationException e) {
            PlanningUIPlugin.log(e);
        }
        return prefix.toString();
    }

    public int countCharAtBeginOfPreviousLine(char ch, int offset) {
        int line;
        IDocument document;
        block4: {
            document = this.fViewer.getDocument();
            line = document.getLineOfOffset(offset);
            if (line != 0) break block4;
            return -1;
        }
        try {
            IRegion region = document.getLineInformation(line - 1);
            String prefix = document.get(region.getOffset(), region.getLength());
            int count = 0;
            int index = 0;
            while (index < prefix.length() && prefix.charAt(index++) == ch) {
                ++count;
            }
            return count;
        }
        catch (BadLocationException e) {
            PlanningUIPlugin.log(e);
            return -1;
        }
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TokenBasedProposal
    implements ICompletionProposal,
    Comparable<TokenBasedProposal> {
        private final String fReplaceStr;
        private final int fReplaceOffset;
        private final int fReplaceLength;
        private final int fCursorOffset;
        private final Token fToken;
        private final Image fImage;

        public TokenBasedProposal(Token token, String replaceStr, int replaceOffset, int replaceLength, int cursorOffset) {
            Assert.isNotNull((Object)token);
            Assert.isNotNull((Object)replaceStr);
            Assert.isLegal((replaceOffset >= 0 ? 1 : 0) != 0);
            Assert.isLegal((replaceLength >= 0 ? 1 : 0) != 0);
            this.fReplaceStr = replaceStr;
            this.fReplaceOffset = replaceOffset;
            this.fReplaceLength = replaceLength;
            this.fCursorOffset = cursorOffset;
            this.fToken = token;
            this.fImage = (Image)WikiCompletionProcessor.this.fImageMap.get(token);
        }

        public TokenBasedProposal(String replaceStr, Image image, int replaceOffset, int replaceLength, int cursorOffset) {
            Assert.isNotNull((Object)replaceStr);
            Assert.isNotNull((Object)image);
            Assert.isLegal((replaceOffset >= 0 ? 1 : 0) != 0);
            Assert.isLegal((replaceLength >= 0 ? 1 : 0) != 0);
            this.fReplaceStr = replaceStr;
            this.fReplaceOffset = replaceOffset;
            this.fReplaceLength = replaceLength;
            this.fCursorOffset = cursorOffset;
            this.fToken = null;
            this.fImage = image;
        }

        public void apply(IDocument document) {
            try {
                document.replace(this.fReplaceOffset, this.fReplaceLength, this.fReplaceStr);
            }
            catch (BadLocationException badLocationException) {}
        }

        public String getAdditionalProposalInfo() {
            return WikiCompletionProcessor.this.computeFormattingsInfo(this.fToken, this.fToken.wiki, this.fToken.wiki);
        }

        public IContextInformation getContextInformation() {
            return null;
        }

        public String getDisplayString() {
            return NLS.bind((String)Messages.WikiCompletionProcessor_PROPOSAL_LABEL, (Object[])new Object[]{Tokens.getDisplayString((Token)this.fToken), this.fToken.wiki});
        }

        public Image getImage() {
            return this.fImage;
        }

        public Point getSelection(IDocument document) {
            return new Point(this.fReplaceOffset + this.fCursorOffset, 0);
        }

        @Override
        public int compareTo(TokenBasedProposal o) {
            return -(this.fReplaceLength - o.fReplaceLength);
        }
    }
}

