/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.wiki;

import com.ibm.team.apt.internal.ide.ui.actions.IActionProvider;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.WikiViewer;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.actions.SmartHomeAction;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.actions.SmartTableNavigation;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.actions.xxx.DeleteLineAction;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.actions.xxx.MoveLinesAction;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.UndoContext;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.text.IUndoManagerExtension;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.operations.OperationHistoryActionHandler;
import org.eclipse.ui.operations.RedoActionHandler;
import org.eclipse.ui.operations.UndoActionHandler;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.FindNextAction;
import org.eclipse.ui.texteditor.FindReplaceAction;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.IncrementalFindAction;
import org.eclipse.ui.texteditor.TextOperationAction;

public class WikiActionGroup
extends ActionGroup
implements IActionProvider {
    private static boolean DEBUG = false;
    public static final ActionContext EDIT = new ActionContext(null);
    public static final ActionContext VIEW = new ActionContext(null);
    private static final String RESOURCE_BUNDLE = "com.ibm.team.apt.internal.ide.ui.editor.wiki.WikiMessages";
    private static ResourceBundle fgResourceBundle = ResourceBundle.getBundle("com.ibm.team.apt.internal.ide.ui.editor.wiki.WikiMessages");
    protected WikiViewer fViewer;
    protected Map<String, Action> fActions = new HashMap<String, Action>();

    public WikiActionGroup(WikiViewer viewer) {
        this.fViewer = viewer;
    }

    protected void initActions() {
        Object action = new FindReplaceAction(fgResourceBundle, "find.", this.fViewer.getControl().getShell(), this.fViewer.getFindReplaceTarget());
        action.setActionDefinitionId(ActionFactory.FIND.getId());
        this.fActions.put(ActionFactory.FIND.getId(), (Action)action);
        action = new FindNextAction(fgResourceBundle, "findNext.", (IWorkbenchPart)this.fViewer.getTextEditor(), true);
        action.setActionDefinitionId("FindNext");
        this.fActions.put("org.eclipse.ui.edit.findNext", (Action)action);
        action = new FindNextAction(fgResourceBundle, "findPre.", (IWorkbenchPart)this.fViewer.getTextEditor(), false);
        action.setActionDefinitionId("FindPrevious");
        this.fActions.put("org.eclipse.ui.edit.findPrevious", (Action)action);
        action = new IncrementalFindAction(fgResourceBundle, "findIncre.", (IWorkbenchPart)this.fViewer.getTextEditor(), true);
        action.setActionDefinitionId("FindIncremental");
        this.fActions.put("org.eclipse.ui.edit.findIncremental", (Action)action);
        action = new IncrementalFindAction(fgResourceBundle, "findIncreRev", (IWorkbenchPart)this.fViewer.getTextEditor(), false);
        action.setActionDefinitionId("FindIncrementalReverse");
        this.fActions.put("org.eclipse.ui.edit.findIncrementalReverse", (Action)action);
        action = new TextOperationAction(fgResourceBundle, "cut.", this.fViewer.getTextEditor(), 3);
        action.setActionDefinitionId("org.eclipse.ui.edit.cut");
        this.fActions.put(ActionFactory.CUT.getId(), (Action)action);
        action = new TextOperationAction(fgResourceBundle, "copy.", this.fViewer.getTextEditor(), 4, true);
        action.setActionDefinitionId("org.eclipse.ui.edit.copy");
        this.fActions.put(ActionFactory.COPY.getId(), (Action)action);
        action = new TextOperationAction(fgResourceBundle, "paste.", this.fViewer.getTextEditor(), 5);
        action.setActionDefinitionId("org.eclipse.ui.edit.paste");
        this.fActions.put(ActionFactory.PASTE.getId(), (Action)action);
        action = new TextOperationAction(fgResourceBundle, "selectAll.", this.fViewer.getTextEditor(), 7);
        action.setActionDefinitionId(ActionFactory.SELECT_ALL.getId());
        this.fActions.put(ActionFactory.SELECT_ALL.getId(), (Action)action);
        action = new UndoActionHandler(this.fViewer.getTextEditor().getSite(), (IUndoContext)new UndoContext());
        action.setActionDefinitionId("org.eclipse.ui.edit.undo");
        this.fActions.put(ActionFactory.UNDO.getId(), (Action)action);
        action = new RedoActionHandler(this.fViewer.getTextEditor().getSite(), (IUndoContext)new UndoContext());
        action.setActionDefinitionId("org.eclipse.ui.edit.redo");
        this.fActions.put(ActionFactory.REDO.getId(), (Action)action);
        action = new ContentAssistAction(fgResourceBundle, "contentAssistent.", this.fViewer.getTextEditor());
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.fActions.put("org.eclipse.ui.edit.text.contentAssist.proposals", (Action)action);
        action = new TextOperationAction(fgResourceBundle, "quickAssistent.", this.fViewer.getTextEditor(), 22);
        action.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.correction.assist.proposals");
        this.fActions.put("org.eclipse.jdt.ui.edit.text.java.correction.assist.proposals", (Action)action);
        action = new SmartHomeAction((ISourceViewer)this.fViewer);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.goto.lineStart");
        this.fActions.put("org.eclipse.ui.edit.text.goto.lineStart", (Action)action);
        action = new SmartTableNavigation(this.fViewer);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.goto.wordNext");
        this.fActions.put("org.eclipse.ui.edit.text.goto.wordNext", (Action)action);
        action = new DeleteLineAction(fgResourceBundle, "deleteLine.", this.fViewer, 0);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.delete.line");
        this.fActions.put("org.eclipse.ui.edit.text.delete.line", (Action)action);
        action = new MoveLinesAction(fgResourceBundle, "moveLineUp.", this.fViewer, true, false);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.moveLineUp");
        this.fActions.put("org.eclipse.ui.edit.text.moveLineUp", (Action)action);
        action = new MoveLinesAction(fgResourceBundle, "moveLineDown.", this.fViewer, false, false);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.moveLineDown");
        this.fActions.put("org.eclipse.ui.edit.text.moveLineDown", (Action)action);
        action = new MoveLinesAction(fgResourceBundle, "copyLineUp.", this.fViewer, true, true);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.copyLineUp");
        this.fActions.put("org.eclipse.ui.edit.text.copyLineUp", (Action)action);
        action = new MoveLinesAction(fgResourceBundle, "copyLineDown.", this.fViewer, false, true);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.copyLineDown");
        this.fActions.put("org.eclipse.ui.edit.text.copyLineDown", (Action)action);
    }

    public void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("group.file"));
        menu.appendToGroup("group.file", (IAction)this.getAction(ActionFactory.UNDO.getId()));
        menu.appendToGroup("group.file", (IAction)this.getAction(ActionFactory.REDO.getId()));
        menu.add((IContributionItem)new Separator("group.editor"));
        menu.appendToGroup("group.editor", (IAction)this.getAction(ActionFactory.CUT.getId()));
        menu.appendToGroup("group.editor", (IAction)this.getAction(ActionFactory.COPY.getId()));
        menu.appendToGroup("group.editor", (IAction)this.getAction(ActionFactory.PASTE.getId()));
    }

    public void fillLocalToolBar(ToolBarManager toolBar) {
    }

    public void fillActionBars(IActionBars actionBars) {
    }

    public void updateActionBars() {
        this.updateActions();
    }

    public void updateActions() {
        for (Action action : this.fActions.values()) {
            this.update(action);
        }
    }

    public void updateActions(String first, String ... rest) {
        Action action = this.fActions.get(first);
        this.update(action);
        String[] stringArray = rest;
        int n = rest.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            action = this.fActions.get(id);
            this.update(action);
            ++n2;
        }
    }

    private void update(Action action) {
        if (action == null) {
            return;
        }
        if (this.getContext() == EDIT) {
            if (action instanceof IUpdate) {
                ((IUpdate)action).update();
            } else if (action instanceof OperationHistoryActionHandler) {
                OperationHistoryActionHandler action2 = (OperationHistoryActionHandler)action;
                IUndoContext undoContext = ((IUndoManagerExtension)this.fViewer.getUndoManager()).getUndoContext();
                action2.setContext(undoContext);
                action2.setEnabled(undoContext != null);
                if (DEBUG) {
                    System.out.format("Undo context [%s] for [%s]\n", undoContext, action2);
                }
            } else {
                action.setEnabled(true);
            }
        } else {
            action.setEnabled(false);
        }
    }

    public Action getAction(String id) {
        Action result = this.fActions.get(id);
        if (DEBUG) {
            System.out.format("[%s] for [%s]%n", result, id);
        }
        return result;
    }
}

