/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.wiki;

import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.jface.preview.DomainAdapterUtils;
import com.ibm.team.jface.preview.IDomainAdapter;
import com.ibm.team.jface.tooltip.TooltipSupport;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;

public class BrowserTooltipSupport
extends TooltipSupport {
    private URI fUri;
    private String fLastText;
    private final Browser fBrowserControl;

    public BrowserTooltipSupport(final Browser control, boolean isFocusable, boolean isOpenable) {
        super((Control)control, isFocusable, isOpenable);
        this.fBrowserControl = control;
        if ("carbon".equals(SWT.getPlatform())) {
            return;
        }
        control.addLocationListener(new LocationListener(){

            public void changed(LocationEvent event) {
                BrowserTooltipSupport.this.fLastText = null;
                BrowserTooltipSupport.this.fUri = null;
            }

            public void changing(LocationEvent event) {
            }
        });
        control.addStatusTextListener(new StatusTextListener(){

            public void changed(StatusTextEvent e) {
                Display display = control.getDisplay();
                Point point = display.map(null, (Control)control, display.getCursorLocation());
                if (!control.getBounds().contains(point)) {
                    return;
                }
                if (BrowserTooltipSupport.this.fLastText != null && BrowserTooltipSupport.this.fLastText.equals(e.text)) {
                    return;
                }
                URI oldURI = BrowserTooltipSupport.this.fUri;
                this.updateElement(e);
                if (BrowserTooltipSupport.this.fUri == null) {
                    control.notifyListeners(7, this.newEvent(control, e, BrowserTooltipSupport.this.fUri));
                } else if (BrowserTooltipSupport.this.fUri != oldURI) {
                    control.notifyListeners(7, this.newEvent(control, e, BrowserTooltipSupport.this.fUri));
                    this.fakeMouseHoverEvent(display, this.newEvent(control, e, BrowserTooltipSupport.this.fUri));
                } else {
                    this.fakeMouseHoverEvent(display, this.newEvent(control, e, BrowserTooltipSupport.this.fUri));
                }
            }

            private void fakeMouseHoverEvent(final Display display, final Event event) {
                display.timerExec(200, new Runnable(){
                    private Point fPoint;
                    {
                        this.fPoint = new Point(event2.x, event2.y);
                    }

                    public void run() {
                        if (control.isDisposed()) {
                            return;
                        }
                        if (BrowserTooltipSupport.this.fUri == event.data) {
                            Point point = display.getCursorLocation();
                            if (this.fuzzyEquals(this.fPoint, point)) {
                                control.notifyListeners(32, event);
                            } else {
                                this.fPoint = point;
                                display.timerExec(200, (Runnable)this);
                            }
                        }
                    }

                    private boolean fuzzyEquals(Point p1, Point p2) {
                        return Math.abs(p1.x - p2.x) <= 8 && Math.abs(p1.y - p2.y) <= 8;
                    }
                });
            }

            private Event newEvent(Browser control2, StatusTextEvent e, URI uri) {
                Display display = control2.getDisplay();
                Point point = display.getCursorLocation();
                Event event = new Event();
                event.time = e.time;
                event.widget = e.widget;
                event.x = point.x;
                event.y = point.y;
                event.data = uri;
                return event;
            }

            private void updateElement(StatusTextEvent event) {
                BrowserTooltipSupport.this.fUri = null;
                BrowserTooltipSupport.this.fLastText = null;
                String text = event.text.trim();
                if (text.length() == 0) {
                    return;
                }
                URI uri = null;
                try {
                    uri = new URI(event.text);
                }
                catch (URISyntaxException uRISyntaxException) {
                    return;
                }
                if (!uri.isAbsolute()) {
                    return;
                }
                try {
                    uri.toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    return;
                }
                BrowserTooltipSupport.this.fLastText = event.text;
                BrowserTooltipSupport.this.fUri = uri;
            }
        });
    }

    public Rectangle getElementBounds(Control control, int x, int y) {
        Assert.isTrue((this.fBrowserControl == control ? 1 : 0) != 0);
        Rectangle bounds = this.fBrowserControl.getBounds();
        return new Rectangle(0, 0, bounds.width, bounds.height);
    }

    protected void showHoverToolTip(Object element, Point location) {
        super.showHoverToolTip(element, this.computeHoverLocation());
    }

    private Point computeHoverLocation() {
        Point point = this.fBrowserControl.getDisplay().getCursorLocation();
        point.y -= this.fBrowserControl.getBounds().height;
        return point;
    }

    protected boolean useDomainAdapter(Object element) {
        return !(element instanceof URI);
    }

    public Object getElement(Control control, int x, int y) {
        return this.fUri;
    }

    protected String getMarkupInBackground(IDomainAdapter adapter, Object element, IDomainAdapter.Info info, IProgressMonitor monitor) {
        if (element instanceof URI) {
            URI uri = (URI)element;
            try {
                IDomainAdapter newAdapter;
                Object input = Hyperlinks.resolve((URI)uri, null, (IProgressMonitor)monitor);
                if (input != null && (newAdapter = DomainAdapterUtils.getDomainAdapter((Object)input)) != null) {
                    return DomainAdapterUtils.generateContentAsHTML((IDomainAdapter)newAdapter, (Object)input, (IDomainAdapter.Info)info, (IProgressMonitor)monitor);
                }
            }
            catch (CoreException coreException) {}
            return String.valueOf(uri);
        }
        return super.getMarkupInBackground(adapter, element, info, monitor);
    }
}

