/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.outliner;

import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.util.Tags;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryUtils;
import com.ibm.team.apt.internal.ide.ui.common.model.IOutlineModelReader;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineEntry;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.Messages;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.OutlineFilterDescriptor;
import com.ibm.team.repository.common.util.NLS;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagFilterDescriptor
extends OutlineFilterDescriptor {
    private static final String ID = "FILTER_TAG_";
    protected String fTag;

    public TagFilterDescriptor(String tag) {
        super(ID + TagFilterDescriptor.escape(tag), tag, NLS.bind((String)Messages.TagFilterDescriptor_TAG_DESCRIPTION, (Object[])new Object[]{tag}));
        this.fTag = tag;
        if (tag.equals(Tags.NO_TAGS)) {
            this.fDescription = Messages.TagFilterDescriptor_NOTAG_DESCRIPTION;
        }
    }

    public static String escape(String tag) {
        StringBuffer escaped = new StringBuffer();
        int i = 0;
        while (i < tag.length()) {
            char ch = tag.charAt(i);
            if (i == 0 && !TagFilterDescriptor.isNameStart(ch) || !TagFilterDescriptor.isName(ch)) {
                escaped.append('_');
            } else {
                escaped.append(ch);
            }
            ++i;
        }
        return escaped.toString();
    }

    private static boolean isName(char ch) {
        return Character.isLetterOrDigit(ch) || ch == '.' || ch == '-' || ch == '_' || ch == ':';
    }

    private static boolean isNameStart(char ch) {
        return Character.isLetter(ch) || ch == '_' || ch == ':';
    }

    @Override
    public boolean select(OutlineEntry<?> entry, IOutlineModelReader readAccessor) {
        if (!EntryUtils.isType(entry, PlanItem.class)) {
            return true;
        }
        PlanItem item = (PlanItem)entry.getElement();
        Collection tags = item.getTags();
        return tags.contains(this.fTag) || tags.isEmpty() && this.fTag.equals(Tags.NO_TAGS);
    }

    @Override
    public boolean isFilterType(OutlineFilterDescriptor.FilterType filterType) {
        return filterType == OutlineFilterDescriptor.FilterType.TAGS;
    }

    @Override
    public boolean isFilterProperty(OutlineEntry<?> entry, String property) {
        return PlanItem.TAGS.getName().equals(property);
    }
}

