/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.outliner;

import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.common.ProgressInformation;
import com.ibm.team.apt.internal.common.ProgressItem;
import com.ibm.team.apt.internal.ide.ui.common.PlanOutlineResources;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.GroupNodeContent;
import com.ibm.team.apt.internal.ide.ui.common.model.IEntryVisitor;
import com.ibm.team.apt.internal.ide.ui.common.model.IOutlineModelReader;
import com.ibm.team.apt.internal.ide.ui.common.model.ModelReadRunnable;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineEntry;
import com.ibm.team.apt.internal.ide.ui.common.structure.GroupElement;
import com.ibm.team.apt.internal.ide.ui.common.structure.PrimaryLocationTag;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GProgressBar;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GTreeNode;
import org.eclipse.swt.graphics.Point;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProgressGroupNodeContent
extends GroupNodeContent {
    private OutlineEntry<? extends GroupElement> fEntry;
    private ProgressInformation fProgressInformation;
    private GProgressBar fProgressBar;

    public ProgressGroupNodeContent(GTreeNode parent, OutlineEntry<? extends GroupElement> groupEntry) {
        super(parent, groupEntry, groupEntry.getElement().getLabel());
        this.fEntry = groupEntry;
        this.fProgressBar = new GProgressBar(this, ProgressItem.create((ProgressInformation)this.getProgressInformation()), false);
    }

    @Override
    public int computeMinimalWidth() {
        PlanOutlineResources resources = this.getPlanOutlineResources();
        return super.computeMinimalWidth() + 2 * resources.getSpaceWidth() + this.fProgressBar.computeMinimalWidth();
    }

    @Override
    protected Point arrangeContent(int x, int y, int wHint, int hHint) {
        Point parent = super.arrangeContent(x, y, wHint, hHint);
        PlanOutlineResources resources = this.getPlanOutlineResources();
        this.fProgressBar.layout(x, y, -1, -1);
        this.fProgressBar.move(wHint != -1 ? this.max(0, wHint - this.fProgressBar.getWidth()) : x + parent.x, 0);
        int barHeight = this.fProgressBar.getHeight();
        if (parent.y > barHeight) {
            int visualFrontHeight = barHeight - this.fProgressBar.computeTopSpacing();
            int delta = this.max(0, (parent.y - visualFrontHeight) / 2 - this.fProgressBar.computeTopSpacing());
            this.fProgressBar.move(0, delta);
        } else if (barHeight > parent.y) {
            this.fStatusLabel.move(0, barHeight - parent.y);
        }
        return new Point(this.max(wHint, this.max(this.fNameLabel.getWidth(), this.fStatusLabel.getWidth()) + 2 * resources.getSpaceWidth() + this.fProgressBar.getWidth()), this.max(hHint, parent.y, barHeight));
    }

    @Override
    protected int[] getOpenCloseCount(OutlineEntry<? extends GroupElement> groupEntry) {
        if (this.fEntry == null) {
            this.fEntry = groupEntry;
        }
        ProgressInformation info = this.getProgressInformation();
        return new int[]{info.getOpenCount(), info.getCloseCount()};
    }

    private ProgressInformation getProgressInformation() {
        if (this.fProgressInformation == null) {
            this.fProgressInformation = this.computeProgressInformation();
        }
        return this.fProgressInformation;
    }

    private ProgressInformation computeProgressInformation() {
        return this.fEntry.getModel().readModel(new ModelReadRunnable<ProgressInformation, RuntimeException>(){

            @Override
            public ProgressInformation run(IOutlineModelReader readAccessor) throws RuntimeException {
                final ProgressInformation result = new ProgressInformation();
                readAccessor.accept(ProgressGroupNodeContent.this.fEntry, new IEntryVisitor(){

                    @Override
                    public boolean visit(OutlineEntry<?> entry) {
                        Object element = entry.getElement();
                        if (!(element instanceof PlanItem)) {
                            return true;
                        }
                        PlanItem planItem = (PlanItem)element;
                        if (entry.hasTag(PrimaryLocationTag.INSTANCE)) {
                            planItem.updateProgresInformation(result);
                        }
                        return true;
                    }
                });
                return result;
            }
        });
    }
}

