/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.outliner;

import com.ibm.icu.text.MessageFormat;
import com.ibm.team.apt.internal.client.IterationPlanItem;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.common.ProgressInformation;
import com.ibm.team.apt.internal.ide.ui.common.PlanOutlineResources;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.AttributeDropDownAction;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.GDuration;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.GOwner;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.GPriority;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.GStatusLine;
import com.ibm.team.apt.internal.ide.ui.common.model.IEntryVisitor;
import com.ibm.team.apt.internal.ide.ui.common.model.IOutlineModelReader;
import com.ibm.team.apt.internal.ide.ui.common.model.ModelReadRunnable;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineEntry;
import com.ibm.team.apt.internal.ide.ui.common.structure.PrimaryLocationTag;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.IColumnBasedGadget;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.IterationPlanItemNodeContent;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.Messages;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GButton;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GHTMLText;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GLabel;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GText;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GTreeNode;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GVoid;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Gadget;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.TextStyleRange;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.internal.WorkItemClient;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemType;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchPartSite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanItemNodeContent
extends IterationPlanItemNodeContent
implements IColumnBasedGadget {
    private GButton fImage;
    private GText fSummary;
    private GText fDescription;
    private GStatusLine fStatusLine;
    private GDuration fDurationItem;
    private int fSummaryColumnWidth;

    public PlanItemNodeContent(GTreeNode parent, OutlineEntry<PlanItem> outlineEntry, IWorkbenchPartSite site, boolean markResolved, boolean isPlaceholder) {
        super(parent, outlineEntry.getElement(), isPlaceholder);
        PlanItem planItem = outlineEntry.getElement();
        PlanOutlineResources resources = this.getPlanOutlineResources();
        this.fImage = new GButton(this, resources.getWorkItemLabelProvider().getImage((Object)planItem.getWorkItem(false)), 1024);
        this.fImage.setAction((IAction)new ItemTypeDropDownAction(planItem));
        this.fSummary = new GText(this, resources.isSingleClickMode() ? 2048 : 0);
        this.fSummary.setColor(markResolved && !isPlaceholder ? resources.getItemCompletedColor() : null);
        this.fSummary.setText(planItem.getHTMLSummary().getPlainText());
        this.fSummary.setAlternateText(Messages.PlanItemNodeContent_EMPTY_SUMMARY_PLACEHOLDER);
        this.fSummary.setAlternateColor(resources.getNoContentColor());
        this.fSummary.setId("summary");
        this.fDescription = new GHTMLText(this);
        this.fDescription.setTextStyleRanges(new TextStyleRange[]{new TextStyleRange(-1, Integer.MAX_VALUE, new TextStyle(null, markResolved ? resources.getItemCompletedColor() : null, null))});
        this.fDescription.setText(planItem.getHTMLDescription().getXMLText());
        this.fDescription.setAlternateText(Messages.PlanItemNodeContent_EMPTY_DESCRIPTION_PLACEHOLDER);
        this.fDescription.setAlternateColor(resources.getNoContentColor());
        this.fDescription.setId("description");
        this.fStatusLine = new GStatusLine(this);
        boolean canEditStatus = !planItem.isProgressPlanItem();
        boolean isPrimaryItem = outlineEntry.hasTag(PrimaryLocationTag.INSTANCE);
        if (this.showProgress(planItem) && (isPrimaryItem || planItem.isProgressPlanItem())) {
            ProgressInformation progressInfo = null;
            progressInfo = planItem.isProgressPlanItem() && planItem instanceof IterationPlanItem ? ((IterationPlanItem)planItem).getProgressInfo() : this.computeProgressInformation(outlineEntry);
            if (planItem.isTopLevelPlanItem() && progressInfo.getOpenCount() + progressInfo.getCloseCount() == 0) {
                new GVoid(this.fStatusLine);
            } else {
                new GLabel(this.fStatusLine, progressInfo.getOpenCount() == 0 ? Messages.PlanItemNodeContent_DONE_DONE : MessageFormat.format((String)Messages.PlanItemNodeContent_DONE_LABEL, (Object[])new Object[]{progressInfo.getCloseCount() * 100 / (progressInfo.getCloseCount() + progressInfo.getOpenCount())}), 0);
            }
        } else if (!planItem.isTopLevelPlanItem()) {
            this.fDurationItem = new GDuration(this.fStatusLine, planItem, 0x1000000);
            this.fDurationItem.setEnabled(canEditStatus);
        } else {
            new GVoid(this.fStatusLine);
        }
        GPriority priority = new GPriority(this.fStatusLine, planItem, 0x1000000);
        priority.setEnabled(canEditStatus);
        boolean showOwner = this.showOwner();
        if (showOwner) {
            GOwner owner = new GOwner(this.fStatusLine, planItem, 0x1000000);
            owner.setEnabled(canEditStatus);
        }
        if (markResolved) {
            this.fStatusLine.setColor(resources.getItemCompletedColor());
        }
    }

    private void setStatusLineWidths() {
        int[] hints = new int[this.fStatusLine.getGadgetCount()];
        int i = 0;
        while (i < hints.length) {
            hints[i] = this.getOutline().getColumn(i + 2).getWidth();
            ++i;
        }
        this.fStatusLine.setWidthHints(hints);
    }

    @Override
    public Object getElement() {
        return this.getPlanItem();
    }

    @Override
    public GText getSummary() {
        return this.fSummary;
    }

    @Override
    public GText getDescription() {
        return this.fDescription;
    }

    @Override
    public int computeMinimalWidth() {
        PlanOutlineResources resources = this.getPlanOutlineResources();
        int image = this.fImage.computeMinimalWidth();
        int summary = this.fSummary.computeMinimalWidth();
        int status = this.showDetails() ? this.fStatusLine.computeMinimalWidth() : 0;
        int description = this.showDescription() ? this.fDescription.computeMinimalWidth() : 0;
        return this.max(image + resources.getIconSummarySpacing() + summary + resources.getSummaryIdSpacing() + status, description);
    }

    @Override
    protected Point arrangeContent(int x, int y, int wHint, int hHint) {
        boolean showStatus = this.showDetails();
        boolean showDescription = this.showDescription();
        int descriptionWidth = 0;
        int statusWidth = 0;
        int startY = y;
        this.setStatusLineWidths();
        PlanOutlineResources resources = this.getPlanOutlineResources();
        this.fImage.layout(x, y, -1, -1);
        int tx = x + this.fImage.getWidth() + resources.getIconSummarySpacing();
        int tWidth = wHint;
        int maxSummaryWidth = wHint - (tx - x + (showStatus ? this.fStatusLine.computeMinimalWidth() + resources.getStatusSpacing() : 0) + resources.getStatusSpacing());
        int summaryX = tx;
        this.fSummary.layout(summaryX, y, maxSummaryWidth > 0 && this.fSummary.computeMaximumWidth() > maxSummaryWidth ? maxSummaryWidth : -1, -1);
        this.fSummary.setMaximumWidth(maxSummaryWidth);
        this.fSummaryColumnWidth = tx - x;
        tWidth -= this.getImageWhiteSpace();
        tx += this.getImageWhiteSpace();
        this.fStatusLine.setExclude(!showStatus);
        if (showStatus) {
            tx += resources.getStatusSpacing();
            this.fStatusLine.layout(tx += this.fSummary.getWidth(), y, tWidth, -1);
            statusWidth = this.fStatusLine.getWidth();
            this.fStatusLine.move(x + wHint - (tx + statusWidth + resources.getStatusSpacing()), 0);
        }
        y += this.max(this.fImage.getHeight(), this.fSummary.getHeight(), showStatus ? this.fStatusLine.getHeight() : 0);
        if (this.fDurationItem != null) {
            this.fDurationItem.setEnabled(!this.getPlanItem().isProgressPlanItem());
        }
        this.fDescription.setExclude(!showDescription);
        if (showDescription) {
            int maxDescriptionWidth = wHint - (resources.getStatusSpacing() + (summaryX - x));
            this.fDescription.setMaximumWidth(maxDescriptionWidth);
            this.fDescription.layout(summaryX, y += resources.getDescriptionSpacing(), -1, -1);
            if (this.fDescription.getBounds().width > maxDescriptionWidth) {
                this.fDescription.layout(summaryX, y, maxDescriptionWidth, -1);
            }
            y += this.fDescription.getHeight();
            descriptionWidth = this.fDescription.getWidth();
        }
        int width = this.max(wHint, this.fImage.getWidth() + resources.getIconSummarySpacing() + this.fSummary.getWidth() + statusWidth + resources.getStatusSpacing(), descriptionWidth);
        return new Point(width, y - startY);
    }

    @Override
    protected Point relayout(int x, int y, int deltaWidth, int deltaHeight, Gadget changedChild) {
        int width = this.getBounds().width;
        int height = this.getBounds().height;
        if (changedChild == this.fSummary) {
            height += deltaHeight;
            if (!this.fDescription.isExcluded()) {
                this.fDescription.move(0, deltaHeight);
            }
            if (!this.fStatusLine.isExcluded()) {
                this.fStatusLine.move(0, deltaHeight);
            }
        } else if (changedChild == this.fDescription) {
            height += deltaHeight;
            if (!this.fStatusLine.isExcluded()) {
                this.fStatusLine.move(0, deltaHeight);
            }
        }
        return new Point(width, height);
    }

    public Gadget findNextEditableGadget(Gadget child, Gadget owner, int direction) {
        if (child == this.fDescription && direction == 0x1000001) {
            return this.fSummary;
        }
        if (child == this.fSummary && direction == 0x1000002) {
            return this.fDescription;
        }
        return null;
    }

    private boolean showOwner() {
        boolean showOwner = true;
        showOwner &= !"OWNER".equals(this.getPlanOutlineSettings().getGroupMode().getId());
        showOwner &= !"TIMELINE".equals(this.getPlanOutlineSettings().getGroupMode().getId());
        return showOwner &= !"com.ibm.team.apt.ide.planmode.PersonalMode".equals(this.getPlanOutlineSettings().getPlanMode().getId());
    }

    protected boolean showDescription() {
        return this.getPlanItem().isDraftItem();
    }

    protected boolean showDetails() {
        return this.getPlanOutlineSettings().getShowDetails();
    }

    @Override
    public int getColumnCount() {
        return 1 + this.fStatusLine.getVisibleItems().length;
    }

    @Override
    public int getColumnWidth(int index) {
        Assert.isLegal((index >= 0 && index < this.getColumnCount() ? 1 : 0) != 0);
        switch (index) {
            case 0: {
                return this.fSummaryColumnWidth;
            }
        }
        return this.fStatusLine.getVisibleItems()[index - 1].computeMinimalWidth();
    }

    private boolean showProgress(PlanItem planItem) {
        if (planItem.isTopLevelPlanItem()) {
            return true;
        }
        if (planItem.isAuxiliaryPlanItem() && planItem.isProgressPlanItem() && planItem instanceof IterationPlanItem) {
            IterationPlanItem ipi = (IterationPlanItem)planItem;
            ProgressInformation info = ipi.getProgressInfo();
            return info.getCloseCount() + info.getOpenCount() > 1;
        }
        return false;
    }

    private ProgressInformation computeProgressInformation(final OutlineEntry<PlanItem> outlineEntry) {
        return outlineEntry.getModel().readModel(new ModelReadRunnable<ProgressInformation, RuntimeException>(){

            @Override
            public ProgressInformation run(IOutlineModelReader readAccessor) throws RuntimeException {
                final ProgressInformation result = new ProgressInformation();
                readAccessor.accept(outlineEntry, new IEntryVisitor(){

                    @Override
                    public boolean visit(OutlineEntry<?> entry) {
                        Object element = entry.getElement();
                        if (element instanceof PlanItem) {
                            PlanItem item = (PlanItem)element;
                            if (outlineEntry == entry) {
                                if (item.getDuration().isSpecified() && item.isTopLevelPlanItem() && !item.isProgressPlanItem()) {
                                    item.updateProgresInformation(result);
                                }
                            } else {
                                item.updateProgresInformation(result);
                            }
                        }
                        return true;
                    }
                });
                return result;
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ItemTypeDropDownAction
    extends AttributeDropDownAction<IWorkItemType> {
        public ItemTypeDropDownAction(PlanItem planItem) {
            super(planItem, planItem.getPlan().getWorkItemTypeAttribute(), false);
        }

        @Override
        protected List<IWorkItemType> slowResolveValues(IProgressMonitor monitor) throws TeamRepositoryException {
            WorkItemClient wic;
            IProcessAreaHandle processArea;
            Object[] ids = null;
            if (this.getPlanItem().isNewItem() && (processArea = (wic = (WorkItemClient)PlanningClientPlugin.getWorkItemClient((ITeamRepository)this.getPlanItem().getPlan().getTeamRepository())).findProcessArea((IWorkItemHandle)this.getPlanItem().getWorkItem(false), (IProgressMonitor)new SubProgressMonitor(monitor, 1))) instanceof ITeamAreaHandle) {
                ids = wic.findCachedAvailableWorkItemTypes((ITeamAreaHandle)processArea);
            }
            if (ids == null) {
                ids = this.getValueSet((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            wic = PlanningClientPlugin.getWorkItemClient((ITeamRepository)this.getPlanItem().getPlan().getTeamRepository());
            ArrayList<IWorkItemType> result = new ArrayList<IWorkItemType>(ids.length);
            monitor.beginTask("", ids.length);
            int i = 0;
            while (i < ids.length) {
                result.add(wic.findWorkItemType((IProjectAreaHandle)this.getPlanItem().getPlan().getProjectArea(), (String)ids[i], (IProgressMonitor)new SubProgressMonitor(monitor, 1)));
                ++i;
            }
            return result;
        }

        @Override
        protected void setValue(IWorkItemType type) {
            this.getPlanItem().setItemType(type.getIdentifier());
        }

        @Override
        protected MenuItem createMenuItem(Menu menu, IWorkItemType type) {
            MenuItem item = new MenuItem(menu, 0);
            item.setImage(PlanItemNodeContent.this.getPlanOutlineResources().getWorkItemTypeImage(type));
            item.setText(type.getDisplayName());
            return item;
        }
    }
}

