/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.outliner;

import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.ide.ui.common.LocationMarker;
import com.ibm.team.apt.internal.ide.ui.common.PlanOutlineResources;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.GMarkerGadget;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineEntry;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.ColorizeTag;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.IterationPlanItemNodeContent;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.Messages;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.PlanElementGadget;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.PlanItemNodeContent;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.PlanItemOutline;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.ContentOutlineItem;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GLink;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GText;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Outline;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.text.WorkItemTextUtilities;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanItemGadget
extends PlanElementGadget<PlanItem, IterationPlanItemNodeContent> {
    public static final String SUMMARY_ID = "summary";
    public static final String DESCRIPTION_ID = "description";
    private GMarkerGadget fMarker;
    private GLink fId;
    private IterationPlanItemNodeContent fNodeContent;

    public PlanItemGadget(ContentOutlineItem item, OutlineEntry<PlanItem> outlineEntry, final IWorkbenchPartSite site, List<ColorizeTag> colorTags, boolean isPlaceholder, LocationMarker locationMarker) {
        super(item, outlineEntry.getElement(), colorTags, 0x80 | (isPlaceholder ? 4 : 0));
        final PlanItem planItem = outlineEntry.getElement();
        boolean markResolved = this.markAsResolved(planItem);
        this.fMarker = new GMarkerGadget(this, planItem, locationMarker);
        this.fNodeContent = new PlanItemNodeContent(this, outlineEntry, site, markResolved, isPlaceholder);
        this.setContent(this.fNodeContent);
        this.fId = new GLink(this, planItem.getId() == -1 ? Messages.PlanItemGadget_DRAFT_ITEM_ID_PLACEHOLDER : WorkItemTextUtilities.getWorkItemId((IWorkItem)planItem.getWorkItem(false)), 0);
        this.fId.setReturnParentElement(true);
        this.fId.setAction((IAction)new Action(){

            public void run() {
                WorkItemUI.open((IWorkbenchPage)site.getPage(), (Object)planItem.getWorkItemHandle());
            }
        });
        if (markResolved) {
            if (planItem.isResolved()) {
                this.fId.setStrikeOut(true);
            }
            this.fId.setColor(this.getPlanOutlineResources().getItemCompletedColor());
        }
    }

    protected boolean markAsResolved(PlanItem planItem) {
        return planItem.isAuxiliaryPlanItem() || planItem.isResolved();
    }

    public GText getSummary() {
        return ((IterationPlanItemNodeContent)this.getContent()).getSummary();
    }

    public GText getDescription() {
        return ((IterationPlanItemNodeContent)this.getContent()).getDescription();
    }

    public PlanItem getPlanItem() {
        return (PlanItem)((IterationPlanItemNodeContent)this.getContent()).getElement();
    }

    @Override
    protected Point arrangeContent(int x, int y, int wHint, int hHint) {
        PlanOutlineResources resources = this.getPlanOutlineResources();
        int top = ((IterationPlanItemNodeContent)this.getContent()).getInsets().top();
        this.fMarker.layout(x, y + top, wHint, hHint);
        int markerWidth = this.fMarker.getWidth();
        this.fMarker.move((this.getMarkerColumnWidth() - markerWidth) / 2, 0);
        Point parentSize = super.arrangeContent(x, y, wHint, hHint);
        this.fId.layout(x + parentSize.x + resources.getIdSpacing() - this.getIdColumnWidth(), y + top, this.getIdColumnWidth(), hHint);
        return parentSize;
    }

    @Override
    public int computeMinimalWidth() {
        return this.getMarkerColumnWidth() + super.computeMinimalWidth() + this.getIdColumnWidth();
    }

    @Override
    public GLink getLink() {
        return this.fId;
    }

    @Override
    public GMarkerGadget getMarkerGadget() {
        return this.fMarker;
    }

    private boolean showTopLevelItems() {
        Outline outline = this.getOutline();
        if (!(outline instanceof PlanItemOutline)) {
            return false;
        }
        PlanItemOutline pio = (PlanItemOutline)outline;
        return "NONE".equals(pio.getSettings().getGroupMode().getId());
    }
}

