/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.outliner;

import com.ibm.team.apt.internal.client.OutOfOfficeItem;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.ide.ui.ImagePool;
import com.ibm.team.apt.internal.ide.ui.common.GadgetFactory;
import com.ibm.team.apt.internal.ide.ui.common.IGadgetCreator;
import com.ibm.team.apt.internal.ide.ui.common.LocationMarker;
import com.ibm.team.apt.internal.ide.ui.common.PlanViewModel;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineEntry;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.ColorizeTag;
import com.ibm.team.apt.internal.ide.ui.common.structure.CategoryElement;
import com.ibm.team.apt.internal.ide.ui.common.structure.GroupFolderElement;
import com.ibm.team.apt.internal.ide.ui.common.structure.OwnerElement;
import com.ibm.team.apt.internal.ide.ui.common.structure.PlanModelTransformer;
import com.ibm.team.apt.internal.ide.ui.common.structure.PrimaryLocationTag;
import com.ibm.team.apt.internal.ide.ui.common.structure.TagElement;
import com.ibm.team.apt.internal.ide.ui.common.structure.TimeElement;
import com.ibm.team.apt.internal.ide.ui.common.structure.UnfilteredChildrenTag;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.CategoryGadget;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.FolderGadget;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.IterationPlanItemNodeContent;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.OutOfOfficeGadget;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.OutOfOfficeNodeContent;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.OwnerGadget;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.PlanItemGadget;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.TagGadget;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.TimeGadget;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.ContentOutlineItem;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GTreeNode;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GTreeNodeContent;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbenchPartSite;

public class PlanEditorGadgetFactory
extends GadgetFactory {
    private static final Image GROUP_EXPANDED = ImagePool.GROUP_EXPANDED.createImage();
    private static final Image GROUP_COLLAPSED = ImagePool.GROUP_COLLAPSED.createImage();

    public PlanEditorGadgetFactory(IWorkbenchPartSite site) {
        super(new IGadgetCreator[]{new PlanItemGadgetCreator(site), new CategoryElementGadgetCreator(), new OwnerElementGadgetCreator(), new TagElementGadgetCreator(), new FolderElementGadgetCreator(), new TimeElementGadgetCreator(), new OutOfOfficeItemGadgetCreator()});
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CategoryElementGadgetCreator
    implements IGadgetCreator<CategoryElement> {
        private CategoryElementGadgetCreator() {
        }

        @Override
        public Class<CategoryElement> getEntryType() {
            return CategoryElement.class;
        }

        @Override
        public GTreeNode<GTreeNodeContent> createGadget(ContentOutlineItem outlineItem, OutlineEntry<CategoryElement> entry) {
            return new CategoryGadget(outlineItem, entry, GROUP_COLLAPSED, GROUP_EXPANDED);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FolderElementGadgetCreator
    implements IGadgetCreator<GroupFolderElement> {
        private FolderElementGadgetCreator() {
        }

        @Override
        public Class<GroupFolderElement> getEntryType() {
            return GroupFolderElement.class;
        }

        @Override
        public GTreeNode<GTreeNodeContent> createGadget(ContentOutlineItem outlineItem, OutlineEntry<GroupFolderElement> entry) {
            return new FolderGadget(outlineItem, entry, GROUP_COLLAPSED, GROUP_EXPANDED);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OutOfOfficeItemGadgetCreator
    implements IGadgetCreator<OutOfOfficeItem> {
        private OutOfOfficeItemGadgetCreator() {
        }

        @Override
        public Class<OutOfOfficeItem> getEntryType() {
            return OutOfOfficeItem.class;
        }

        @Override
        public GTreeNode<OutOfOfficeNodeContent> createGadget(ContentOutlineItem outlineItem, OutlineEntry<OutOfOfficeItem> entry) {
            return new OutOfOfficeGadget(outlineItem, entry.getElement(), null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OwnerElementGadgetCreator
    implements IGadgetCreator<OwnerElement> {
        private OwnerElementGadgetCreator() {
        }

        @Override
        public Class<OwnerElement> getEntryType() {
            return OwnerElement.class;
        }

        @Override
        public GTreeNode<GTreeNodeContent> createGadget(ContentOutlineItem outlineItem, OutlineEntry<OwnerElement> entry) {
            return new OwnerGadget(outlineItem, entry, GROUP_COLLAPSED, GROUP_EXPANDED);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PlanItemGadgetCreator
    implements IGadgetCreator<PlanItem> {
        private final IWorkbenchPartSite fSite;

        public PlanItemGadgetCreator(IWorkbenchPartSite site) {
            this.fSite = site;
        }

        @Override
        public Class<PlanItem> getEntryType() {
            return PlanItem.class;
        }

        @Override
        public GTreeNode<IterationPlanItemNodeContent> createGadget(ContentOutlineItem outlineItem, OutlineEntry<PlanItem> entry) {
            List<ColorizeTag> colorTags = entry.getTags(ColorizeTag.class);
            return new PlanItemGadget(outlineItem, entry, this.fSite, colorTags, !entry.hasTag(PrimaryLocationTag.INSTANCE) || entry.hasTag(UnfilteredChildrenTag.INSTANCE), this.getLocationMarker(entry));
        }

        private LocationMarker getLocationMarker(OutlineEntry<PlanItem> entry) {
            PlanModelTransformer modelTransformer = (PlanModelTransformer)((PlanViewModel)entry.getModel()).getModelTransformer();
            return modelTransformer.calculateLocationMarker(entry);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TagElementGadgetCreator
    implements IGadgetCreator<TagElement> {
        private TagElementGadgetCreator() {
        }

        @Override
        public Class<TagElement> getEntryType() {
            return TagElement.class;
        }

        @Override
        public GTreeNode<GTreeNodeContent> createGadget(ContentOutlineItem outlineItem, OutlineEntry<TagElement> entry) {
            return new TagGadget(outlineItem, entry, GROUP_COLLAPSED, GROUP_EXPANDED);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TimeElementGadgetCreator
    implements IGadgetCreator<TimeElement> {
        private TimeElementGadgetCreator() {
        }

        @Override
        public Class<TimeElement> getEntryType() {
            return TimeElement.class;
        }

        @Override
        public GTreeNode<GTreeNodeContent> createGadget(ContentOutlineItem outlineItem, OutlineEntry<TimeElement> entry) {
            return new TimeGadget(outlineItem, entry, GROUP_COLLAPSED, GROUP_EXPANDED);
        }
    }
}

