/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.outliner;

import com.ibm.team.apt.internal.client.ILoadListener;
import com.ibm.team.apt.internal.client.IterationPlanSequenceManager;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.ResolvedIterationPlan;
import com.ibm.team.apt.internal.client.teamload.LoadInformation;
import com.ibm.team.apt.internal.client.teamload.LoadItem;
import com.ibm.team.apt.internal.common.Iterations;
import com.ibm.team.apt.internal.common.ProgressInformation;
import com.ibm.team.apt.internal.common.ProgressItem;
import com.ibm.team.apt.internal.ide.ui.common.PlanOutlineResources;
import com.ibm.team.apt.internal.ide.ui.common.PlanViewModel;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.GroupGadget;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.GroupNodeContent;
import com.ibm.team.apt.internal.ide.ui.common.model.IEntryVisitor;
import com.ibm.team.apt.internal.ide.ui.common.model.IOutlineModelReader;
import com.ibm.team.apt.internal.ide.ui.common.model.ModelReadRunnable;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineEntry;
import com.ibm.team.apt.internal.ide.ui.common.structure.GroupElement;
import com.ibm.team.apt.internal.ide.ui.common.structure.OwnerElement;
import com.ibm.team.apt.internal.ide.ui.common.structure.PrimaryLocationTag;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.IPlanOutlineSettings;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.PlanItemOutline;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.ProgressMode;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.BarGadget;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.CompositeGadget;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.ContentOutlineItem;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GContributorPhoto;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GDeferredImage;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GLoadBar;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GProgressBar;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GTreeNode;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Outline;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OwnerGadget
extends GroupGadget {
    public OwnerGadget(ContentOutlineItem item, OutlineEntry<OwnerElement> groupEntry, Image collapsed, Image expanded) {
        super(item, collapsed, expanded, 0x1000000);
        this.setContent(new NodeContent(this, groupEntry));
    }

    public IContributor getOwner() {
        return (IContributor)this.getElement();
    }

    public GDeferredImage getImage() {
        return ((NodeContent)this.getContent()).fImage;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodeContent
    extends GroupNodeContent {
        private final ILoadListener fListener = new ILoadListener(){

            public void loadItemChanged(LoadItem item) {
                Outline outline = NodeContent.this.getOutline();
                if (outline != null) {
                    UI.asyncExec((Control)outline, new Runnable(){

                        public void run() {
                            if (NodeContent.this.fBarGadget.isDisposed()) {
                                return;
                            }
                            NodeContent.this.fBarGadget.refresh();
                        }
                    });
                }
            }
        };
        private OutlineEntry<? extends GroupElement> fEntry;
        private IContributor fOwner;
        private GDeferredImage fImage;
        private BarGadget fBarGadget;
        private LoadItem fLoadItem;
        private ProgressInformation fProgressInformation;

        public NodeContent(GTreeNode parent, OutlineEntry<OwnerElement> groupEntry) {
            super(parent, groupEntry, parent.getOutlineResources().getStandardLabelProvider().getText((Object)groupEntry.getElement().getOwner()));
            LoadItem item;
            LoadInformation information;
            this.fOwner = groupEntry.getElement().getOwner();
            PlanOutlineResources resources = (PlanOutlineResources)this.getOutlineResources();
            this.fImage = new GContributorPhoto((CompositeGadget)this, (IContributorHandle)this.fOwner, resources.getOwnerImageFuture(parent.getOutline().getDisplay(), this.fOwner), resources);
            this.fImage.setReturnParentElement(true);
            this.fStatusLabel.setFont(resources.getGroupStatusFont());
            this.fLoadItem = null;
            ResolvedIterationPlan input = (ResolvedIterationPlan)((PlanViewModel)groupEntry.getModel()).getInput();
            IIteration iteration = input.getInterval();
            if (iteration != null && (information = input.getLoadInformation((IIterationHandle)iteration)) != null && (item = information.getLoadItem((IContributorHandle)this.fOwner)) != null) {
                this.fLoadItem = item;
            }
            if (this.getSettings().getOwnerProgressMode() == ProgressMode.LOAD) {
                if (this.fLoadItem != null) {
                    this.fLoadItem.getLoadInformation().addTeamLoadListener(this.fListener);
                    this.fBarGadget = new GLoadBar(this, this.fLoadItem);
                    this.fBarGadget.setReturnParentElement(true);
                }
            } else if (this.getSettings().getOwnerProgressMode() == ProgressMode.PROGRESS) {
                IterationPlanSequenceManager itemSequenceManager;
                ProgressInformation progressInformation = this.getProgressInformation();
                if (iteration != null && Iterations.hasDates((IIteration)iteration) && (itemSequenceManager = input.getItemSequenceManager((IContributorHandle)this.fOwner)) != null) {
                    long workTime = itemSequenceManager.calculateWorkTime(iteration.getStartDate(), iteration.getEndDate());
                    long remainingWorkTime = itemSequenceManager.calculateRemainingWorkTime(iteration.getEndDate());
                    double assignment = 1.0;
                    if (this.fLoadItem != null) {
                        assignment = Math.min(1.0, Math.max(0.0, (double)this.fLoadItem.getAssignment() / 100.0));
                    }
                    progressInformation.deltaRealTimeDone((long)((double)Math.max(0L, workTime - remainingWorkTime) * assignment));
                    progressInformation.deltaRealTimeLeft((long)((double)remainingWorkTime * assignment));
                }
                this.fBarGadget = new GProgressBar(this, ProgressItem.create((ProgressInformation)progressInformation), true);
                this.fBarGadget.setReturnParentElement(true);
            }
        }

        @Override
        protected int[] getOpenCloseCount(OutlineEntry<? extends GroupElement> groupEntry) {
            if (this.getSettings().getOwnerProgressMode() == ProgressMode.LOAD) {
                return super.getOpenCloseCount(groupEntry);
            }
            if (this.fEntry == null) {
                this.fEntry = groupEntry;
            }
            ProgressInformation info = this.getProgressInformation();
            return new int[]{info.getOpenCount(), info.getCloseCount()};
        }

        @Override
        public void dispose() {
            if (this.fLoadItem != null) {
                this.fLoadItem.getLoadInformation().removeTeamLoadListener(this.fListener);
            }
            super.dispose();
        }

        @Override
        public Object getElement() {
            return this.fOwner;
        }

        @Override
        public int computeMinimalWidth() {
            PlanOutlineResources resources = this.getPlanOutlineResources();
            return 32 + resources.getIconSummarySpacing() + super.computeMinimalWidth() + (this.fBarGadget != null ? 2 * resources.getSpaceWidth() + this.fBarGadget.computeMinimalWidth() : 0);
        }

        @Override
        protected Point arrangeContent(int x, int y, int wHint, int hHint) {
            Point parent = super.arrangeContent(x, y, wHint, hHint);
            this.fImage.layout(x, y, 32, 32);
            int imageIndent = this.fImage.getWidth() + ((PlanOutlineResources)this.getOutlineResources()).getIconSummarySpacing();
            this.fNameLabel.move(imageIndent, 0);
            this.fStatusLabel.move(imageIndent, 0);
            int frontHeight = parent.y;
            if (parent.y < this.fImage.getHeight()) {
                this.fStatusLabel.move(0, this.fImage.getHeight() - parent.y);
                frontHeight = this.fImage.getHeight();
            } else if (this.fImage.getHeight() < parent.y) {
                this.fImage.move(0, (parent.y - this.fImage.getHeight()) / 2);
            }
            int frontWidth = imageIndent + this.max(this.fNameLabel.getWidth(), this.fStatusLabel.getWidth());
            if (this.fBarGadget != null) {
                PlanOutlineResources resources = this.getPlanOutlineResources();
                this.fBarGadget.layout(x, y, -1, -1);
                this.fBarGadget.move(wHint != -1 ? this.max(0, wHint - this.fBarGadget.getWidth()) : x + parent.x, 0);
                int barHeight = this.fBarGadget.getHeight();
                if (frontHeight > barHeight) {
                    int visualFrontHeight = barHeight - this.fBarGadget.computeTopSpacing();
                    int delta = this.max(0, (frontHeight - visualFrontHeight) / 2 - this.fBarGadget.computeTopSpacing());
                    this.fBarGadget.move(0, delta);
                } else if (barHeight > frontHeight) {
                    this.fImage.move(0, (barHeight - frontHeight) / 2);
                    this.fStatusLabel.move(0, barHeight - frontHeight);
                }
                return new Point(this.max(wHint, frontWidth + 2 * resources.getSpaceWidth() + this.fBarGadget.getWidth()), this.max(hHint, frontHeight, barHeight));
            }
            return new Point(this.max(wHint, frontWidth), this.max(hHint, frontHeight));
        }

        private IPlanOutlineSettings getSettings() {
            return ((PlanItemOutline)this.getOutline()).getSettings();
        }

        private ProgressInformation getProgressInformation() {
            if (this.fProgressInformation == null) {
                this.fProgressInformation = this.computeProgressInformation();
            }
            return this.fProgressInformation;
        }

        private ProgressInformation computeProgressInformation() {
            return this.fEntry.getModel().readModel(new ModelReadRunnable<ProgressInformation, RuntimeException>(){

                @Override
                public ProgressInformation run(IOutlineModelReader readAccessor) throws RuntimeException {
                    final ProgressInformation result = new ProgressInformation();
                    readAccessor.accept(NodeContent.this.fEntry, new IEntryVisitor(){

                        @Override
                        public boolean visit(OutlineEntry<?> entry) {
                            Object element = entry.getElement();
                            if (!(element instanceof PlanItem)) {
                                return true;
                            }
                            PlanItem planItem = (PlanItem)element;
                            if (entry.hasTag(PrimaryLocationTag.INSTANCE)) {
                                planItem.updateProgresInformation(result);
                            }
                            return true;
                        }
                    });
                    return result;
                }
            });
        }
    }
}

