/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.outliner;

import com.ibm.team.apt.internal.ide.ui.common.IOutlineSettingsListener;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryFilter;
import com.ibm.team.apt.internal.ide.ui.common.model.IOutlineModelReader;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineEntry;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.IPlanOutlineSettings;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.OutlineFilterDescriptor;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.PlanOutlineSettingsListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutlineViewerFilter
extends EntryFilter {
    private List<OutlineFilterDescriptor> fActiveFilters;
    private final IPlanOutlineSettings fSettings;
    private final IOutlineSettingsListener fSettingsListener = new PlanOutlineSettingsListener(){

        public void refresh() {
            OutlineViewerFilter.this.fSettings.getActiveFilters(OutlineFilterDescriptor.FilterType.ALL);
            OutlineViewerFilter.this.fActiveFilters.clear();
            OutlineViewerFilter.this.fActiveFilters.addAll((Collection)Arrays.asList(OutlineViewerFilter.this.fSettings.getActiveFilters(OutlineFilterDescriptor.FilterType.ALL)));
        }

        public void filterChanged(OutlineFilterDescriptor filter, boolean active) {
            if (active) {
                OutlineViewerFilter.this.fActiveFilters.add(filter);
            } else {
                OutlineViewerFilter.this.fActiveFilters.remove(filter);
            }
        }
    };

    public OutlineViewerFilter(IPlanOutlineSettings planOutlineSettings) {
        this.fActiveFilters = new ArrayList<OutlineFilterDescriptor>();
        this.fSettings = planOutlineSettings;
        this.fSettings.addSettingsChangeListener(this.fSettingsListener);
    }

    public void dispose() {
        this.fSettings.removeSettingsChangeListener(this.fSettingsListener);
    }

    @Override
    public boolean isFilterProperty(OutlineEntry<?> entry, String property) {
        int i = 0;
        while (i < this.fActiveFilters.size()) {
            OutlineFilterDescriptor filter = this.fActiveFilters.get(i);
            if (filter.isFilterProperty(entry, property)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean select(OutlineEntry<?> entry, IOutlineModelReader readAccessor) {
        boolean isTagSelected = true;
        for (OutlineFilterDescriptor filter : this.fActiveFilters) {
            if (!filter.isFilterType(OutlineFilterDescriptor.FilterType.TAGS)) continue;
            isTagSelected = false;
            break;
        }
        int i = 0;
        while (!isTagSelected && i < this.fActiveFilters.size()) {
            OutlineFilterDescriptor filter = this.fActiveFilters.get(i);
            if (filter.isFilterType(OutlineFilterDescriptor.FilterType.TAGS)) {
                isTagSelected = filter.select(entry, readAccessor);
            }
            ++i;
        }
        if (isTagSelected) {
            OutlineFilterDescriptor filter;
            boolean filtersPassed = true;
            int i2 = 0;
            while (filtersPassed && i2 < this.fActiveFilters.size()) {
                filter = this.fActiveFilters.get(i2);
                if (filter.isFilterType(OutlineFilterDescriptor.FilterType.REGULAR) && !filter.isFilterType(OutlineFilterDescriptor.FilterType.POST)) {
                    filtersPassed &= filter.select(entry, readAccessor);
                }
                ++i2;
            }
            i2 = 0;
            while (filtersPassed && i2 < this.fActiveFilters.size()) {
                filter = this.fActiveFilters.get(i2);
                if (filter.isFilterType(OutlineFilterDescriptor.FilterType.POST)) {
                    filtersPassed &= filter.select(entry, readAccessor);
                }
                ++i2;
            }
            return filtersPassed;
        }
        return false;
    }
}

