/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.outliner;

import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryUtils;
import com.ibm.team.apt.internal.ide.ui.common.model.IOutlineModelReader;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineEntry;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.Messages;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.OutlineFilterDescriptor;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotDueTodayFilterDescriptor
extends OutlineFilterDescriptor {
    private static final String ID = "FILTER_NOT_DUE_TODAY";

    public NotDueTodayFilterDescriptor() {
        super(ID, Messages.NotDueTodayFilterDescriptor_LABEL, Messages.NotDueTodayFilterDescriptor_DESCRIPTION);
    }

    @Override
    public boolean select(OutlineEntry<?> entry, IOutlineModelReader readAccessor) {
        if (!EntryUtils.isType(entry, PlanItem.class)) {
            return true;
        }
        PlanItem item = (PlanItem)entry.getElement();
        Timestamp dueDate = item.getDueDate();
        return dueDate != null && this.trimToDay(((Date)dueDate).getTime()) == this.trimToDay(item.getPlan().getReferenceTime().getTime());
    }

    private long trimToDay(long date) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }

    @Override
    public boolean isFilterType(OutlineFilterDescriptor.FilterType filterType) {
        return filterType == OutlineFilterDescriptor.FilterType.REGULAR;
    }

    @Override
    public boolean isFilterProperty(OutlineEntry<?> entry, String property) {
        return PlanItem.DUE_DATE.getName().equals(property);
    }
}

